/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.configs;

import com.telepathicgrunt.repurposedstructures.utils.ConfigHelper;
import net.minecraftforge.common.ForgeConfigSpec;

public class RSWellsConfig {

    public static class RSWellsConfigValues {
        public ConfigHelper.ConfigValueListener<Boolean> addWellsToModdedBiomes;
        public ConfigHelper.ConfigValueListener<Boolean> canHaveBells;
        public ConfigHelper.ConfigValueListener<Integer> badlandsWellRarityPerChunk;
        public ConfigHelper.ConfigValueListener<Integer> netherWellRarityPerChunk;
        public ConfigHelper.ConfigValueListener<Integer> snowWellRarityPerChunk;
        public ConfigHelper.ConfigValueListener<Integer> mossyStoneWellRarityPerChunk;
        public ConfigHelper.ConfigValueListener<Integer> forestWellRarityPerChunk;
        public ConfigHelper.ConfigValueListener<Integer> mushroomWellRarityPerChunk;
        public ConfigHelper.ConfigValueListener<String> blacklistedWellBiomes;

        public RSWellsConfigValues(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber) {
            builder.push("Small Wells");
            this.addWellsToModdedBiomes = subscriber.subscribe(builder.comment("\n Add the custom wells to modded biomes of the same categories/type.").translation("repurposedstructures.config.smallwells.addwellstomoddedbiomes").define("addWellsToModdedBiomes", true));
            this.canHaveBells = subscriber.subscribe(builder.comment("\n Determines if Wells can have a chance of spawning a Bell.").translation("repurposedstructures.config.smallwells.canhavebells").define("canHaveBells", true));
            this.blacklistedWellBiomes = subscriber.subscribe(builder.comment(new String[]{"\n Add the ID/resource location of the biome you don't want", " RS's wells to spawn in. Separate each ID with a comma ,", "   Example: \"minecraft:ice_spikes,awesome_mod:awesome_biome\""}).translation("repurposedstructures.config.smallwells.blacklistedwellbiomes").define("blacklistedWellBiomes", (Object)" "));
            builder.push("RarityPerChunk");
            this.badlandsWellRarityPerChunk = subscriber.subscribe(builder.comment(new String[]{"\n Adds Badlands themed wells to Badlands biomes.", " This effects how often wells will attempt to spawn per chunk.", " The chance of a well generating at a chunk is 1/rarityPerChunk.", " 1 for wells spawning in every chunk and 10000 for no wells."}).translation("repurposedstructures.config.smallwells.badlandswellrarityperchunk").defineInRange("badlandsWellRarityPerChunk", 250, 1, 10000));
            this.netherWellRarityPerChunk = subscriber.subscribe(builder.comment(new String[]{"\n Adds Nether themed wells to Nether biomes.", " This effects how often wells will attempt to spawn per chunk.", " The chance of a well generating at a chunk is 1/rarityPerChunk.", " 1 for wells spawning in every chunk and 10000 for no wells."}).translation("repurposedstructures.config.smallwells.netherwellrarityperchunk").defineInRange("netherWellRarityPerChunk", 200, 1, 10000));
            this.snowWellRarityPerChunk = subscriber.subscribe(builder.comment(new String[]{"\n Adds Snow themed wells to snowy and icy biomes.", " This effects how often wells will attempt to spawn per chunk.", " The chance of a well generating at a chunk is 1/rarityPerChunk.", " 1 for wells spawning in every chunk and 10000 for no wells."}).translation("repurposedstructures.config.smallwells.snowwellrarityperchunk").defineInRange("snowWellRarityPerChunk", 350, 1, 10000));
            this.mossyStoneWellRarityPerChunk = subscriber.subscribe(builder.comment(new String[]{"\n Adds mossy stone themed wells to Jungles, Dark Oak, and Swamp biomes.", " This effects how often wells will attempt to spawn per chunk.", " The chance of a well generating at a chunk is 1/rarityPerChunk.", " 1 for wells spawning in every chunk and 10000 for no wells."}).translation("repurposedstructures.config.smallwells.mossystonewellrarityperchunk").defineInRange("mossyStoneWellRarityPerChunk", 350, 1, 10000));
            this.forestWellRarityPerChunk = subscriber.subscribe(builder.comment(new String[]{"\n Adds a wood themed wells to Forest and Birch Forest biomes.", " This effects how often wells will attempt to spawn per chunk.", " The chance of a well generating at a chunk is 1/rarityPerChunk.", " 1 for wells spawning in every chunk and 10000 for no wells."}).translation("repurposedstructures.config.smallwells.forestwellrarityperchunk").defineInRange("forestWellRarityPerChunk", 350, 1, 10000));
            this.mushroomWellRarityPerChunk = subscriber.subscribe(builder.comment(new String[]{"\n Adds a mushroom themed wells to Mushroom biomes.", " This effects how often wells will attempt to spawn per chunk.", " The chance of a well generating at a chunk is 1/rarityPerChunk.", " 1 for wells spawning in every chunk and 10000 for no wells."}).translation("repurposedstructures.config.smallwells.mushroomwellrarityperchunk").defineInRange("mushroomWellRarityPerChunk", 350, 1, 10000));
            builder.pop();
            builder.pop();
        }
    }
}

