/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.modinit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixin.PillagerOutpostStructureAccessor;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructurePieces;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.BuriableStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.CityNetherStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericNetherJigsawHighStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.LandBasedEndStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.MansionStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.OutpostNetherStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.RSMineshaftEndStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.RSMineshaftStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.RSNetherStrongholdStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.ShipwreckEndStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.ShipwreckNetherStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.TempleNetherStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.VillageNetherStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.NetherShipwreckConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MansionPieces;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.StructurePiecesBehavior;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RSStructures {
    public static final DeferredRegister<Structure<?>> STRUCTURE_FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"repurposed_structures");
    public static final Map<Structure<?>, StructureSeparationSettings> RS_STRUCTURES = new HashMap();
    public static final Set<ResourceLocation> RS_STRUCTURE_START_PIECES = new HashSet<ResourceLocation>();
    public static RegistryObject<Structure<NoFeatureConfig>> BIRCH_MINESHAFT = RSStructures.addToStructureMaps("mineshaft_birch", () -> new RSMineshaftStructure(new ResourceLocation("repurposed_structures", "mineshafts/birch/start_pool"), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.birchMineshaftSize.get()), (Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>)ImmutableMap.of((Object)new ResourceLocation("repurposed_structures", "mineshafts/birch/spawner_4_end"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(1, (Lazy<Integer>)Lazy.of(() -> Math.min(5, RepurposedStructures.RSMineshaftsConfig.birchMineshaftSize.get())))), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.birchMineshaftMaxHeight.get()), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.birchMineshaftMinHeight.get()), (Lazy<Float>)Lazy.of(() -> Float.valueOf(RepurposedStructures.RSMineshaftsConfig.birchMineshaftSpawnrate.get().floatValue())), RSMineshaftStructure.ENVIRONMENT_CHECK.LIQUID));
    public static RegistryObject<Structure<NoFeatureConfig>> DARK_FOREST_MINESHAFT = RSStructures.addToStructureMaps("mineshaft_dark_forest", () -> new RSMineshaftStructure(new ResourceLocation("repurposed_structures", "mineshafts/dark_forest/start_pool"), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.darkForestMineshaftSize.get()), (Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>)ImmutableMap.of((Object)new ResourceLocation("repurposed_structures", "mineshafts/dark_forest/spawner_4_end"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(1, (Lazy<Integer>)Lazy.of(() -> Math.min(5, RepurposedStructures.RSMineshaftsConfig.darkForestMineshaftSize.get())))), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.darkForestMineshaftMaxHeight.get()), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.darkForestMineshaftMinHeight.get()), (Lazy<Float>)Lazy.of(() -> Float.valueOf(RepurposedStructures.RSMineshaftsConfig.darkForestMineshaftSpawnrate.get().floatValue())), RSMineshaftStructure.ENVIRONMENT_CHECK.LIQUID));
    public static RegistryObject<Structure<NoFeatureConfig>> DESERT_MINESHAFT = RSStructures.addToStructureMaps("mineshaft_desert", () -> new RSMineshaftStructure(new ResourceLocation("repurposed_structures", "mineshafts/desert/start_pool"), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.desertMineshaftSize.get()), (Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>)ImmutableMap.of((Object)new ResourceLocation("repurposed_structures", "mineshafts/desert/spawner_4_end"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(1, (Lazy<Integer>)Lazy.of(() -> Math.min(5, RepurposedStructures.RSMineshaftsConfig.desertMineshaftSize.get())))), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.desertMineshaftMaxHeight.get()), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.desertMineshaftMinHeight.get()), (Lazy<Float>)Lazy.of(() -> Float.valueOf(RepurposedStructures.RSMineshaftsConfig.desertMineshaftSpawnrate.get().floatValue())), RSMineshaftStructure.ENVIRONMENT_CHECK.LIQUID));
    public static RegistryObject<Structure<NoFeatureConfig>> END_MINESHAFT = RSStructures.addToStructureMaps("mineshaft_end", () -> new RSMineshaftEndStructure(new ResourceLocation("repurposed_structures", "mineshafts/end/start_pool"), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.endMineshaftSize.get()), (Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>)ImmutableMap.of((Object)new ResourceLocation("repurposed_structures", "mineshafts/end/spawner_4_end"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(1, (Lazy<Integer>)Lazy.of(() -> Math.min(5, RepurposedStructures.RSMineshaftsConfig.endMineshaftSize.get())))), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.endMineshaftMaxHeight.get()), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.endMineshaftMinHeight.get()), (Lazy<Float>)Lazy.of(() -> Float.valueOf(RepurposedStructures.RSMineshaftsConfig.endMineshaftSpawnrate.get().floatValue())), RSMineshaftStructure.ENVIRONMENT_CHECK.NONE));
    public static RegistryObject<Structure<NoFeatureConfig>> NETHER_MINESHAFT = RSStructures.addToStructureMaps("mineshaft_nether", () -> new RSMineshaftStructure(new ResourceLocation("repurposed_structures", "mineshafts/nether/start_pool"), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.netherMineshaftSize.get()), (Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>)ImmutableMap.of((Object)new ResourceLocation("repurposed_structures", "mineshafts/nether/spawner_4_end"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(1, (Lazy<Integer>)Lazy.of(() -> Math.min(5, RepurposedStructures.RSMineshaftsConfig.netherMineshaftSize.get())))), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.netherMineshaftMaxHeight.get()), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.netherMineshaftMinHeight.get()), (Lazy<Float>)Lazy.of(() -> Float.valueOf(RepurposedStructures.RSMineshaftsConfig.netherMineshaftSpawnrate.get().floatValue())), RSMineshaftStructure.ENVIRONMENT_CHECK.NONE));
    public static RegistryObject<Structure<NoFeatureConfig>> CRIMSON_MINESHAFT = RSStructures.addToStructureMaps("mineshaft_crimson", () -> new RSMineshaftStructure(new ResourceLocation("repurposed_structures", "mineshafts/crimson/start_pool"), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.crimsonMineshaftSize.get()), (Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>)ImmutableMap.of((Object)new ResourceLocation("repurposed_structures", "mineshafts/crimson/spawner_4_end"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(1, (Lazy<Integer>)Lazy.of(() -> Math.min(5, RepurposedStructures.RSMineshaftsConfig.crimsonMineshaftSize.get())))), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.crimsonMineshaftMaxHeight.get()), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.crimsonMineshaftMinHeight.get()), (Lazy<Float>)Lazy.of(() -> Float.valueOf(RepurposedStructures.RSMineshaftsConfig.crimsonMineshaftSpawnrate.get().floatValue())), RSMineshaftStructure.ENVIRONMENT_CHECK.NONE));
    public static RegistryObject<Structure<NoFeatureConfig>> WARPED_MINESHAFT = RSStructures.addToStructureMaps("mineshaft_warped", () -> new RSMineshaftStructure(new ResourceLocation("repurposed_structures", "mineshafts/warped/start_pool"), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.warpedMineshaftSize.get()), (Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>)ImmutableMap.of((Object)new ResourceLocation("repurposed_structures", "mineshafts/warped/spawner_4_end"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(1, (Lazy<Integer>)Lazy.of(() -> Math.min(5, RepurposedStructures.RSMineshaftsConfig.warpedMineshaftSize.get())))), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.warpedMineshaftMaxHeight.get()), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.warpedMineshaftMinHeight.get()), (Lazy<Float>)Lazy.of(() -> Float.valueOf(RepurposedStructures.RSMineshaftsConfig.warpedMineshaftSpawnrate.get().floatValue())), RSMineshaftStructure.ENVIRONMENT_CHECK.NONE));
    public static RegistryObject<Structure<NoFeatureConfig>> ICY_MINESHAFT = RSStructures.addToStructureMaps("mineshaft_icy", () -> new RSMineshaftStructure(new ResourceLocation("repurposed_structures", "mineshafts/icy/start_pool"), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.icyMineshaftSize.get()), (Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>)ImmutableMap.of((Object)new ResourceLocation("repurposed_structures", "mineshafts/icy/spawner_4_end"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(1, (Lazy<Integer>)Lazy.of(() -> Math.min(5, RepurposedStructures.RSMineshaftsConfig.icyMineshaftSize.get())))), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.icyMineshaftMaxHeight.get()), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.icyMineshaftMinHeight.get()), (Lazy<Float>)Lazy.of(() -> Float.valueOf(RepurposedStructures.RSMineshaftsConfig.icyMineshaftSpawnrate.get().floatValue())), RSMineshaftStructure.ENVIRONMENT_CHECK.LIQUID));
    public static RegistryObject<Structure<NoFeatureConfig>> JUNGLE_MINESHAFT = RSStructures.addToStructureMaps("mineshaft_jungle", () -> new RSMineshaftStructure(new ResourceLocation("repurposed_structures", "mineshafts/jungle/start_pool"), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.jungleMineshaftSize.get()), (Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>)ImmutableMap.of((Object)new ResourceLocation("repurposed_structures", "mineshafts/jungle/spawner_4_end"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(1, (Lazy<Integer>)Lazy.of(() -> Math.min(5, RepurposedStructures.RSMineshaftsConfig.jungleMineshaftSize.get())))), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.jungleMineshaftMaxHeight.get()), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.jungleMineshaftMinHeight.get()), (Lazy<Float>)Lazy.of(() -> Float.valueOf(RepurposedStructures.RSMineshaftsConfig.jungleMineshaftSpawnrate.get().floatValue())), RSMineshaftStructure.ENVIRONMENT_CHECK.LIQUID));
    public static RegistryObject<Structure<NoFeatureConfig>> OCEAN_MINESHAFT = RSStructures.addToStructureMaps("mineshaft_ocean", () -> new RSMineshaftStructure(new ResourceLocation("repurposed_structures", "mineshafts/ocean/start_pool"), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.oceanMineshaftSize.get()), (Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>)ImmutableMap.of((Object)new ResourceLocation("repurposed_structures", "mineshafts/ocean/spawner_4_end"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(1, (Lazy<Integer>)Lazy.of(() -> Math.min(5, RepurposedStructures.RSMineshaftsConfig.oceanMineshaftSize.get())))), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.oceanMineshaftMaxHeight.get()), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.oceanMineshaftMinHeight.get()), (Lazy<Float>)Lazy.of(() -> Float.valueOf(RepurposedStructures.RSMineshaftsConfig.oceanMineshaftSpawnrate.get().floatValue())), RSMineshaftStructure.ENVIRONMENT_CHECK.AIR));
    public static RegistryObject<Structure<NoFeatureConfig>> SAVANNA_MINESHAFT = RSStructures.addToStructureMaps("mineshaft_savanna", () -> new RSMineshaftStructure(new ResourceLocation("repurposed_structures", "mineshafts/savanna/start_pool"), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.savannaMineshaftSize.get()), (Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>)ImmutableMap.of((Object)new ResourceLocation("repurposed_structures", "mineshafts/savanna/spawner_4_end"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(1, (Lazy<Integer>)Lazy.of(() -> Math.min(5, RepurposedStructures.RSMineshaftsConfig.savannaMineshaftSize.get())))), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.savannaMineshaftMaxHeight.get()), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.savannaMineshaftMinHeight.get()), (Lazy<Float>)Lazy.of(() -> Float.valueOf(RepurposedStructures.RSMineshaftsConfig.savannaMineshaftSpawnrate.get().floatValue())), RSMineshaftStructure.ENVIRONMENT_CHECK.LIQUID));
    public static RegistryObject<Structure<NoFeatureConfig>> STONE_MINESHAFT = RSStructures.addToStructureMaps("mineshaft_stone", () -> new RSMineshaftStructure(new ResourceLocation("repurposed_structures", "mineshafts/stone/start_pool"), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.stoneMineshaftSize.get()), (Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>)ImmutableMap.of((Object)new ResourceLocation("repurposed_structures", "mineshafts/stone/spawner_4_end"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(1, (Lazy<Integer>)Lazy.of(() -> Math.min(5, RepurposedStructures.RSMineshaftsConfig.stoneMineshaftSize.get())))), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.stoneMineshaftMaxHeight.get()), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.stoneMineshaftMinHeight.get()), (Lazy<Float>)Lazy.of(() -> Float.valueOf(RepurposedStructures.RSMineshaftsConfig.stoneMineshaftSpawnrate.get().floatValue())), RSMineshaftStructure.ENVIRONMENT_CHECK.LIQUID));
    public static RegistryObject<Structure<NoFeatureConfig>> SWAMP_MINESHAFT = RSStructures.addToStructureMaps("mineshaft_swamp_forest", () -> new RSMineshaftStructure(new ResourceLocation("repurposed_structures", "mineshafts/swamp/start_pool"), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.swampMineshaftSize.get()), (Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>)ImmutableMap.of((Object)new ResourceLocation("repurposed_structures", "mineshafts/swamp/spawner_4_end"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(1, (Lazy<Integer>)Lazy.of(() -> Math.min(5, RepurposedStructures.RSMineshaftsConfig.swampMineshaftSize.get())))), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.swampMineshaftMaxHeight.get()), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.swampMineshaftMinHeight.get()), (Lazy<Float>)Lazy.of(() -> Float.valueOf(RepurposedStructures.RSMineshaftsConfig.swampMineshaftSpawnrate.get().floatValue())), RSMineshaftStructure.ENVIRONMENT_CHECK.LIQUID));
    public static RegistryObject<Structure<NoFeatureConfig>> TAIGA_MINESHAFT = RSStructures.addToStructureMaps("mineshaft_taiga", () -> new RSMineshaftStructure(new ResourceLocation("repurposed_structures", "mineshafts/taiga/start_pool"), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.taigaMineshaftSize.get()), (Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>)ImmutableMap.of((Object)new ResourceLocation("repurposed_structures", "mineshafts/taiga/spawner_4_end"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(1, (Lazy<Integer>)Lazy.of(() -> Math.min(5, RepurposedStructures.RSMineshaftsConfig.taigaMineshaftSize.get())))), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.taigaMineshaftMaxHeight.get()), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMineshaftsConfig.taigaMineshaftMinHeight.get()), (Lazy<Float>)Lazy.of(() -> Float.valueOf(RepurposedStructures.RSMineshaftsConfig.taigaMineshaftSpawnrate.get().floatValue())), RSMineshaftStructure.ENVIRONMENT_CHECK.LIQUID));
    public static final RegistryObject<Structure<NoFeatureConfig>> NETHER_STRONGHOLD = RSStructures.addToStructureMaps("stronghold_nether", () -> new RSNetherStrongholdStructure(new ResourceLocation("repurposed_structures", "strongholds/nether/start_pool"), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSStrongholdsConfig.netherStrongholdSize.get()), (Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>)ImmutableMap.of((Object)new ResourceLocation("repurposed_structures", "strongholds/nether/portal_room"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(1, (Lazy<Integer>)Lazy.of(() -> (int)((double)RepurposedStructures.RSStrongholdsConfig.netherStrongholdSize.get().intValue() * 0.6)))), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSStrongholdsConfig.netherStrongholdMaxHeight.get()), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSStrongholdsConfig.netherStrongholdMinHeight.get())));
    public static final RegistryObject<Structure<NoFeatureConfig>> JUNGLE_FORTRESS = RSStructures.addToStructureMaps("fortress_jungle", () -> new AdvancedJigsawStructure(new ResourceLocation("repurposed_structures", "fortresses/jungle/start_pool"), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMainConfig.jungleFortressSize.get()), (Lazy<Integer>)Lazy.of(() -> 4), Lists.newArrayList((Object[])new MobSpawnInfo.Spawners[]{new MobSpawnInfo.Spawners(EntityType.field_200722_aA, 27, 1, 1)}), (Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>)ImmutableMap.of((Object)new ResourceLocation("repurposed_structures", "fortresses/jungle/spawner"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(2, (Lazy<Integer>)Lazy.of(() -> (int)((double)RepurposedStructures.RSMainConfig.jungleFortressSize.get().intValue() * 0.6))), (Object)new ResourceLocation("repurposed_structures", "fortresses/jungle/balcony"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(1, (Lazy<Integer>)Lazy.of(() -> (int)((double)RepurposedStructures.RSMainConfig.jungleFortressSize.get().intValue() * 0.2))), (Object)new ResourceLocation("repurposed_structures", "fortresses/jungle/turn_inside_chest"), (Object)new StructurePiecesBehavior.RequiredPieceNeeds(4, (Lazy<Integer>)Lazy.of(() -> (int)((double)RepurposedStructures.RSMainConfig.jungleFortressSize.get().intValue() * 0.6)))), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMainConfig.jungleFortressMaxHeight.get()), (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMainConfig.jungleFortressMinHeight.get()), false, (Lazy<Integer>)Lazy.of(() -> RepurposedStructures.RSMainConfig.jungleFortressVerticalRange.get())));
    public static final RegistryObject<Structure<NoFeatureConfig>> GRASSY_IGLOO = RSStructures.addToStructureMaps("igloo_grassy", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "igloos/grassy_top"), 20, 0, 0, 0, new HashSet<RSStructureTagMap.STRUCTURE_TAGS>()));
    public static final RegistryObject<Structure<NoFeatureConfig>> STONE_IGLOO = RSStructures.addToStructureMaps("igloo_stone", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "igloos/stone_top"), 20, 0, 0, 0, new HashSet<RSStructureTagMap.STRUCTURE_TAGS>()));
    public static final RegistryObject<Structure<NoFeatureConfig>> NETHER_WASTELAND_TEMPLE = RSStructures.addToStructureMaps("temple_nether_wasteland", () -> new TempleNetherStructure(new ResourceLocation("repurposed_structures", "temples/temple_nether_wasteland")));
    public static final RegistryObject<Structure<NoFeatureConfig>> NETHER_BASALT_TEMPLE = RSStructures.addToStructureMaps("temple_nether_basalt", () -> new TempleNetherStructure(new ResourceLocation("repurposed_structures", "temples/temple_nether_basalt")));
    public static final RegistryObject<Structure<NoFeatureConfig>> NETHER_WARPED_TEMPLE = RSStructures.addToStructureMaps("temple_nether_warped", () -> new TempleNetherStructure(new ResourceLocation("repurposed_structures", "temples/temple_nether_warped")));
    public static final RegistryObject<Structure<NoFeatureConfig>> NETHER_CRIMSON_TEMPLE = RSStructures.addToStructureMaps("temple_nether_crimson", () -> new TempleNetherStructure(new ResourceLocation("repurposed_structures", "temples/temple_nether_crimson")));
    public static final RegistryObject<Structure<NoFeatureConfig>> NETHER_SOUL_TEMPLE = RSStructures.addToStructureMaps("temple_nether_soul", () -> new TempleNetherStructure(new ResourceLocation("repurposed_structures", "temples/temple_nether_soul")));
    public static final RegistryObject<Structure<NoFeatureConfig>> NETHER_BRICK_OUTPOST = RSStructures.addToStructureMaps("outpost_nether_brick", () -> new OutpostNetherStructure(new ResourceLocation("repurposed_structures", "outposts/nether_brick/base_plates")));
    public static final RegistryObject<Structure<NoFeatureConfig>> WARPED_OUTPOST = RSStructures.addToStructureMaps("outpost_warped", () -> new OutpostNetherStructure(new ResourceLocation("repurposed_structures", "outposts/warped/base_plates")));
    public static final RegistryObject<Structure<NoFeatureConfig>> CRIMSON_OUTPOST = RSStructures.addToStructureMaps("outpost_crimson", () -> new OutpostNetherStructure(new ResourceLocation("repurposed_structures", "outposts/crimson/base_plates")));
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_BIRCH = RSStructures.addToStructureMaps("outpost_birch", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "outposts/birch/base_plates"), 11, 0, 0, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.VILLAGE).collect(Collectors.toSet()), PillagerOutpostStructureAccessor.repurposedstructures_getPILLAGE_OUTPOST_ENEMIES(), (List<MobSpawnInfo.Spawners>)ImmutableList.of()));
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_JUNGLE = RSStructures.addToStructureMaps("outpost_jungle", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "outposts/jungle/base_plates"), 11, 0, 1, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.VILLAGE).collect(Collectors.toSet()), PillagerOutpostStructureAccessor.repurposedstructures_getPILLAGE_OUTPOST_ENEMIES(), (List<MobSpawnInfo.Spawners>)ImmutableList.of()));
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_GIANT_TREE_TAIGA = RSStructures.addToStructureMaps("outpost_giant_tree_taiga", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "outposts/giant_tree_taiga/base_plates"), 11, 0, 0, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.VILLAGE).collect(Collectors.toSet()), PillagerOutpostStructureAccessor.repurposedstructures_getPILLAGE_OUTPOST_ENEMIES(), (List<MobSpawnInfo.Spawners>)ImmutableList.of()));
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_DESERT = RSStructures.addToStructureMaps("outpost_desert", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "outposts/desert/base_plates"), 11, 0, 1, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.VILLAGE).collect(Collectors.toSet()), PillagerOutpostStructureAccessor.repurposedstructures_getPILLAGE_OUTPOST_ENEMIES(), (List<MobSpawnInfo.Spawners>)ImmutableList.of()));
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_BADLANDS = RSStructures.addToStructureMaps("outpost_badlands", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "outposts/badlands/base_plates"), 11, 0, 0, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.VILLAGE).collect(Collectors.toSet()), 20, 1, PillagerOutpostStructureAccessor.repurposedstructures_getPILLAGE_OUTPOST_ENEMIES(), (List<MobSpawnInfo.Spawners>)ImmutableList.of()));
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_SNOWY = RSStructures.addToStructureMaps("outpost_snowy", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "outposts/snowy/base_plates"), 11, 0, 1, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.VILLAGE).collect(Collectors.toSet()), PillagerOutpostStructureAccessor.repurposedstructures_getPILLAGE_OUTPOST_ENEMIES(), (List<MobSpawnInfo.Spawners>)ImmutableList.of()));
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_ICY = RSStructures.addToStructureMaps("outpost_icy", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "outposts/icy/base_plates"), 11, 0, 0, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.VILLAGE).collect(Collectors.toSet()), PillagerOutpostStructureAccessor.repurposedstructures_getPILLAGE_OUTPOST_ENEMIES(), (List<MobSpawnInfo.Spawners>)ImmutableList.of()));
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_TAIGA = RSStructures.addToStructureMaps("outpost_taiga", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "outposts/taiga/base_plates"), 11, 0, 1, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.VILLAGE).collect(Collectors.toSet()), PillagerOutpostStructureAccessor.repurposedstructures_getPILLAGE_OUTPOST_ENEMIES(), (List<MobSpawnInfo.Spawners>)ImmutableList.of()));
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_OAK = RSStructures.addToStructureMaps("outpost_oak", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "outposts/oak/base_plates"), 11, 0, 1, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.VILLAGE).collect(Collectors.toSet()), PillagerOutpostStructureAccessor.repurposedstructures_getPILLAGE_OUTPOST_ENEMIES(), (List<MobSpawnInfo.Spawners>)ImmutableList.of()));
    public static final RegistryObject<Structure<NoFeatureConfig>> OUTPOST_END = RSStructures.addToStructureMaps("outpost_end", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "outposts/end/base_plates"), 11, 0, 2, 4, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.END_AVOID_STRUCTURE).collect(Collectors.toSet()), 15, 3, (List<MobSpawnInfo.Spawners>)ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_203097_aH, 10, 1, 1)), (List<MobSpawnInfo.Spawners>)ImmutableList.of(), 55));
    public static final RegistryObject<Structure<NoFeatureConfig>> NETHER_PYRAMID = RSStructures.addToStructureMaps("pyramid_nether", () -> new GenericNetherJigsawHighStructure(new ResourceLocation("repurposed_structures", "temples/pyramid_nether"), 1, -4, 0));
    public static final RegistryObject<Structure<NoFeatureConfig>> BADLANDS_PYRAMID = RSStructures.addToStructureMaps("pyramid_badlands", () -> new BuriableStructure(new ResourceLocation("repurposed_structures", "temples/pyramid_badlands")));
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_SNOWY = RSStructures.addToStructureMaps("pyramid_snowy", () -> new BuriableStructure(new ResourceLocation("repurposed_structures", "temples/pyramid_snowy")));
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_END = RSStructures.addToStructureMaps("pyramid_end", () -> new LandBasedEndStructure(new ResourceLocation("repurposed_structures", "temples/pyramid_end"), 11, -2, 0, 0, new HashSet<RSStructureTagMap.STRUCTURE_TAGS>()));
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_ICY = RSStructures.addToStructureMaps("pyramid_icy", () -> new BuriableStructure(new ResourceLocation("repurposed_structures", "temples/pyramid_icy")));
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_JUNGLE = RSStructures.addToStructureMaps("pyramid_jungle", () -> new BuriableStructure(new ResourceLocation("repurposed_structures", "temples/pyramid_jungle"), 20));
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_MUSHROOM = RSStructures.addToStructureMaps("pyramid_mushroom", () -> new BuriableStructure(new ResourceLocation("repurposed_structures", "temples/pyramid_mushroom")));
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_OCEAN = RSStructures.addToStructureMaps("pyramid_ocean", () -> new BuriableStructure(new ResourceLocation("repurposed_structures", "temples/pyramid_ocean"), false));
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_GIANT_TREE_TAIGA = RSStructures.addToStructureMaps("pyramid_giant_tree_taiga", () -> new BuriableStructure(new ResourceLocation("repurposed_structures", "temples/pyramid_giant_tree_taiga")));
    public static final RegistryObject<Structure<NoFeatureConfig>> PYRAMID_FLOWER_FOREST = RSStructures.addToStructureMaps("pyramid_flower_forest", () -> new BuriableStructure(new ResourceLocation("repurposed_structures", "temples/pyramid_flower_forest")));
    public static final RegistryObject<Structure<NoFeatureConfig>> END_SHIPWRECK = RSStructures.addToStructureMaps("shipwreck_end", ShipwreckEndStructure::new);
    public static final RegistryObject<Structure<NetherShipwreckConfig>> NETHER_BRICKS_SHIPWRECK = RSStructures.addToStructureMaps("shipwreck_nether_bricks", () -> new ShipwreckNetherStructure(new ResourceLocation("repurposed_structures", "shipwrecks/nether_bricks"), -3));
    public static final RegistryObject<Structure<NetherShipwreckConfig>> CRIMSON_SHIPWRECK = RSStructures.addToStructureMaps("shipwreck_crimson", () -> new ShipwreckNetherStructure(new ResourceLocation("repurposed_structures", "shipwrecks/crimson"), -4));
    public static final RegistryObject<Structure<NetherShipwreckConfig>> WARPED_SHIPWRECK = RSStructures.addToStructureMaps("shipwreck_warped", () -> new ShipwreckNetherStructure(new ResourceLocation("repurposed_structures", "shipwrecks/warped"), -4));
    public static final RegistryObject<Structure<NoFeatureConfig>> BADLANDS_VILLAGE = RSStructures.addToStructureMaps("village_badlands", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "village/badlands/town_centers"), 10, 0, 1, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION).collect(Collectors.toSet()), 20, 2));
    public static final RegistryObject<Structure<NoFeatureConfig>> BIRCH_VILLAGE = RSStructures.addToStructureMaps("village_birch", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "village/birch/town_centers"), 6, 0, 1, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION).collect(Collectors.toSet())));
    public static final RegistryObject<Structure<NoFeatureConfig>> DARK_FOREST_VILLAGE = RSStructures.addToStructureMaps("village_dark_oak", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "village/dark_forest/town_centers"), 6, 0, 1, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION).collect(Collectors.toSet())));
    public static final RegistryObject<Structure<NoFeatureConfig>> JUNGLE_VILLAGE = RSStructures.addToStructureMaps("village_jungle", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "village/jungle/town_centers"), 8, 0, 1, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION, RSStructureTagMap.STRUCTURE_TAGS.FORTRESS).collect(Collectors.toSet())));
    public static final RegistryObject<Structure<NoFeatureConfig>> SWAMP_VILLAGE = RSStructures.addToStructureMaps("village_swamp", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "village/swamp/town_centers"), 6, -1, 1, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION).collect(Collectors.toSet())));
    public static final RegistryObject<Structure<NoFeatureConfig>> MOUNTAINS_VILLAGE = RSStructures.addToStructureMaps("village_mountains", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "village/mountains/town_centers"), 6, 0, 1, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION).collect(Collectors.toSet())));
    public static final RegistryObject<Structure<NoFeatureConfig>> GIANT_TAIGA_VILLAGE = RSStructures.addToStructureMaps("village_giant_taiga", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "village/giant_taiga/town_centers"), 6, 1, 0, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION).collect(Collectors.toSet())));
    public static final RegistryObject<Structure<NoFeatureConfig>> CRIMSON_VILLAGE = RSStructures.addToStructureMaps("village_crimson", () -> new VillageNetherStructure(new ResourceLocation("repurposed_structures", "village/crimson/town_centers"), 6, 0, 1, 0, new HashSet<RSStructureTagMap.STRUCTURE_TAGS>()));
    public static final RegistryObject<Structure<NoFeatureConfig>> WARPED_VILLAGE = RSStructures.addToStructureMaps("village_warped", () -> new VillageNetherStructure(new ResourceLocation("repurposed_structures", "village/warped/town_centers"), 6, 0, 1, 0, new HashSet<RSStructureTagMap.STRUCTURE_TAGS>()));
    public static final RegistryObject<Structure<NoFeatureConfig>> VILLAGE_OAK = RSStructures.addToStructureMaps("village_oak", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "village/oak/town_centers"), 6, 0, 1, 5, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.MANSION).collect(Collectors.toSet())));
    public static final RegistryObject<Structure<NoFeatureConfig>> RUINED_PORTAL_END = RSStructures.addToStructureMaps("ruined_portal_end", () -> new LandBasedEndStructure(new ResourceLocation("repurposed_structures", "ruined_portal/end"), 20, -6, 0, 0, new HashSet<RSStructureTagMap.STRUCTURE_TAGS>()));
    public static final RegistryObject<Structure<NoFeatureConfig>> RUINS_NETHER = RSStructures.addToStructureMaps("ruins_nether", () -> new GenericNetherJigsawHighStructure(new ResourceLocation("repurposed_structures", "ruins/nether/start_pool"), 1, -4, -1));
    public static final RegistryObject<Structure<NoFeatureConfig>> RUINS_LAND_WARM = RSStructures.addToStructureMaps("ruins_land_warm", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "ruins/land_warm/start_pool"), 2, 0, 0, 0, new HashSet<RSStructureTagMap.STRUCTURE_TAGS>(), 5, 2));
    public static final RegistryObject<Structure<NoFeatureConfig>> RUINS_LAND_HOT = RSStructures.addToStructureMaps("ruins_land_hot", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "ruins/land_hot/start_pool"), 2, 0, 0, 0, new HashSet<RSStructureTagMap.STRUCTURE_TAGS>(), 5, 2));
    public static final RegistryObject<Structure<NoFeatureConfig>> CITY_NETHER = RSStructures.addToStructureMaps("city_nether", () -> new CityNetherStructure(new ResourceLocation("repurposed_structures", "cities/nether/start_pool"), 5, 0, 0, 4, Stream.of(RSStructureTagMap.STRUCTURE_TAGS.GENERIC_AVOID_NETHER_STRUCTURE).collect(Collectors.toSet()), (List<MobSpawnInfo.Spawners>)ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_200792_f, 120, 1, 4), (Object)new MobSpawnInfo.Spawners(EntityType.field_200722_aA, 10, 2, 3)), (List<MobSpawnInfo.Spawners>)ImmutableList.of()));
    public static final RegistryObject<Structure<NoFeatureConfig>> MANSION_BIRCH = RSStructures.addToStructureMaps("mansion_birch", () -> new MansionStructure(MansionPieces.MansionTemplate.MANSIONTYPE.BIRCH));
    public static final RegistryObject<Structure<NoFeatureConfig>> MANSION_JUNGLE = RSStructures.addToStructureMaps("mansion_jungle", () -> new MansionStructure(MansionPieces.MansionTemplate.MANSIONTYPE.JUNGLE));
    public static final RegistryObject<Structure<NoFeatureConfig>> MANSION_OAK = RSStructures.addToStructureMaps("mansion_oak", () -> new MansionStructure(MansionPieces.MansionTemplate.MANSIONTYPE.OAK));
    public static final RegistryObject<Structure<NoFeatureConfig>> MANSION_SAVANNA = RSStructures.addToStructureMaps("mansion_savanna", () -> new MansionStructure(MansionPieces.MansionTemplate.MANSIONTYPE.SAVANNA));
    public static final RegistryObject<Structure<NoFeatureConfig>> MANSION_TAIGA = RSStructures.addToStructureMaps("mansion_taiga", () -> new MansionStructure(MansionPieces.MansionTemplate.MANSIONTYPE.TAIGA));
    public static final RegistryObject<Structure<NoFeatureConfig>> MANSION_DESERT = RSStructures.addToStructureMaps("mansion_desert", () -> new MansionStructure(MansionPieces.MansionTemplate.MANSIONTYPE.DESERT));
    public static final RegistryObject<Structure<NoFeatureConfig>> MANSION_SNOWY = RSStructures.addToStructureMaps("mansion_snowy", () -> new MansionStructure(MansionPieces.MansionTemplate.MANSIONTYPE.SNOWY));
    public static final RegistryObject<Structure<NoFeatureConfig>> WITCH_HUTS_OAK = RSStructures.addToStructureMaps("witch_hut_oak", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "witch_huts/oak_start_pool"), 11, 0, 0, 0, new HashSet<RSStructureTagMap.STRUCTURE_TAGS>(), (List<MobSpawnInfo.Spawners>)ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_200759_ay, 1, 1, 1)), (List<MobSpawnInfo.Spawners>)ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_220360_g, 1, 1, 1))));
    public static final RegistryObject<Structure<NoFeatureConfig>> WITCH_HUTS_TAIGA = RSStructures.addToStructureMaps("witch_hut_taiga", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "witch_huts/taiga_start_pool"), 11, 0, 0, 0, new HashSet<RSStructureTagMap.STRUCTURE_TAGS>(), (List<MobSpawnInfo.Spawners>)ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_200759_ay, 1, 1, 1)), (List<MobSpawnInfo.Spawners>)ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_220360_g, 1, 1, 1))));
    public static final RegistryObject<Structure<NoFeatureConfig>> WITCH_HUTS_BIRCH = RSStructures.addToStructureMaps("witch_hut_birch", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "witch_huts/birch_start_pool"), 11, 0, 0, 0, new HashSet<RSStructureTagMap.STRUCTURE_TAGS>(), (List<MobSpawnInfo.Spawners>)ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_200759_ay, 1, 1, 1)), (List<MobSpawnInfo.Spawners>)ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_220360_g, 1, 1, 1))));
    public static final RegistryObject<Structure<NoFeatureConfig>> WITCH_HUTS_DARK_FOREST = RSStructures.addToStructureMaps("witch_hut_dark_forest", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "witch_huts/dark_forest_start_pool"), 11, 0, 0, 0, new HashSet<RSStructureTagMap.STRUCTURE_TAGS>(), (List<MobSpawnInfo.Spawners>)ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_200759_ay, 1, 1, 1)), (List<MobSpawnInfo.Spawners>)ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_220360_g, 1, 1, 1))));
    public static final RegistryObject<Structure<NoFeatureConfig>> WITCH_HUTS_GIANT_TREE_TAIGA = RSStructures.addToStructureMaps("witch_hut_giant_tree_taiga", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "witch_huts/giant_tree_taiga_start_pool"), 11, 0, 0, 0, new HashSet<RSStructureTagMap.STRUCTURE_TAGS>(), (List<MobSpawnInfo.Spawners>)ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_200759_ay, 1, 1, 1)), (List<MobSpawnInfo.Spawners>)ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_220360_g, 1, 1, 1))));
    public static final RegistryObject<Structure<NoFeatureConfig>> BASTION_UNDERGROUND = RSStructures.addToStructureMaps("bastion_underground", () -> new GenericJigsawStructure(new ResourceLocation("repurposed_structures", "bastions/underground/starts"), 7, 10, 5, (Set<RSStructureTagMap.STRUCTURE_TAGS>)ImmutableSet.of((Object)((Object)RSStructureTagMap.STRUCTURE_TAGS.BASTION_AVOID_STRUCTURE)), (List<MobSpawnInfo.Spawners>)ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_200741_ag, 1, 1, 4)), 12));

    private static <T extends Structure<?>> RegistryObject<T> addToStructureMaps(String name, Supplier<T> structure) {
        return STRUCTURE_FEATURES.register(name, structure);
    }

    public static void setupStructures() {
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_birch"), (Structure)BIRCH_MINESHAFT.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 399117345));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_dark_forest"), (Structure)DARK_FOREST_MINESHAFT.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 2011511156));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_desert"), (Structure)DESERT_MINESHAFT.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1990612785));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_end"), (Structure)END_MINESHAFT.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 2057488602));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_nether"), (Structure)NETHER_MINESHAFT.get(), GenerationStage.Decoration.VEGETAL_DECORATION, new StructureSeparationSettings(1, 0, 1220811654));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_crimson"), (Structure)CRIMSON_MINESHAFT.get(), GenerationStage.Decoration.VEGETAL_DECORATION, new StructureSeparationSettings(1, 0, 1153019610));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_warped"), (Structure)WARPED_MINESHAFT.get(), GenerationStage.Decoration.VEGETAL_DECORATION, new StructureSeparationSettings(1, 0, 1095888662));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_icy"), (Structure)ICY_MINESHAFT.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1451015246));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_jungle"), (Structure)JUNGLE_MINESHAFT.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1434412876));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_ocean"), (Structure)OCEAN_MINESHAFT.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1774808662));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_savanna"), (Structure)SAVANNA_MINESHAFT.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1960212212));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_stone"), (Structure)STONE_MINESHAFT.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1436736620));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_swamp"), (Structure)SWAMP_MINESHAFT.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 2037177700));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mineshaft_taiga"), (Structure)TAIGA_MINESHAFT.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1383003172));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "stronghold_nether"), (Structure)NETHER_STRONGHOLD.get(), GenerationStage.Decoration.TOP_LAYER_MODIFICATION, new StructureSeparationSettings(RepurposedStructures.RSStrongholdsConfig.netherStrongholdMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSStrongholdsConfig.netherStrongholdMaxChunkDistance.get().intValue() * 0.5f), 1731422513));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "fortress_jungle"), (Structure)JUNGLE_FORTRESS.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMainConfig.jungleFortressMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSMainConfig.jungleFortressMaxChunkDistance.get().intValue() * 0.5f), 1464189157));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "igloo_grassy"), (Structure)GRASSY_IGLOO.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMainConfig.grassyIglooMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSMainConfig.grassyIglooMaxChunkDistance.get().intValue() * 0.5f), 1460835582));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "igloo_stone"), (Structure)STONE_IGLOO.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMainConfig.stoneIglooMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSMainConfig.stoneIglooMaxChunkDistance.get().intValue() * 0.5f), 1327429039));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "temple_nether_wasteland"), (Structure)NETHER_WASTELAND_TEMPLE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.netherWastelandTempleMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.netherWastelandTempleMaxChunkDistance.get().intValue() * 0.5f), 1435489909));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "temple_nether_soul"), (Structure)NETHER_SOUL_TEMPLE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.netherSoulTempleMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.netherSoulTempleMaxChunkDistance.get().intValue() * 0.5f), 1799485937));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "temple_nether_basalt"), (Structure)NETHER_BASALT_TEMPLE.get(), GenerationStage.Decoration.VEGETAL_DECORATION, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.netherBasaltTempleMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.netherBasaltTempleMaxChunkDistance.get().intValue() * 0.5f), 1063117750));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "temple_nether_crimson"), (Structure)NETHER_CRIMSON_TEMPLE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.netherCrimsonTempleMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.netherCrimsonTempleMaxChunkDistance.get().intValue() * 0.5f), 1898896156));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "temple_nether_warped"), (Structure)NETHER_WARPED_TEMPLE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.netherWarpedTempleMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.netherWarpedTempleMaxChunkDistance.get().intValue() * 0.5f), 1635542708));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_nether_brick"), (Structure)NETHER_BRICK_OUTPOST.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSOutpostsConfig.netherBrickOutpostMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSOutpostsConfig.netherBrickOutpostMaxChunkDistance.get().intValue() * 0.5f), 1305971394));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_warped"), (Structure)WARPED_OUTPOST.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSOutpostsConfig.warpedOutpostMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSOutpostsConfig.warpedOutpostMaxChunkDistance.get().intValue() * 0.5f), 1928816918));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_crimson"), (Structure)CRIMSON_OUTPOST.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSOutpostsConfig.crimsonOutpostMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSOutpostsConfig.crimsonOutpostMaxChunkDistance.get().intValue() * 0.5f), 1951425662));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_birch"), (Structure)OUTPOST_BIRCH.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSOutpostsConfig.outpostBirchMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSOutpostsConfig.outpostBirchMaxChunkDistance.get().intValue() * 0.5f), 1676743168));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_jungle"), (Structure)OUTPOST_JUNGLE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSOutpostsConfig.outpostJungleMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSOutpostsConfig.outpostJungleMaxChunkDistance.get().intValue() * 0.5f), 548433028));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_giant_tree_taiga"), (Structure)OUTPOST_GIANT_TREE_TAIGA.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSOutpostsConfig.outpostGiantTreeTaigaMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSOutpostsConfig.outpostGiantTreeTaigaMaxChunkDistance.get().intValue() * 0.5f), 993252541));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_desert"), (Structure)OUTPOST_DESERT.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSOutpostsConfig.outpostDesertMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSOutpostsConfig.outpostDesertMaxChunkDistance.get().intValue() * 0.5f), 593099376));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_badlands"), (Structure)OUTPOST_BADLANDS.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSOutpostsConfig.outpostBadlandsMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSOutpostsConfig.outpostBadlandsMaxChunkDistance.get().intValue() * 0.5f), 1702026868));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_snowy"), (Structure)OUTPOST_SNOWY.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSOutpostsConfig.outpostSnowyMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSOutpostsConfig.outpostSnowyMaxChunkDistance.get().intValue() * 0.5f), 849388460));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_icy"), (Structure)OUTPOST_ICY.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSOutpostsConfig.outpostIcyMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSOutpostsConfig.outpostIcyMaxChunkDistance.get().intValue() * 0.5f), 935294633));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_taiga"), (Structure)OUTPOST_TAIGA.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSOutpostsConfig.outpostTaigaMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSOutpostsConfig.outpostTaigaMaxChunkDistance.get().intValue() * 0.5f), 272805097));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_oak"), (Structure)OUTPOST_OAK.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSOutpostsConfig.outpostOakMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSOutpostsConfig.outpostOakMaxChunkDistance.get().intValue() * 0.5f), 698118385));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "outpost_end"), (Structure)OUTPOST_END.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSOutpostsConfig.outpostEndMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSOutpostsConfig.outpostEndMaxChunkDistance.get().intValue() * 0.5f), 831830630));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_badlands"), (Structure)BADLANDS_PYRAMID.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.badlandsPyramidMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.badlandsPyramidMaxChunkDistance.get().intValue() * 0.5f), 1718729448));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_nether"), (Structure)NETHER_PYRAMID.get(), GenerationStage.Decoration.VEGETAL_DECORATION, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.netherPyramidMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.netherPyramidMaxChunkDistance.get().intValue() * 0.5f), 2054372964));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_snowy"), (Structure)PYRAMID_SNOWY.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.pyramidSnowyMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.pyramidSnowyMaxChunkDistance.get().intValue() * 0.5f), 1630533493));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_end"), (Structure)PYRAMID_END.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.pyramidEndMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.pyramidEndMaxChunkDistance.get().intValue() * 0.5f), 1145023315));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_icy"), (Structure)PYRAMID_ICY.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.pyramidIcyMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.pyramidIcyMaxChunkDistance.get().intValue() * 0.5f), 884076931));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_jungle"), (Structure)PYRAMID_JUNGLE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.pyramidJungleMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.pyramidJungleMaxChunkDistance.get().intValue() * 0.5f), 1483015905));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_mushroom"), (Structure)PYRAMID_MUSHROOM.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.pyramidMushroomMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.pyramidMushroomMaxChunkDistance.get().intValue() * 0.5f), 1035759391));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_ocean"), (Structure)PYRAMID_OCEAN.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.pyramidOceanMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.pyramidOceanMaxChunkDistance.get().intValue() * 0.5f), 777281414));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_giant_tree_taiga"), (Structure)PYRAMID_GIANT_TREE_TAIGA.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.pyramidGiantTreeTaigaMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.pyramidGiantTreeTaigaMaxChunkDistance.get().intValue() * 0.5f), 1977974973));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "pyramid_flower_forest"), (Structure)PYRAMID_FLOWER_FOREST.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.pyramidFlowerForestMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.pyramidFlowerForestMaxChunkDistance.get().intValue() * 0.5f), 1984904323));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "shipwreck_end"), (Structure)END_SHIPWRECK.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSShipwrecksConfig.endShipwreckMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSShipwrecksConfig.endShipwreckMaxChunkDistance.get().intValue() * 0.5f), 1605500075));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "shipwreck_nether_bricks"), (Structure)NETHER_BRICKS_SHIPWRECK.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSShipwrecksConfig.netherBricksShipwreckMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSShipwrecksConfig.netherBricksShipwreckMaxChunkDistance.get().intValue() * 0.5f), 2073308006), new NetherShipwreckConfig(true));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "shipwreck_crimson"), (Structure)CRIMSON_SHIPWRECK.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSShipwrecksConfig.crimsonShipwreckMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSShipwrecksConfig.crimsonShipwreckMaxChunkDistance.get().intValue() * 0.5f), 1019716871), new NetherShipwreckConfig(false));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "shipwreck_warped"), (Structure)WARPED_SHIPWRECK.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSShipwrecksConfig.warpedShipwreckMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSShipwrecksConfig.warpedShipwreckMaxChunkDistance.get().intValue() * 0.5f), 2072979641), new NetherShipwreckConfig(false));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_badlands"), (Structure)BADLANDS_VILLAGE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.badlandsVillageMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.badlandsVillageMaxChunkDistance.get().intValue() * 0.5f), 1319707555));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_birch"), (Structure)BIRCH_VILLAGE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.birchVillageMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.birchVillageMaxChunkDistance.get().intValue() * 0.5f), 1102567365));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_dark_oak"), (Structure)DARK_FOREST_VILLAGE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.darkForestVillageMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.darkForestVillageMaxChunkDistance.get().intValue() * 0.5f), 1921339358));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_jungle"), (Structure)JUNGLE_VILLAGE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.jungleVillageMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.jungleVillageMaxChunkDistance.get().intValue() * 0.5f), 1229975218));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_swamp"), (Structure)SWAMP_VILLAGE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.swampVillageMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.swampVillageMaxChunkDistance.get().intValue() * 0.5f), 1559650945));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_mountains"), (Structure)MOUNTAINS_VILLAGE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.mountainsVillageMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.mountainsVillageMaxChunkDistance.get().intValue() * 0.5f), 2010875989));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_giant_taiga"), (Structure)GIANT_TAIGA_VILLAGE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.giantTaigaVillageMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.giantTaigaVillageMaxChunkDistance.get().intValue() * 0.5f), 1559528842));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_crimson"), (Structure)CRIMSON_VILLAGE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.crimsonVillageMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.crimsonVillageMaxChunkDistance.get().intValue() * 0.5f), 1854750198));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_warped"), (Structure)WARPED_VILLAGE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.warpedVillageMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.warpedVillageMaxChunkDistance.get().intValue() * 0.5f), 1298332136));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "village_oak"), (Structure)VILLAGE_OAK.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.villageOakMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.villageOakMaxChunkDistance.get().intValue() * 0.5f), 2112891039));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "ruined_portal_end"), (Structure)RUINED_PORTAL_END.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMainConfig.ruinedPortalEndMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSMainConfig.ruinedPortalEndMaxChunkDistance.get().intValue() * 0.5f), 532404086));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "ruins_nether"), (Structure)RUINS_NETHER.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMainConfig.ruinsNetherMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSMainConfig.ruinsNetherMaxChunkDistance.get().intValue() * 0.5f), 1336047555));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "ruins_land_warm"), (Structure)RUINS_LAND_WARM.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMainConfig.ruinsLandWarmMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSMainConfig.ruinsLandWarmMaxChunkDistance.get().intValue() * 0.25f), 18646107));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "ruins_land_hot"), (Structure)RUINS_LAND_HOT.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMainConfig.ruinsLandHotMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSMainConfig.ruinsLandHotMaxChunkDistance.get().intValue() * 0.25f), 1243670027));
        RSStructures.addToTerraformingAndStructureMaps(new ResourceLocation("repurposed_structures", "city_nether"), (Structure)CITY_NETHER.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMainConfig.citiesNetherMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSMainConfig.citiesNetherMaxChunkDistance.get().intValue() * 0.5f), 2082652405));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mansion_birch"), (Structure)MANSION_BIRCH.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMansionsConfig.mansionBirchMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSMansionsConfig.mansionBirchMaxChunkDistance.get().intValue() * 0.5f), 182367035));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mansion_jungle"), (Structure)MANSION_JUNGLE.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMansionsConfig.mansionJungleMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSMansionsConfig.mansionJungleMaxChunkDistance.get().intValue() * 0.5f), 1267916621));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mansion_oak"), (Structure)MANSION_OAK.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMansionsConfig.mansionOakMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSMansionsConfig.mansionOakMaxChunkDistance.get().intValue() * 0.5f), 147853731));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mansion_savanna"), (Structure)MANSION_SAVANNA.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMansionsConfig.mansionSavannaMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSMansionsConfig.mansionSavannaMaxChunkDistance.get().intValue() * 0.5f), 2024558925));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mansion_taiga"), (Structure)MANSION_TAIGA.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMansionsConfig.mansionTaigaMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSMansionsConfig.mansionTaigaMaxChunkDistance.get().intValue() * 0.5f), 418506505));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mansion_desert"), (Structure)MANSION_DESERT.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMansionsConfig.mansionDesertMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSMansionsConfig.mansionDesertMaxChunkDistance.get().intValue() * 0.5f), 724317387));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "mansion_snowy"), (Structure)MANSION_SNOWY.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMansionsConfig.mansionSnowyMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSMansionsConfig.mansionSnowyMaxChunkDistance.get().intValue() * 0.5f), 1115107889));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "witch_hut_oak"), (Structure)WITCH_HUTS_OAK.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSWitchHutsConfig.witchHutsOakMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSWitchHutsConfig.witchHutsOakMaxChunkDistance.get().intValue() * 0.5f), 741641348));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "witch_hut_taiga"), (Structure)WITCH_HUTS_TAIGA.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSWitchHutsConfig.witchHutsTaigaMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSWitchHutsConfig.witchHutsTaigaMaxChunkDistance.get().intValue() * 0.5f), 1925189659));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "witch_hut_birch"), (Structure)WITCH_HUTS_BIRCH.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSWitchHutsConfig.witchHutsBirchMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSWitchHutsConfig.witchHutsBirchMaxChunkDistance.get().intValue() * 0.5f), 904634508));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "witch_hut_dark_forest"), (Structure)WITCH_HUTS_DARK_FOREST.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSWitchHutsConfig.witchHutsDarkForestMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSWitchHutsConfig.witchHutsDarkForestMaxChunkDistance.get().intValue() * 0.5f), 165100151));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "witch_hut_giant_tree_taiga"), (Structure)WITCH_HUTS_GIANT_TREE_TAIGA.get(), GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSWitchHutsConfig.witchHutsGiantTreeTaigaMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSWitchHutsConfig.witchHutsGiantTreeTaigaMaxChunkDistance.get().intValue() * 0.5f), 200289401));
        RSStructures.addToStructureMaps(new ResourceLocation("repurposed_structures", "bastion_underground"), (Structure)BASTION_UNDERGROUND.get(), GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMainConfig.bastionUndergroundMaxChunkDistance.get().intValue(), (int)((float)RepurposedStructures.RSMainConfig.bastionUndergroundMaxChunkDistance.get().intValue() * 0.5f), 1359301629));
        RSStructurePieces.registerStructurePieces();
    }

    public static <F extends Structure<NoFeatureConfig>> void addToTerraformingAndStructureMaps(ResourceLocation resourceLocation, F structure, GenerationStage.Decoration stage, StructureSeparationSettings StructureSeparationSettings2) {
        Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        RSStructures.addToStructureMaps(resourceLocation, structure, stage, StructureSeparationSettings2);
    }

    public static <C extends IFeatureConfig, F extends Structure<C>> void addToStructureMaps(ResourceLocation resourceLocation, F structure, GenerationStage.Decoration stage, StructureSeparationSettings structureSeparationSettings, C config) {
        Structure.field_236365_a_.put((Object)resourceLocation.toString().toLowerCase(Locale.ROOT), structure);
        Structure.field_236385_u_.put(structure, stage);
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        FlatGenerationSettings.field_202247_j.put(structure, structure.func_236391_a_(config));
        RS_STRUCTURES.put(structure, structureSeparationSettings);
    }

    public static <F extends Structure<NoFeatureConfig>> void addToStructureMaps(ResourceLocation resourceLocation, F structure, GenerationStage.Decoration stage, StructureSeparationSettings structureSeparationSettings) {
        Structure.field_236365_a_.put((Object)resourceLocation.toString().toLowerCase(Locale.ROOT), structure);
        Structure.field_236385_u_.put(structure, stage);
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        FlatGenerationSettings.field_202247_j.put(structure, structure.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        RS_STRUCTURES.put(structure, structureSeparationSettings);
    }
}

