/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.features.configs.StructureTargetAndLengthConfig;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class StructureVineBreakage
extends Feature<StructureTargetAndLengthConfig> {
    private static final Predicate<BlockState> FORTRESS_BLOCKS = blockState -> {
        if (blockState == null) {
            return false;
        }
        return blockState.func_185904_a() == Material.field_151576_e || blockState.func_185904_a() == Material.field_151578_c || blockState.func_203425_a(Blocks.field_196694_dh) || blockState.func_203425_a(Blocks.field_196692_dg) || blockState.func_203425_a(Blocks.field_196688_de) || blockState.func_203425_a(Blocks.field_196690_df) || blockState.func_203425_a(Blocks.field_150411_aY);
    };

    public StructureVineBreakage(Codec<StructureTargetAndLengthConfig> config) {
        super(config);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, StructureTargetAndLengthConfig config) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int i = 0; i < config.attempts; ++i) {
            mutable.func_189533_g((Vector3i)position).func_196234_d(random.nextInt(7) - 3, random.nextInt(5) - 1, random.nextInt(7) - 3);
            if (!FORTRESS_BLOCKS.test(world.func_180495_p((BlockPos)mutable)) || !world.func_175623_d(mutable.func_177977_b())) continue;
            world.func_180501_a((BlockPos)mutable, Blocks.field_201941_jj.func_176223_P(), 3);
            BlockPos.Mutable vineMutablePos = new BlockPos.Mutable().func_189533_g((Vector3i)mutable);
            BlockState neighboringBlock = world.func_180495_p((BlockPos)vineMutablePos);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                vineMutablePos.func_189533_g((Vector3i)mutable).func_189536_c(direction);
                while (neighboringBlock.func_185904_a() == Material.field_151582_l) {
                    world.func_180501_a((BlockPos)vineMutablePos, Blocks.field_201941_jj.func_176223_P(), 3);
                    neighboringBlock = world.func_180495_p((BlockPos)vineMutablePos.func_189536_c(Direction.DOWN));
                }
            }
            BlockPos.Mutable replacingPlantMutable = new BlockPos.Mutable().func_189533_g((Vector3i)mutable);
            BlockState plantState = world.func_180495_p((BlockPos)replacingPlantMutable.func_189536_c(Direction.UP));
            while (plantState.func_185904_a() == Material.field_151582_l) {
                world.func_180501_a((BlockPos)replacingPlantMutable, Blocks.field_150350_a.func_176223_P(), 3);
                plantState = world.func_180495_p((BlockPos)replacingPlantMutable.func_189536_c(Direction.UP));
            }
            int length = 0;
            vineMutablePos.func_189533_g((Vector3i)mutable);
            ChunkPos currentChunkPos = new ChunkPos((BlockPos)vineMutablePos);
            int maxLength = config.length - random.nextInt(random.nextInt(config.length) + 1);
            while (length < maxLength && world.func_175623_d((BlockPos)vineMutablePos)) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    mutable.func_189533_g((Vector3i)vineMutablePos).func_189536_c(direction);
                    ChunkPos newChunkPos = new ChunkPos((BlockPos)mutable);
                    if (newChunkPos.field_77276_a != currentChunkPos.field_77276_a || newChunkPos.field_77275_b != currentChunkPos.field_77275_b) continue;
                    BlockState currentBlockstate = (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)VineBlock.func_176267_a((Direction)direction), (Comparable)Boolean.TRUE);
                    BlockState aboveBlockstate = world.func_180495_p(vineMutablePos.func_177984_a());
                    if (currentBlockstate.func_196955_c((IWorldReader)world, (BlockPos)vineMutablePos)) {
                        world.func_180501_a((BlockPos)vineMutablePos, (BlockState)currentBlockstate.func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(aboveBlockstate.func_200132_m())), 2);
                        ++length;
                        break;
                    }
                    if (!aboveBlockstate.func_203425_a(Blocks.field_150395_bd)) continue;
                    world.func_180501_a((BlockPos)vineMutablePos, (BlockState)aboveBlockstate.func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(false)), 2);
                    ++length;
                    break;
                }
                vineMutablePos.func_189536_c(Direction.DOWN);
            }
        }
        return true;
    }
}

