/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BellAttachment;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public abstract class WellAbstract
extends Feature<NoFeatureConfig> {
    protected PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a(null);

    public WellAbstract(Codec<NoFeatureConfig> config) {
        super(config);
    }

    protected Template generateTemplate(ResourceLocation templateRL, ISeedReader world, Random random, BlockPos position) {
        Template template = world.func_201672_e().func_184163_y().func_200219_b(templateRL);
        if (template == null) {
            RepurposedStructures.LOGGER.warn(templateRL.toString() + " NTB does not exist!");
            return null;
        }
        BlockPos offset = new BlockPos(-template.func_186259_a().func_177958_n() / 2, 0, -template.func_186259_a().func_177952_p() / 2);
        template.func_237144_a_((IServerWorld)world, position.func_177971_a((Vector3i)offset), this.placementsettings, random);
        return template;
    }

    protected void handleDataBlocks(ResourceLocation templateOresRL, Template template, ISeedReader world, Random random, BlockPos position, Block defaultBlock, float oreChance) {
        ITag ORE_TAG = BlockTags.func_199896_a().func_241834_b(templateOresRL);
        List allOreBlocks = ORE_TAG.func_230236_b_();
        BlockPos offset = new BlockPos(-template.func_186259_a().func_177958_n() / 2, 0, -template.func_186259_a().func_177952_p() / 2);
        for (Template.BlockInfo template$blockinfo : template.func_215381_a(position.func_177971_a((Vector3i)offset), this.placementsettings, Blocks.field_185779_df)) {
            StructureMode structuremode;
            if (template$blockinfo.field_186244_c == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
            WellAbstract.addBells(template$blockinfo.field_186244_c.func_74779_i("metadata"), template$blockinfo.field_186242_a, world, random, allOreBlocks);
            WellAbstract.addOres(template$blockinfo.field_186244_c.func_74779_i("metadata"), template$blockinfo.field_186242_a, world, random, allOreBlocks, defaultBlock, oreChance);
            WellAbstract.addSpace(template$blockinfo.field_186244_c.func_74779_i("metadata"), template$blockinfo.field_186242_a, world);
        }
    }

    protected static void addBells(String function, BlockPos position, ISeedReader world, Random random, Collection<Block> allOreBlocks) {
        if (function.equals("bell")) {
            if (RepurposedStructures.RSWellsConfig.canHaveBells.get().booleanValue() && random.nextInt(100) == 0) {
                world.func_180501_a(position, (BlockState)Blocks.field_222431_lT.func_176223_P().func_206870_a((Property)BlockStateProperties.field_222511_P, (Comparable)BellAttachment.CEILING), 2);
            } else {
                world.func_180501_a(position, Blocks.field_150350_a.func_176223_P(), 2);
            }
        }
    }

    protected static void addOres(String function, BlockPos position, ISeedReader world, Random random, Collection<Block> allOreBlocks, Block defaultBlock, float oreChance) {
        if (function.equals("ores")) {
            if (!allOreBlocks.isEmpty() && random.nextFloat() < oreChance) {
                world.func_180501_a(position, ((Block)allOreBlocks.toArray()[random.nextInt(allOreBlocks.size())]).func_176223_P(), 2);
            } else {
                world.func_180501_a(position, defaultBlock.func_176223_P(), 2);
            }
        }
    }

    protected static void addSpace(String function, BlockPos position, ISeedReader world) {
        if (function.equals("space")) {
            BlockState blockstate = position.func_177956_o() < world.func_181545_F() ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x * z != 0) continue;
                    world.func_180501_a(position.func_177982_a(x, 0, z), blockstate, 2);
                }
            }
        }
    }
}

