/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.features.WellAbstract;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.Template;

public class WellMushroom
extends WellAbstract {
    private static final float ORE_CHANCE = 0.5f;
    private static final ResourceLocation MUSHROOM_WELL_ORE_RL = new ResourceLocation("repurposed_structures:mushroom_well_ores");
    private static final ResourceLocation MUSHROOM_WELL_RL = new ResourceLocation("repurposed_structures", "wells/mushroom");

    public WellMushroom(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoFeatureConfig config) {
        if (GeneralUtils.isWorldBlacklisted((IServerWorld)world)) {
            return false;
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        mutable.func_189536_c(Direction.UP);
        while (world.func_175623_d((BlockPos)mutable) && mutable.func_177956_o() > 2) {
            mutable.func_189536_c(Direction.DOWN);
        }
        BlockState block = world.func_180495_p((BlockPos)mutable);
        if (!(!block.func_203425_a(Blocks.field_150391_bh) && !WellMushroom.func_227250_b_((Block)block.func_177230_c()) || world.func_175623_d(mutable.func_177977_b()) && world.func_175623_d(mutable.func_177979_c(2)))) {
            mutable.func_189536_c(Direction.DOWN);
            Template template = this.generateTemplate(MUSHROOM_WELL_RL, world, random, (BlockPos)mutable);
            if (template != null) {
                this.handleDataBlocks(MUSHROOM_WELL_ORE_RL, template, world, random, (BlockPos)mutable, Blocks.field_150348_b, 0.5f);
            }
            return true;
        }
        return false;
    }
}

