/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.features.WellAbstract;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.Template;

public class WellNether
extends WellAbstract {
    private static final float COMMON_ORE_CHANCE = 0.5f;
    private static final float RARE_ORE_CHANCE = 0.08f;
    private static final ResourceLocation NETHER_WELL_ORE_RL = new ResourceLocation("repurposed_structures:nether_well_ores");
    private static final ResourceLocation NETHER_WELL_RL = new ResourceLocation("repurposed_structures", "wells/nether");

    public WellNether(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoFeatureConfig config) {
        if (GeneralUtils.isWorldBlacklisted((IServerWorld)world)) {
            return false;
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        mutable.func_189536_c(Direction.UP);
        while (mutable.func_177956_o() > 32) {
            if (world.func_175623_d((BlockPos)mutable) && mutable.func_177956_o() > 32) {
                mutable.func_189536_c(Direction.DOWN);
                continue;
            }
            BlockState blockState = world.func_180495_p((BlockPos)mutable);
            Block block = blockState.func_177230_c();
            if ((BlockTags.field_241278_aD_.func_230235_a_((Object)block) || BlockTags.field_205599_H.func_230235_a_((Object)block) || BlockTags.field_219755_X.func_230235_a_((Object)block) || blockState.func_185904_a() == Material.field_151595_p || blockState.func_185904_a() == Material.field_151576_e || blockState.func_185904_a() == Material.field_151578_c || world.func_226691_t_((BlockPos)mutable).func_242440_e().func_242502_e().func_204108_a() != null && blockState.func_203425_a(world.func_226691_t_((BlockPos)mutable).func_242440_e().func_242502_e().func_204108_a().func_177230_c())) && !world.func_175623_d(mutable.func_177977_b()) && world.func_175623_d(mutable.func_177981_b(3)) && !world.func_175623_d(mutable.func_177964_d(2).func_177977_b()) && !world.func_175623_d(mutable.func_177985_f(2).func_177977_b()) && !world.func_175623_d(mutable.func_177965_g(2).func_177977_b()) && !world.func_175623_d(mutable.func_177970_e(2).func_177977_b())) {
                mutable.func_189536_c(Direction.DOWN);
                Template template = this.generateTemplate(NETHER_WELL_RL, world, random, (BlockPos)mutable);
                if (template != null) {
                    this.handleDataBlocks(NETHER_WELL_ORE_RL, template, world, random, (BlockPos)mutable, Blocks.field_150424_aL, 0.0f);
                }
                return true;
            }
            mutable.func_189536_c(Direction.DOWN);
        }
        return false;
    }

    @Override
    protected void handleDataBlocks(ResourceLocation templateOresRL, Template template, ISeedReader world, Random random, BlockPos position, Block defaultBlock, float oreChance) {
        ITag ORE_TAG = BlockTags.func_199896_a().func_241834_b(templateOresRL);
        List allOreBlocks = ORE_TAG.func_230236_b_();
        BlockPos offset = new BlockPos(-template.func_186259_a().func_177958_n() / 2, 0, -template.func_186259_a().func_177952_p() / 2);
        for (Template.BlockInfo template$blockinfo : template.func_215381_a(position.func_177971_a((Vector3i)offset), this.placementsettings, Blocks.field_185779_df)) {
            StructureMode structuremode;
            if (template$blockinfo.field_186244_c == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
            WellNether.addBells(template$blockinfo.field_186244_c.func_74779_i("metadata"), template$blockinfo.field_186242_a, world, random, allOreBlocks);
            WellNether.addOres(template$blockinfo.field_186244_c.func_74779_i("metadata"), template$blockinfo.field_186242_a, world, random, allOreBlocks, defaultBlock, oreChance);
            WellNether.addSpace(template$blockinfo.field_186244_c.func_74779_i("metadata"), template$blockinfo.field_186242_a, world);
        }
    }

    protected static void addOres(String function, BlockPos position, ISeedReader world, Random random, Collection<Block> allOreBlocks, Block defaultBlock, float oreChance) {
        if (function.equals("ores")) {
            float chance = random.nextFloat();
            if (!allOreBlocks.isEmpty() && chance < 0.08f) {
                world.func_180501_a(position, ((Block)allOreBlocks.toArray()[0]).func_176223_P(), 2);
            } else if (allOreBlocks.size() > 1 && chance - 0.08f < 0.5f) {
                world.func_180501_a(position, ((Block)allOreBlocks.toArray()[random.nextInt(allOreBlocks.size() - 1) + 1]).func_176223_P(), 2);
            } else {
                world.func_180501_a(position, defaultBlock.func_176223_P(), 2);
            }
        }
    }

    protected static void addSpace(String function, BlockPos position, ISeedReader world) {
        if (function.equals("space")) {
            BlockState blockstate = position.func_177956_o() < 32 ? Blocks.field_150353_l.func_176223_P() : Blocks.field_150350_a.func_176223_P();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x * z != 0) continue;
                    if (position.func_177956_o() < world.func_181545_F()) {
                        world.func_180501_a(position.func_177982_a(x, 0, z), blockstate, 2);
                        continue;
                    }
                    world.func_180501_a(position.func_177982_a(x, 0, z), blockstate, 2);
                }
            }
        }
    }
}

