/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class CeilingVinePostProcessor
extends StructureProcessor {
    public static final Codec<CeilingVinePostProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("probability").stable().forGetter(ceilingVinePostProcessor -> Float.valueOf(ceilingVinePostProcessor.probability)), (App)BlockState.field_235877_b_.fieldOf("blockstate").forGetter(ceilingVinePostProcessor -> ceilingVinePostProcessor.blockState)).apply((Applicative)instance, instance.stable(CeilingVinePostProcessor::new)));
    private final float probability;
    private final BlockState blockState;

    public CeilingVinePostProcessor(float probability, BlockState blockState) {
        this.probability = probability;
        this.blockState = blockState;
    }

    public Template.BlockInfo func_230386_a_(IWorldReader worldView, BlockPos pos, BlockPos blockPos, Template.BlockInfo structureBlockInfoLocal, Template.BlockInfo structureBlockInfoWorld, PlacementSettings structurePlacementData) {
        if (structureBlockInfoWorld.field_186243_b.func_196958_f()) {
            SharedSeedRandom random = new SharedSeedRandom();
            random.setSeed(structureBlockInfoWorld.field_186242_a.func_218275_a() * (long)structureBlockInfoWorld.field_186242_a.func_177956_o());
            IChunk centerChunk = worldView.func_217349_x(structureBlockInfoWorld.field_186242_a);
            BlockState centerState = centerChunk.func_180495_p(structureBlockInfoWorld.field_186242_a);
            BlockPos abovePos = structureBlockInfoWorld.field_186242_a.func_177984_a();
            BlockState aboveState = centerChunk.func_180495_p(abovePos);
            if (random.nextFloat() < this.probability && centerState.func_196958_f() && Block.func_208061_a((VoxelShape)aboveState.func_196952_d((IBlockReader)worldView, abovePos), (Direction)Direction.DOWN)) {
                BlockPos.Mutable mutable = new BlockPos.Mutable();
                List shuffledDirectionList = Direction.Plane.HORIZONTAL.func_239636_a_().collect(Collectors.toList());
                Collections.shuffle(shuffledDirectionList);
                block0: for (Direction facing : shuffledDirectionList) {
                    mutable.func_189533_g((Vector3i)structureBlockInfoWorld.field_186242_a).func_189536_c(facing);
                    BlockState worldState = worldView.func_217349_x((BlockPos)mutable).func_180495_p((BlockPos)mutable);
                    if (worldState.func_200132_m()) continue;
                    worldView.func_217349_x((BlockPos)mutable).func_177436_a((BlockPos)mutable, this.blockState, false);
                    BlockState vineBlock = (BlockState)((BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)VineBlock.func_176267_a((Direction)facing), (Comparable)Boolean.valueOf(true))).func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true));
                    mutable.func_189536_c(facing.func_176734_d());
                    centerChunk.func_177436_a((BlockPos)mutable, vineBlock, false);
                    vineBlock = (BlockState)vineBlock.func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(false));
                    for (int depth = random.nextInt(4); depth < 3; ++depth) {
                        mutable.func_189536_c(Direction.DOWN);
                        if (!centerChunk.func_180495_p((BlockPos)mutable).func_196958_f()) break block0;
                        centerChunk.func_177436_a((BlockPos)mutable, vineBlock, false);
                    }
                }
            }
        }
        return structureBlockInfoWorld;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return RSProcessors.CEILING_VINE_POST_PROCESSOR;
    }
}

