/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class FloodWithWaterProcessor
extends StructureProcessor {
    public static final Codec<FloodWithWaterProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("flood_level").forGetter(config -> config.floodLevel)).apply((Applicative)instance, instance.stable(FloodWithWaterProcessor::new)));
    private final int floodLevel;

    private FloodWithWaterProcessor(int floodLevel) {
        this.floodLevel = floodLevel;
    }

    public Template.BlockInfo func_230386_a_(IWorldReader worldView, BlockPos pos, BlockPos blockPos, Template.BlockInfo structureBlockInfoLocal, Template.BlockInfo structureBlockInfoWorld, PlacementSettings structurePlacementData) {
        if (structureBlockInfoWorld.field_186243_b.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) {
            this.tickWaterFluid(worldView, structureBlockInfoWorld);
            return structureBlockInfoWorld;
        }
        if (structureBlockInfoWorld.field_186242_a.func_177956_o() <= this.floodLevel) {
            boolean flooded = false;
            if (structureBlockInfoWorld.field_186243_b.func_196958_f()) {
                structureBlockInfoWorld = new Template.BlockInfo(structureBlockInfoWorld.field_186242_a, Blocks.field_150355_j.func_176223_P(), null);
                this.tickWaterFluid(worldView, structureBlockInfoWorld);
                flooded = true;
            } else if (structureBlockInfoWorld.field_186243_b.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                structureBlockInfoWorld = new Template.BlockInfo(structureBlockInfoWorld.field_186242_a, (BlockState)structureBlockInfoWorld.field_186243_b.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), structureBlockInfoWorld.field_186244_c);
                this.tickWaterFluid(worldView, structureBlockInfoWorld);
                flooded = true;
            } else if (structureBlockInfoWorld.field_186243_b.func_177230_c() instanceof BushBlock) {
                structureBlockInfoWorld = new Template.BlockInfo(structureBlockInfoWorld.field_186242_a, Blocks.field_150355_j.func_176223_P(), null);
                this.tickWaterFluid(worldView, structureBlockInfoWorld);
                flooded = true;
            }
            if (flooded) {
                ChunkPos currentChunkPos = new ChunkPos(structureBlockInfoWorld.field_186242_a);
                IChunk currentChunk = worldView.func_212866_a_(currentChunkPos.field_77276_a, currentChunkPos.field_77275_b);
                BlockPos.Mutable mutable = new BlockPos.Mutable();
                for (Direction direction : Direction.values()) {
                    BlockState neighboringBlock;
                    if (direction == Direction.UP) continue;
                    mutable.func_189533_g((Vector3i)structureBlockInfoWorld.field_186242_a).func_189536_c(direction);
                    if (currentChunkPos.field_77276_a != mutable.func_177958_n() >> 4 || currentChunkPos.field_77275_b != mutable.func_177952_p() >> 4) {
                        currentChunk = worldView.func_217349_x((BlockPos)mutable);
                        currentChunkPos = new ChunkPos((BlockPos)mutable);
                    }
                    if ((neighboringBlock = currentChunk.func_180495_p((BlockPos)mutable)).func_200132_m() || !neighboringBlock.func_204520_s().func_206888_e()) continue;
                    currentChunk.func_177436_a((BlockPos)mutable, Blocks.field_196700_dk.func_176223_P(), false);
                }
            }
        }
        return structureBlockInfoWorld;
    }

    private void tickWaterFluid(IWorldReader worldView, Template.BlockInfo structureBlockInfoWorld) {
        IChunk currentChunk = worldView.func_217349_x(structureBlockInfoWorld.field_186242_a);
        currentChunk.func_212247_j().func_205360_a(structureBlockInfoWorld.field_186242_a, (Object)Fluids.field_204546_a, 1);
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return RSProcessors.FLOOD_WITH_WATER_PROCESSOR;
    }
}

