/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public abstract class AbstractNetherStructure
extends AbstractBaseStructure<NoFeatureConfig> {
    public AbstractNetherStructure(Codec<NoFeatureConfig> config) {
        super(config);
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig defaultFeatureConfig) {
        boolean isNetherOutpost = RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)RSStructureTagMap.STRUCTURE_TAGS.NETHER_OUTPOST).contains((Object)this);
        int radius = isNetherOutpost ? 6 : 3;
        for (int curChunkX = chunkX - radius; curChunkX <= chunkX + radius; ++curChunkX) {
            for (int curChunkZ = chunkZ - radius; curChunkZ <= chunkZ + radius; ++curChunkZ) {
                if (curChunkX == chunkX && curChunkZ == chunkZ) continue;
                for (Structure<?> structureFeature : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)RSStructureTagMap.STRUCTURE_TAGS.GENERIC_AVOID_NETHER_STRUCTURE)) {
                    StructureSeparationSettings structureConfig = chunkGenerator.func_235957_b_().func_236197_a_(structureFeature);
                    if (structureConfig == null || structureConfig.func_236668_a_() <= 8) continue;
                    ChunkPos chunkPos2 = structureFeature.func_236392_a_(structureConfig, seed, chunkRandom, curChunkX, curChunkZ);
                    if (curChunkX != chunkPos2.field_77276_a || curChunkZ != chunkPos2.field_77275_b) continue;
                    return false;
                }
            }
        }
        return super.func_230363_a_(chunkGenerator, biomeSource, seed, chunkRandom, chunkX, chunkZ, biome, chunkPos, (IFeatureConfig)defaultFeatureConfig);
    }

    public static abstract class AbstractStart
    extends MarginedStructureStart<NoFeatureConfig> {
        public AbstractStart(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public BlockPos getHighestLand(ChunkGenerator chunkGenerator) {
            BlockPos.Mutable mutable = new BlockPos.Mutable().func_181079_c(this.field_75074_b.func_215126_f().func_177958_n(), chunkGenerator.func_230355_e_() - 20, this.field_75074_b.func_215126_f().func_177952_p());
            IBlockReader blockView = chunkGenerator.func_230348_a_(mutable.func_177958_n(), mutable.func_177952_p());
            while (mutable.func_177956_o() > chunkGenerator.func_230356_f_() - 2) {
                BlockState currentBlockstate = blockView.func_180495_p((BlockPos)mutable);
                if (!currentBlockstate.func_215686_e(blockView, (BlockPos)mutable)) {
                    mutable.func_189536_c(Direction.DOWN);
                    continue;
                }
                if (blockView.func_180495_p(mutable.func_177982_a(0, 3, 0)).func_185904_a() == Material.field_151579_a && !currentBlockstate.func_196958_f()) break;
                mutable.func_189536_c(Direction.DOWN);
            }
            return mutable;
        }

        public BlockPos getLowestLand(ChunkGenerator chunkGenerator) {
            BlockPos.Mutable mutable = new BlockPos.Mutable().func_181079_c(this.field_75074_b.func_215126_f().func_177958_n(), chunkGenerator.func_230356_f_() + 3, this.field_75074_b.func_215126_f().func_177952_p());
            IBlockReader blockView = chunkGenerator.func_230348_a_(mutable.func_177958_n(), mutable.func_177952_p());
            BlockState currentBlockstate = blockView.func_180495_p((BlockPos)mutable);
            while (mutable.func_177956_o() <= chunkGenerator.func_230355_e_() - 20) {
                if (blockView.func_180495_p((BlockPos)mutable).func_185904_a() != Material.field_151579_a && blockView.func_180495_p(mutable.func_177984_a()).func_185904_a() == Material.field_151579_a && blockView.func_180495_p(mutable.func_177981_b(5)).func_185904_a() == Material.field_151579_a && !currentBlockstate.func_196958_f()) {
                    mutable.func_189536_c(Direction.UP);
                    break;
                }
                mutable.func_189536_c(Direction.UP);
                currentBlockstate = blockView.func_180495_p((BlockPos)mutable);
            }
            return mutable;
        }
    }
}

