/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.PieceLimitedJigsawManager;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.StructurePiecesBehavior;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.CheckerboardBiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.common.util.Lazy;

public class AdvancedJigsawStructure
extends AbstractBaseStructure<NoFeatureConfig> {
    protected final ResourceLocation startPool;
    protected final Lazy<Integer> structureSize;
    protected final Lazy<Integer> biomeRange;
    protected final List<MobSpawnInfo.Spawners> monsterSpawns;
    protected final List<MobSpawnInfo.Spawners> creatureSpawns;
    protected final Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces;
    protected final Lazy<Integer> maxY;
    protected final Lazy<Integer> minY;
    protected final Lazy<Integer> verticalRange;
    protected final boolean clipOutOfBoundsPieces;

    public AdvancedJigsawStructure(ResourceLocation poolID, Lazy<Integer> structureSize, Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces, Lazy<Integer> maxY, Lazy<Integer> minY) {
        this(poolID, structureSize, (Lazy<Integer>)Lazy.of(() -> 0), new ArrayList<MobSpawnInfo.Spawners>(), new ArrayList<MobSpawnInfo.Spawners>(), requiredPieces, maxY, minY, true, null);
    }

    public AdvancedJigsawStructure(ResourceLocation poolID, Lazy<Integer> structureSize, List<MobSpawnInfo.Spawners> monsterSpawns, Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces, Lazy<Integer> maxY, Lazy<Integer> minY) {
        this(poolID, structureSize, (Lazy<Integer>)Lazy.of(() -> 0), monsterSpawns, new ArrayList<MobSpawnInfo.Spawners>(), requiredPieces, maxY, minY, true, null);
    }

    public AdvancedJigsawStructure(ResourceLocation poolID, Lazy<Integer> structureSize, Lazy<Integer> biomeRange, List<MobSpawnInfo.Spawners> monsterSpawns, Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces, Lazy<Integer> maxY, Lazy<Integer> minY, boolean clipOutOfBoundsPieces, Lazy<Integer> verticalRange) {
        this(poolID, structureSize, biomeRange, monsterSpawns, new ArrayList<MobSpawnInfo.Spawners>(), requiredPieces, maxY, minY, clipOutOfBoundsPieces, verticalRange);
    }

    public AdvancedJigsawStructure(ResourceLocation poolID, Lazy<Integer> structureSize, Lazy<Integer> biomeRange, List<MobSpawnInfo.Spawners> monsterSpawns, List<MobSpawnInfo.Spawners> creatureSpawns, Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces, Lazy<Integer> maxY, Lazy<Integer> minY, boolean clipOutOfBoundsPieces, Lazy<Integer> verticalRange) {
        super(NoFeatureConfig.field_236558_a_);
        this.startPool = poolID;
        this.structureSize = structureSize;
        this.biomeRange = biomeRange;
        this.monsterSpawns = monsterSpawns;
        this.creatureSpawns = creatureSpawns;
        this.requiredPieces = requiredPieces;
        this.maxY = maxY;
        this.minY = minY;
        this.clipOutOfBoundsPieces = clipOutOfBoundsPieces;
        this.verticalRange = verticalRange;
        RSStructures.RS_STRUCTURE_START_PIECES.add(this.startPool);
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return this.monsterSpawns;
    }

    public List<MobSpawnInfo.Spawners> getDefaultCreatureSpawnList() {
        return this.creatureSpawns;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig noFeatureConfig) {
        if (!(biomeSource instanceof CheckerboardBiomeProvider)) {
            int range = (Integer)this.biomeRange.get();
            for (int curChunkX = chunkX - range; curChunkX <= chunkX + range; ++curChunkX) {
                for (int curChunkZ = chunkZ - range; curChunkZ <= chunkZ + range; ++curChunkZ) {
                    if (biomeSource.func_225526_b_(curChunkX << 2, 64, curChunkZ << 2).func_242440_e().func_242493_a((Structure)this)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new MainStart((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public class MainStart
    extends MarginedStructureStart<NoFeatureConfig> {
        public MainStart(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig noFeatureConfig) {
            int bottomClipOff;
            int topClipOff;
            BlockPos.Mutable blockpos = new BlockPos.Mutable(chunkX * 16, 0, chunkZ * 16);
            if ((Integer)AdvancedJigsawStructure.this.maxY.get() - (Integer)AdvancedJigsawStructure.this.minY.get() <= 0) {
                RepurposedStructures.LOGGER.error("MinY should always be less than MaxY or else a crash will occur or no pieces will spawn. Problematic structure is:" + Registry.field_218361_B.func_148757_b((Object)this.func_214627_k()));
            }
            int structureStartHeight = this.field_214631_d.nextInt((Integer)AdvancedJigsawStructure.this.maxY.get() - (Integer)AdvancedJigsawStructure.this.minY.get()) + (Integer)AdvancedJigsawStructure.this.minY.get();
            blockpos.func_189534_c(Direction.UP, structureStartHeight);
            if (AdvancedJigsawStructure.this.verticalRange == null) {
                topClipOff = AdvancedJigsawStructure.this.clipOutOfBoundsPieces ? (Integer)AdvancedJigsawStructure.this.maxY.get() + 5 : Integer.MAX_VALUE;
                bottomClipOff = AdvancedJigsawStructure.this.clipOutOfBoundsPieces ? (Integer)AdvancedJigsawStructure.this.minY.get() - 5 : Integer.MIN_VALUE;
            } else {
                topClipOff = structureStartHeight + (Integer)AdvancedJigsawStructure.this.verticalRange.get();
                bottomClipOff = structureStartHeight - (Integer)AdvancedJigsawStructure.this.verticalRange.get();
            }
            PieceLimitedJigsawManager.assembleJigsawStructure(dynamicRegistryManager, new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(AdvancedJigsawStructure.this.startPool), ((Integer)AdvancedJigsawStructure.this.structureSize.get()).intValue()), chunkGenerator, structureManager, (BlockPos)blockpos, this.field_75075_a, (Random)this.field_214631_d, false, false, AdvancedJigsawStructure.this.requiredPieces, topClipOff, bottomClipOff);
            this.func_202500_a();
        }
    }
}

