/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.RSMineshaftStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.StructurePiecesBehavior;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.common.util.Lazy;

public class RSMineshaftEndStructure
extends RSMineshaftStructure {
    private static final List<MobSpawnInfo.Spawners> MONSTER_SPAWNS = Lists.newArrayList((Object[])new MobSpawnInfo.Spawners[]{new MobSpawnInfo.Spawners(EntityType.field_200804_r, 10, 2, 5), new MobSpawnInfo.Spawners(EntityType.field_200803_q, 5, 1, 3)});

    public RSMineshaftEndStructure(ResourceLocation poolID, Lazy<Integer> structureSize, Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces, Lazy<Integer> maxY, Lazy<Integer> minY, Lazy<Float> probability, RSMineshaftStructure.ENVIRONMENT_CHECK environmentCheck) {
        super(poolID, structureSize, requiredPieces, maxY, minY, probability, environmentCheck);
    }

    @Override
    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return MONSTER_SPAWNS;
    }

    @Override
    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int x, int z, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        StructureSeparationSettings structureConfig = chunkGenerator.func_235957_b_().func_236197_a_((Structure)this);
        if (structureConfig != null) {
            chunkRandom.func_202425_c(seed + (long)structureConfig.func_236673_c_(), x, z);
            double d = (double)((Float)this.probability.get()).floatValue() / 10000.0;
            if (chunkRandom.nextDouble() < d) {
                if (RepurposedStructures.RSMineshaftsConfig.barrensIslandsEndMineshafts.get().booleanValue()) {
                    return true;
                }
                int minLandHeight = Math.min(chunkGenerator.func_230355_e_(), 45);
                int xPos = x << 4;
                int zPos = z << 4;
                int landHeight = chunkGenerator.func_222531_c(xPos, zPos, Heightmap.Type.WORLD_SURFACE_WG);
                if ((landHeight = Math.min(landHeight, chunkGenerator.func_222531_c(xPos + 70, zPos, Heightmap.Type.WORLD_SURFACE_WG))) < minLandHeight) {
                    return false;
                }
                if ((landHeight = Math.min(landHeight, chunkGenerator.func_222531_c(xPos, zPos + 70, Heightmap.Type.WORLD_SURFACE_WG))) < minLandHeight) {
                    return false;
                }
                if ((landHeight = Math.min(landHeight, chunkGenerator.func_222531_c(xPos - 70, zPos, Heightmap.Type.WORLD_SURFACE_WG))) < minLandHeight) {
                    return false;
                }
                return (landHeight = Math.min(landHeight, chunkGenerator.func_222531_c(xPos, zPos - 70, Heightmap.Type.WORLD_SURFACE_WG))) >= minLandHeight;
            }
        }
        return false;
    }
}

