/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.misc.PieceLimitedJigsawManager;
import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.StructurePiecesBehavior;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.common.util.Lazy;

public class RSNetherStrongholdStructure
extends AdvancedJigsawStructure {
    private static final List<MobSpawnInfo.Spawners> MONSTER_SPAWNS = Lists.newArrayList((Object[])new MobSpawnInfo.Spawners[]{new MobSpawnInfo.Spawners(EntityType.field_200792_f, 10, 2, 3), new MobSpawnInfo.Spawners(EntityType.field_233592_ba_, 3, 4, 4), new MobSpawnInfo.Spawners(EntityType.field_200722_aA, 10, 5, 5), new MobSpawnInfo.Spawners(EntityType.field_200741_ag, 2, 5, 5), new MobSpawnInfo.Spawners(EntityType.field_200771_K, 3, 4, 4)});

    public RSNetherStrongholdStructure(ResourceLocation poolID, Lazy<Integer> structureSize, Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces, Lazy<Integer> maxY, Lazy<Integer> minY) {
        super(poolID, structureSize, MONSTER_SPAWNS, requiredPieces, maxY, minY);
    }

    @Override
    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int x, int z, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        return x * x + z * z > 31000;
    }

    @Override
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public class Start
    extends AdvancedJigsawStructure.MainStart {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        @Override
        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig noFeatureConfig) {
            BlockPos.Mutable blockpos = new BlockPos.Mutable(chunkX * 16, 0, chunkZ * 16);
            blockpos.func_189534_c(Direction.UP, (Integer)RSNetherStrongholdStructure.this.maxY.get() - 5);
            PieceLimitedJigsawManager.assembleJigsawStructure(dynamicRegistryManager, new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(RSNetherStrongholdStructure.this.startPool), ((Integer)RSNetherStrongholdStructure.this.structureSize.get()).intValue()), chunkGenerator, structureManager, (BlockPos)blockpos, this.field_75075_a, (Random)this.field_214631_d, false, false, RSNetherStrongholdStructure.this.requiredPieces, (Integer)RSNetherStrongholdStructure.this.maxY.get(), (Integer)RSNetherStrongholdStructure.this.minY.get());
            this.func_202500_a();
        }
    }
}

