/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class ShipwreckEndStructure
extends AbstractBaseStructure<NoFeatureConfig> {
    private final ResourceLocation START_POOL = new ResourceLocation("repurposed_structures", "shipwrecks/end");

    public ShipwreckEndStructure() {
        super(NoFeatureConfig.field_236558_a_);
        RSStructures.RS_STRUCTURE_START_PIECES.add(this.START_POOL);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    protected boolean isFeatureChunk(ChunkGenerator generator, BiomeProvider biomeProvider, long seed, SharedSeedRandom random, int x, int z, Biome biome, ChunkPos chunkPos, NoFeatureConfig config) {
        return ShipwreckEndStructure.getYPosForStructure(x, z, generator) >= Math.min(generator.func_230355_e_(), 20);
    }

    private static int getYPosForStructure(int x, int z, ChunkGenerator generator) {
        Random random = new Random(x + z * 10387313);
        Rotation rotation = Rotation.func_222466_a((Random)random);
        int i = 5;
        int j = 5;
        if (rotation == Rotation.CLOCKWISE_90) {
            i = -5;
        } else if (rotation == Rotation.CLOCKWISE_180) {
            i = -5;
            j = -5;
        } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            j = -5;
        }
        int k = (x << 4) + 7;
        int l = (z << 4) + 7;
        int i1 = generator.func_222531_c(k, l, Heightmap.Type.WORLD_SURFACE_WG);
        int j1 = generator.func_222531_c(k, l + j, Heightmap.Type.WORLD_SURFACE_WG);
        int k1 = generator.func_222531_c(k + i, l, Heightmap.Type.WORLD_SURFACE_WG);
        int l1 = generator.func_222531_c(k + i, l + j, Heightmap.Type.WORLD_SURFACE_WG);
        return Math.min(Math.min(i1, j1), Math.min(k1, l1));
    }

    public class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig NoFeatureConfig2) {
            BlockPos blockPos = new BlockPos(chunkX * 16, 64, chunkZ * 16);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(ShipwreckEndStructure.this.START_POOL), 1), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)structureManager, (BlockPos)blockPos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)true, (boolean)false);
            this.func_202500_a();
            BlockPos blockPos2 = new BlockPos(((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_215126_f());
            int highestLandPos = chunkGenerator.func_222529_a(blockPos2.func_177958_n(), blockPos2.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
            highestLandPos = Math.max(30, highestLandPos);
            this.func_214626_a((Random)this.field_214631_d, highestLandPos - 5, highestLandPos - 3);
        }
    }
}

