/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.terraformersmc.terraform.shapes.api;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import shadow.com.terraformersmc.terraform.shapes.api.Filler;
import shadow.com.terraformersmc.terraform.shapes.api.Position;
import shadow.com.terraformersmc.terraform.shapes.api.layer.Layer;
import shadow.com.terraformersmc.terraform.shapes.api.validator.Validator;

public interface Shape {
    public static Shape of(final Predicate<Position> equation, final Position max, final Position min) {
        return new Shape(){
            private Optional<Boolean> valid = Optional.empty();

            @Override
            public Position max() {
                return max;
            }

            @Override
            public Position min() {
                return min;
            }

            @Override
            public Predicate<Position> equation() {
                return equation;
            }

            @Override
            public Shape validate(Validator validator, Consumer<Shape> consumer) {
                boolean valid = validator.validate(this);
                if (valid) {
                    consumer.accept(this);
                }
                this.valid = Optional.of(valid);
                return this;
            }

            public boolean passValid() {
                return this.valid.orElse(false);
            }
        };
    }

    public Position max();

    public Position min();

    public Predicate<Position> equation();

    default public Stream<Position> stream() {
        return Position.stream(this.max(), this.min()).filter(pos -> this.equation().test(pos.copy()));
    }

    default public Shape applyLayer(Layer layer) {
        return Shape.of(layer.modifyEquation(this), layer.modifyMax(this), layer.modifyMin(this));
    }

    default public Shape validate(Validator validator, Consumer<Shape> consumer) {
        if (validator.validate(this)) {
            consumer.accept(this);
        }
        return this;
    }

    default public void fill(Filler filler) {
        this.stream().forEach(filler);
    }
}

