/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.element;

import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.element.IDataElement;
import slimeknights.mantle.client.book.repository.BookRepository;

public class ItemStackData
implements IDataElement {
    public String itemList = null;
    public String tag = null;
    public transient String action;
    private transient NonNullList<ItemStack> items;
    public String id = "";
    public byte amount = 1;
    public JsonObject nbt;
    private transient boolean customData;
    private transient boolean isTag;
    private transient int tagGeneration;

    public NonNullList<ItemStack> getItems() {
        if (this.isTag && this.tagGeneration != 0) {
            this.loadTag();
        }
        if (this.items != null) {
            return this.items;
        }
        return NonNullList.func_191197_a((int)1, (Object)this.getItem());
    }

    private ItemStack getItem() {
        Item item;
        boolean isMissingItem = false;
        try {
            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.id));
        }
        catch (Exception e) {
            item = Items.field_221803_eL;
            isMissingItem = true;
        }
        if (item == Items.field_190931_a) {
            item = Items.field_221803_eL;
            isMissingItem = true;
        }
        ItemStack itemStack = new ItemStack((IItemProvider)item, (int)this.amount);
        if (this.nbt != null) {
            try {
                itemStack.func_77982_d(JsonToNBT.func_180713_a((String)ItemStackData.filterJsonQuotes(this.nbt.toString())));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        if (isMissingItem) {
            CompoundNBT display = itemStack.func_190925_c("display");
            display.func_74778_a("Name", "\u00a7rUnknown Item");
            ListNBT lore = new ListNBT();
            lore.add((Object)StringNBT.func_229705_a_((String)"\u00a7r\u00a7eItem Name:"));
            lore.add((Object)StringNBT.func_229705_a_((String)("\u00a7r\u00a7e" + this.id)));
            display.func_218657_a("Lore", (INBT)lore);
        }
        return itemStack;
    }

    public static ItemStackData getItemStackData(ItemStack stack) {
        return ItemStackData.getItemStackData(stack, false);
    }

    public static ItemStackData getItemStackData(ItemStack stack, boolean ignoreNbt) {
        ItemStackData data = new ItemStackData();
        data.id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.func_77973_b()).toString();
        data.amount = (byte)stack.func_190916_E();
        if (!ignoreNbt && stack.func_77978_p() != null) {
            data.nbt = BookLoader.GSON.toJsonTree((Object)stack.func_77978_p(), CompoundNBT.class).getAsJsonObject();
        }
        return data;
    }

    public static ItemStackData getItemStackData(NonNullList<ItemStack> items) {
        ItemStackData data = new ItemStackData();
        data.items = items;
        data.customData = true;
        data.id = "->itemList";
        return data;
    }

    public static String filterJsonQuotes(String s) {
        return s.replaceAll("\"(\\w+)\"\\s*:", "$1: ");
    }

    private void loadTag() {
        this.isTag = true;
        this.tagGeneration = 0;
        ITag values = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(this.tag));
        this.items = values != null ? values.func_230236_b_().stream().map(ItemStack::new).collect(Collectors.toCollection(NonNullList::func_191196_a)) : NonNullList.func_191196_a();
    }

    @Override
    public void load(BookRepository source) {
        if (this.customData) {
            return;
        }
        if (!StringUtils.func_151246_b((String)this.tag) && ResourceLocation.func_217855_b((String)this.tag)) {
            this.loadTag();
            this.id = "->itemList";
            return;
        }
        ResourceLocation location = source.getResourceLocation(this.itemList);
        if (location != null) {
            this.id = "->itemList";
            if (source.resourceExists(location)) {
                try {
                    ItemsList itemsList = (ItemsList)BookLoader.GSON.fromJson(source.resourceToString(source.getResource(location)), ItemsList.class);
                    this.items = NonNullList.func_191197_a((int)itemsList.items.length, (Object)ItemStack.field_190927_a);
                    for (int i = 0; i < itemsList.items.length; ++i) {
                        this.items.set(i, (Object)itemsList.items[i].getItem());
                    }
                    this.action = itemsList.action;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static class ItemLink {
        public ItemStackData item = new ItemStackData();
        public boolean damageSensitive = false;
        public String action = "";
    }

    private static class ItemsList {
        public ItemStackData[] items = new ItemStackData[0];
        public String action;

        private ItemsList() {
        }
    }
}

