/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import slimeknights.mantle.client.book.structure.StructureInfo;
import slimeknights.mantle.client.book.structure.world.TemplateWorld;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;

public class StructureElement
extends SizedBookElement {
    public boolean canTick = false;
    public float scale = 50.0f;
    public float transX = 0.0f;
    public float transY = 0.0f;
    public TransformationMatrix additionalTransform;
    public final StructureInfo renderInfo;
    public final TemplateWorld structureWorld;
    public long lastStep = -1L;
    public long lastPrintedErrorTimeMs = -1L;

    public StructureElement(int x, int y, int width, int height, Template template, List<Template.BlockInfo> structure) {
        super(x, y, width, height);
        int[] size = new int[]{template.func_186259_a().func_177958_n(), template.func_186259_a().func_177956_o(), template.func_186259_a().func_177952_p()};
        this.scale = 100.0f / (float)IntStream.of(size).max().getAsInt();
        float sx = (float)width / (float)BookScreen.PAGE_WIDTH;
        float sy = (float)height / (float)BookScreen.PAGE_HEIGHT;
        this.scale *= Math.min(sx, sy);
        this.renderInfo = new StructureInfo(structure);
        this.structureWorld = new TemplateWorld(structure, this.renderInfo);
        this.transX = (float)x + (float)width / 2.0f;
        this.transY = (float)y + (float)height / 2.0f;
        this.additionalTransform = new TransformationMatrix(null, new Quaternion(25.0f, 0.0f, 0.0f, true), null, new Quaternion(0.0f, -45.0f, 0.0f, true));
    }

    @Override
    public void draw(MatrixStack transform, int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        MatrixStack.Entry lastEntryBeforeTry = transform.func_227866_c_();
        try {
            long currentTime = System.currentTimeMillis();
            if (this.lastStep < 0L) {
                this.lastStep = currentTime;
            } else if (this.canTick && currentTime - this.lastStep > 200L) {
                this.renderInfo.step();
                this.lastStep = currentTime;
            }
            if (!this.canTick) {
                this.renderInfo.reset();
            }
            int structureLength = this.renderInfo.structureLength;
            int structureWidth = this.renderInfo.structureWidth;
            int structureHeight = this.renderInfo.structureHeight;
            transform.func_227860_a_();
            BlockRendererDispatcher blockRender = Minecraft.func_71410_x().func_175602_ab();
            transform.func_227861_a_((double)this.transX, (double)this.transY, (double)Math.max(structureHeight, Math.max(structureWidth, structureLength)));
            transform.func_227862_a_(this.scale, -this.scale, 1.0f);
            this.additionalTransform.push(transform);
            transform.func_227863_a_(new Quaternion(0.0f, 0.0f, 0.0f, true));
            transform.func_227861_a_((double)((float)structureLength / -2.0f), (double)((float)structureHeight / -2.0f), (double)((float)structureWidth / -2.0f));
            for (int h = 0; h < structureHeight; ++h) {
                for (int l = 0; l < structureLength; ++l) {
                    for (int w = 0; w < structureWidth; ++w) {
                        BlockPos pos = new BlockPos(l, h, w);
                        BlockState state = this.structureWorld.func_180495_p(pos);
                        if (state.isAir((IBlockReader)this.structureWorld, pos)) continue;
                        transform.func_227860_a_();
                        transform.func_227861_a_((double)l, (double)h, (double)w);
                        int overlay = pos.equals((Object)new BlockPos(1, 1, 1)) ? OverlayTexture.func_229200_a_((float)0.0f, (boolean)true) : OverlayTexture.field_229196_a_;
                        EmptyModelData modelData = EmptyModelData.INSTANCE;
                        TileEntity te = this.structureWorld.func_175625_s(pos);
                        if (te != null) {
                            modelData = te.getModelData();
                        }
                        RenderSystem.disableLighting();
                        blockRender.renderBlock(state, transform, (IRenderTypeBuffer)buffer, 0xF000F0, overlay, (IModelData)modelData);
                        transform.func_227865_b_();
                    }
                }
            }
            transform.func_227865_b_();
            transform.func_227865_b_();
        }
        catch (Exception e) {
            long now = System.currentTimeMillis();
            if (now > this.lastPrintedErrorTimeMs + 1000L) {
                e.printStackTrace();
                this.lastPrintedErrorTimeMs = now;
            }
            while (lastEntryBeforeTry != transform.func_227866_c_()) {
                transform.func_227865_b_();
            }
        }
        buffer.func_228461_a_();
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public void mouseDragged(double clickX, double clickY, double mouseX, double mouseY, double lastX, double lastY, int button) {
        double dx = mouseX - lastX;
        double dy = mouseY - lastY;
        this.additionalTransform = this.forRotation(dx * 80.0 / 104.0, dy * 0.8).compose(this.additionalTransform);
    }

    @Override
    public void mouseReleased(double mouseX, double mouseY, int clickedMouseButton) {
        super.mouseReleased(mouseX, mouseY, clickedMouseButton);
    }

    private TransformationMatrix forRotation(double rX, double rY) {
        Vector3f axis = new Vector3f((float)rY, (float)rX, 0.0f);
        float angle = (float)Math.sqrt(axis.func_195903_b(axis));
        if (!axis.func_229194_d_()) {
            return TransformationMatrix.func_227983_a_();
        }
        return new TransformationMatrix(null, new Quaternion(axis, angle, true), null, null);
    }
}

