/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.config.Config;

public class TagPreference<T extends IForgeRegistryEntry<T>> {
    private static final Map<Class<?>, TagPreference<?>> PREFERENCE_MAP = new IdentityHashMap();
    private static final Supplier<ITagCollection<Item>> ITEM_TAG_COLLECTION_SUPPLIER = () -> TagCollectionManager.func_242178_a().func_241836_b();
    private static final Supplier<ITagCollection<Fluid>> FLUID_TAG_COLLECTION_SUPPLIER = () -> TagCollectionManager.func_242178_a().func_241837_c();
    private final Supplier<ITagCollection<T>> collection;
    private final Map<ResourceLocation, Optional<T>> preferenceCache = new HashMap<ResourceLocation, Optional<T>>();

    public static <T extends IForgeRegistryEntry<T>> TagPreference<T> getInstance(Class<T> clazz, Supplier<ITagCollection<T>> collection) {
        return PREFERENCE_MAP.computeIfAbsent(clazz, c -> new TagPreference(collection));
    }

    public static TagPreference<Item> getItems() {
        return TagPreference.getInstance(Item.class, ITEM_TAG_COLLECTION_SUPPLIER);
    }

    public static TagPreference<Fluid> getFluids() {
        return TagPreference.getInstance(Fluid.class, FLUID_TAG_COLLECTION_SUPPLIER);
    }

    private TagPreference(Supplier<ITagCollection<T>> collection) {
        this.collection = collection;
        MinecraftForge.EVENT_BUS.addListener(this::clearCache);
    }

    private void clearCache(TagsUpdatedEvent.VanillaTagTypes event) {
        this.preferenceCache.clear();
    }

    private static int getSortIndex(IForgeRegistryEntry<?> entry) {
        List<? extends String> entries = Config.TAG_PREFERENCES.get();
        int index = entries.indexOf(Objects.requireNonNull(entry.getRegistryName()).func_110624_b());
        if (index == -1) {
            return entries.size();
        }
        return index;
    }

    public Optional<T> getPreference(ITag<T> tag) {
        ResourceLocation tagName = this.collection.get().func_232975_b_(tag);
        return this.preferenceCache.computeIfAbsent(tagName, name -> {
            if (tag instanceof Tags.IOptionalNamedTag && ((Tags.IOptionalNamedTag)tag).isDefaulted()) {
                return Optional.empty();
            }
            List elements = tag.func_230236_b_();
            if (elements.isEmpty()) {
                return Optional.empty();
            }
            if (elements.size() == 1) {
                return Optional.of(elements.get(0));
            }
            ArrayList sortedElements = Lists.newArrayList((Iterable)elements);
            sortedElements.sort(Comparator.comparingInt(TagPreference::getSortIndex));
            return Optional.of(sortedElements.get(0));
        });
    }
}

