/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.crafting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.mantle.recipe.MantleRecipeSerializers;
import slimeknights.mantle.util.JsonHelper;

public class ShapedFallbackRecipe
extends ShapedRecipe {
    private final List<ResourceLocation> alternatives;
    private List<ICraftingRecipe> alternativeCache;

    public ShapedFallbackRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> ingredients, ItemStack output, List<ResourceLocation> alternatives) {
        super(id, group, width, height, ingredients, output);
        this.alternatives = alternatives;
    }

    public ShapedFallbackRecipe(ShapedRecipe base, List<ResourceLocation> alternatives) {
        this(base.func_199560_c(), base.func_193358_e(), base.func_192403_f(), base.func_192404_g(), (NonNullList<Ingredient>)base.func_192400_c(), base.func_77571_b(), alternatives);
    }

    public boolean func_77569_a(CraftingInventory inv, World world) {
        if (!super.func_77569_a(inv, world)) {
            return false;
        }
        if (this.alternativeCache == null) {
            RecipeManager manager = world.func_199532_z();
            this.alternativeCache = this.alternatives.stream().map(arg_0 -> ((RecipeManager)manager).func_215367_a(arg_0)).filter(Optional::isPresent).map(Optional::get).filter(recipe -> {
                Class<?> clazz = recipe.getClass();
                return clazz == ShapedRecipe.class || clazz == ShapelessRecipe.class;
            }).map(recipe -> (ICraftingRecipe)recipe).collect(Collectors.toList());
        }
        return this.alternativeCache.stream().noneMatch(recipe -> recipe.func_77569_a((IInventory)inv, world));
    }

    public IRecipeSerializer<?> func_199559_b() {
        return MantleRecipeSerializers.CRAFTING_SHAPED_FALLBACK;
    }

    public static class Serializer
    extends ShapedRecipe.Serializer {
        public ShapedFallbackRecipe read(ResourceLocation id, JsonObject json) {
            ShapedRecipe base = super.func_199425_a_(id, json);
            List<ResourceLocation> alternatives = JsonHelper.parseList(json, "alternatives", (element, name) -> new ResourceLocation(JSONUtils.func_151206_a((JsonElement)element, (String)name)));
            return new ShapedFallbackRecipe(base, alternatives);
        }

        public ShapedFallbackRecipe read(ResourceLocation id, PacketBuffer buffer) {
            ShapedRecipe base = super.func_199426_a_(id, buffer);
            assert (base != null);
            int size = buffer.func_150792_a();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add((Object)buffer.func_192575_l());
            }
            return new ShapedFallbackRecipe(base, (List<ResourceLocation>)builder.build());
        }

        public void func_199427_a_(PacketBuffer buffer, ShapedRecipe recipe) {
            super.func_199427_a_(buffer, recipe);
            assert (recipe instanceof ShapedFallbackRecipe);
            List alternatives = ((ShapedFallbackRecipe)recipe).alternatives;
            buffer.func_150787_b(alternatives.size());
            for (ResourceLocation alternative : alternatives) {
                buffer.func_192572_a(alternative);
            }
        }
    }
}

