/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.util.JsonHelper;

public class IngredientWithout
extends Ingredient {
    public static final ResourceLocation ID = Mantle.getResource("without");
    public static final IIngredientSerializer<IngredientWithout> SERIALIZER = new Serializer();
    private final Ingredient base;
    private final Ingredient without;
    private ItemStack[] filteredMatchingStacks;
    private IntList packedMatchingStacks;

    public IngredientWithout(Ingredient base, Ingredient without) {
        super(Stream.empty());
        this.base = base;
        this.without = without;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        return this.base.test(stack) && !this.without.test(stack);
    }

    public ItemStack[] func_193365_a() {
        if (this.filteredMatchingStacks == null) {
            this.filteredMatchingStacks = (ItemStack[])Arrays.stream(this.base.func_193365_a()).filter(stack -> !this.without.test(stack)).toArray(ItemStack[]::new);
        }
        return this.filteredMatchingStacks;
    }

    public boolean func_203189_d() {
        return this.func_193365_a().length == 0;
    }

    public boolean isSimple() {
        return this.base.isSimple() && this.without.isSimple();
    }

    protected void invalidate() {
        super.invalidate();
        this.filteredMatchingStacks = null;
        this.packedMatchingStacks = null;
    }

    public IntList func_194139_b() {
        if (this.packedMatchingStacks == null) {
            ItemStack[] matchingStacks = this.func_193365_a();
            this.packedMatchingStacks = new IntArrayList(matchingStacks.length);
            for (ItemStack stack : matchingStacks) {
                this.packedMatchingStacks.add(RecipeItemHelper.func_194113_b((ItemStack)stack));
            }
            this.packedMatchingStacks.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.packedMatchingStacks;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        json.add("base", this.base.func_200304_c());
        json.add("without", this.without.func_200304_c());
        return json;
    }

    public IIngredientSerializer<IngredientWithout> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements IIngredientSerializer<IngredientWithout> {
        private Serializer() {
        }

        public IngredientWithout parse(JsonObject json) {
            Ingredient base = Ingredient.func_199802_a((JsonElement)JsonHelper.getElement(json, "base"));
            Ingredient without = Ingredient.func_199802_a((JsonElement)JsonHelper.getElement(json, "without"));
            return new IngredientWithout(base, without);
        }

        public IngredientWithout parse(PacketBuffer buffer) {
            Ingredient base = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient without = Ingredient.func_199566_b((PacketBuffer)buffer);
            return new IngredientWithout(base, without);
        }

        public void write(PacketBuffer buffer, IngredientWithout ingredient) {
            CraftingHelper.write((PacketBuffer)buffer, (Ingredient)ingredient.base);
            CraftingHelper.write((PacketBuffer)buffer, (Ingredient)ingredient.without);
        }
    }
}

