/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.deferred;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.registration.DelayedSupplier;
import slimeknights.mantle.registration.FluidBuilder;
import slimeknights.mantle.registration.ItemProperties;
import slimeknights.mantle.registration.deferred.DeferredRegisterWrapper;
import slimeknights.mantle.registration.object.FluidObject;

public class FluidDeferredRegister
extends DeferredRegisterWrapper<Fluid> {
    private final DeferredRegister<Block> blockRegister;
    private final DeferredRegister<Item> itemRegister;

    public FluidDeferredRegister(String modID) {
        super(ForgeRegistries.FLUIDS, modID);
        this.blockRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)modID);
        this.itemRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modID);
    }

    @Override
    public void register(IEventBus bus) {
        super.register(bus);
        this.blockRegister.register(bus);
        this.itemRegister.register(bus);
    }

    public <I extends Fluid> RegistryObject<I> registerFluid(String name, Supplier<? extends I> sup) {
        return this.register.register(name, sup);
    }

    public <F extends ForgeFlowingFluid> FluidObject<F> register(String name, String tagName, FluidBuilder builder, Function<ForgeFlowingFluid.Properties, ? extends F> still, Function<ForgeFlowingFluid.Properties, ? extends F> flowing, Function<Supplier<? extends FlowingFluid>, ? extends FlowingFluidBlock> block) {
        DelayedSupplier<ForgeFlowingFluid> stillDelayed = new DelayedSupplier<ForgeFlowingFluid>();
        DelayedSupplier<ForgeFlowingFluid> flowingDelayed = new DelayedSupplier<ForgeFlowingFluid>();
        RegistryObject blockObj = this.blockRegister.register(name + "_fluid", () -> (FlowingFluidBlock)block.apply(stillDelayed));
        builder.bucket((Supplier<? extends Item>)this.itemRegister.register(name + "_bucket", () -> new BucketItem((Supplier)stillDelayed, ItemProperties.BUCKET_PROPS)));
        ForgeFlowingFluid.Properties props = builder.block((Supplier<? extends FlowingFluidBlock>)blockObj).build(stillDelayed, flowingDelayed);
        RegistryObject<ForgeFlowingFluid> stillSup = this.registerFluid(name, () -> (ForgeFlowingFluid)still.apply(props));
        stillDelayed.setSupplier((Supplier<ForgeFlowingFluid>)stillSup);
        RegistryObject<ForgeFlowingFluid> flowingSup = this.registerFluid("flowing_" + name, () -> (ForgeFlowingFluid)flowing.apply(props));
        flowingDelayed.setSupplier((Supplier<ForgeFlowingFluid>)flowingSup);
        return new FluidObject<ForgeFlowingFluid>(this.resource(name), tagName, (Supplier<ForgeFlowingFluid>)stillSup, (Supplier<ForgeFlowingFluid>)flowingSup, (Supplier<FlowingFluidBlock>)((Supplier<? extends FlowingFluidBlock>)blockObj));
    }

    public <F extends ForgeFlowingFluid> FluidObject<F> register(String name, FluidBuilder builder, Function<ForgeFlowingFluid.Properties, ? extends F> still, Function<ForgeFlowingFluid.Properties, ? extends F> flowing, Function<Supplier<? extends FlowingFluid>, ? extends FlowingFluidBlock> block) {
        return this.register(name, name, builder, still, flowing, block);
    }

    public <F extends ForgeFlowingFluid> FluidObject<F> register(String name, String tagName, FluidAttributes.Builder builder, Function<ForgeFlowingFluid.Properties, ? extends F> still, Function<ForgeFlowingFluid.Properties, ? extends F> flowing, Material material, int lightLevel) {
        return this.register(name, tagName, new FluidBuilder(builder).explosionResistance(100.0f), still, flowing, fluid -> new FlowingFluidBlock(fluid, AbstractBlock.Properties.func_200945_a((Material)material).func_200942_a().func_200943_b(100.0f).func_222380_e().func_235838_a_(state -> lightLevel)));
    }

    public <F extends ForgeFlowingFluid> FluidObject<F> register(String name, FluidAttributes.Builder builder, Function<ForgeFlowingFluid.Properties, ? extends F> still, Function<ForgeFlowingFluid.Properties, ? extends F> flowing, Material material, int lightLevel) {
        return this.register(name, name, builder, still, flowing, material, lightLevel);
    }

    public FluidObject<ForgeFlowingFluid> register(String name, String tagName, FluidAttributes.Builder builder, Material material, int lightLevel) {
        return this.register(name, tagName, builder, ForgeFlowingFluid.Source::new, ForgeFlowingFluid.Flowing::new, material, lightLevel);
    }

    public FluidObject<ForgeFlowingFluid> register(String name, FluidAttributes.Builder builder, Material material, int lightLevel) {
        return this.register(name, name, builder, material, lightLevel);
    }
}

