/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.yezon.theabyss.TheabyssModElements;
import net.yezon.theabyss.itemgroup.TheAbyssEntityItemGroup;
import net.yezon.theabyss.particle.EndSwordPTParticle;

@TheabyssModElements.ModElement.Tag
public class AbyssElderEntity
extends TheabyssModElements.ModElement {
    public static EntityType entity = null;

    public AbyssElderEntity(TheabyssModElements instance) {
        super(instance, 181);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModelRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220320_c().func_220321_a(0.8f, 2.5f).func_206830_a("abyss_elder").setRegistryName("abyss_elder");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -16777216, -16711732, new Item.Properties().func_200916_a(TheAbyssEntityItemGroup.tab)).setRegistryName("abyss_elder_spawn_egg"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        boolean biomeCriteria = false;
        if (new ResourceLocation("theabyss:theabyssbiome").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("theabyss:aybssmountain").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(entity, 2, 1, 2));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(this::setupAttributes);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
    }

    private void setupAttributes() {
        AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
        ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.42);
        ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 80.0);
        ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 2.0);
        ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 14.0);
        ammma = ammma.func_233815_a_(Attributes.field_233820_c_, 2.0);
        GlobalEntityTypeAttributes.put((EntityType)entity, (AttributeModifierMap)ammma.func_233813_a_());
    }

    public static class Modelabyss_elder
    extends EntityModel<Entity> {
        private final ModelRenderer head;
        private final ModelRenderer head_r1;
        private final ModelRenderer head_r2;
        private final ModelRenderer head_r3;
        private final ModelRenderer body;
        private final ModelRenderer left_arm;
        private final ModelRenderer right_arm_r1;
        private final ModelRenderer cube_r1;
        private final ModelRenderer cube_r2;
        private final ModelRenderer cube_r3;
        private final ModelRenderer left_arm_r1;
        private final ModelRenderer right_arm;
        private final ModelRenderer cube_r4;
        private final ModelRenderer cube_r5;
        private final ModelRenderer right_arm_r2;
        private final ModelRenderer cube_r6;
        private final ModelRenderer right_arm_r3;
        private final ModelRenderer left_leg;
        private final ModelRenderer right_leg;

        public Modelabyss_elder() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.head = new ModelRenderer((Model)this);
            this.head.func_78793_a(0.0f, 0.0f, 0.0f);
            this.head.func_78784_a(0, 0).func_228303_a_(-4.0f, -12.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.0f, false);
            this.head_r1 = new ModelRenderer((Model)this);
            this.head_r1.func_78793_a(-3.5f, 13.25f, -6.0f);
            this.head.func_78792_a(this.head_r1);
            this.setRotationAngle(this.head_r1, -0.2618f, 0.0f, 0.0f);
            this.head_r1.func_78784_a(39, 17).func_228303_a_(3.0f, -26.0f, -4.0f, 1.0f, 2.0f, 2.0f, 0.0f, false);
            this.head_r2 = new ModelRenderer((Model)this);
            this.head_r2.func_78793_a(-3.25f, 13.25f, -3.5f);
            this.head.func_78792_a(this.head_r2);
            this.setRotationAngle(this.head_r2, -0.2618f, 0.0f, 0.0f);
            this.head_r2.func_78784_a(40, 6).func_228303_a_(3.0f, -26.0f, -4.0f, 1.0f, 2.0f, 2.0f, 0.0f, false);
            this.head_r3 = new ModelRenderer((Model)this);
            this.head_r3.func_78793_a(-3.5f, 13.25f, -1.0f);
            this.head.func_78792_a(this.head_r3);
            this.setRotationAngle(this.head_r3, -0.2618f, 0.0f, 0.0f);
            this.head_r3.func_78784_a(16, 41).func_228303_a_(3.0f, -26.0f, -4.0f, 1.0f, 2.0f, 2.0f, 0.0f, false);
            this.body = new ModelRenderer((Model)this);
            this.body.func_78793_a(0.0f, 0.0f, 0.0f);
            this.body.func_78784_a(24, 25).func_228303_a_(-4.0f, -4.0f, -2.0f, 8.0f, 12.0f, 4.0f, 0.0f, false);
            this.body.func_78784_a(0, 16).func_228303_a_(-4.5f, -1.75f, -2.5f, 9.0f, 8.0f, 5.0f, 0.0f, false);
            this.body.func_78784_a(40, 0).func_228303_a_(4.0f, -4.0f, -1.5f, 2.0f, 3.0f, 3.0f, 0.0f, false);
            this.body.func_78784_a(32, 18).func_228303_a_(-6.0f, -4.0f, -1.5f, 2.0f, 3.0f, 3.0f, 0.0f, false);
            this.left_arm = new ModelRenderer((Model)this);
            this.left_arm.func_78793_a(-5.0f, 2.0f, 0.0f);
            this.right_arm_r1 = new ModelRenderer((Model)this);
            this.right_arm_r1.func_78793_a(16.0f, 23.25f, -2.75f);
            this.left_arm.func_78792_a(this.right_arm_r1);
            this.setRotationAngle(this.right_arm_r1, -0.1309f, 0.0f, 0.0f);
            this.right_arm_r1.func_78784_a(0, 0).func_228303_a_(-6.0f, -18.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, false);
            this.cube_r1 = new ModelRenderer((Model)this);
            this.cube_r1.func_78793_a(12.5f, 2.0f, -2.0f);
            this.left_arm.func_78792_a(this.cube_r1);
            this.setRotationAngle(this.cube_r1, -0.0436f, 0.0f, 0.0f);
            this.cube_r1.func_78784_a(32, 12).func_228303_a_(-3.0f, -1.0f, 0.0f, 3.0f, 1.0f, 3.0f, 0.0f, false);
            this.cube_r2 = new ModelRenderer((Model)this);
            this.cube_r2.func_78793_a(12.5f, 3.5f, -2.0f);
            this.left_arm.func_78792_a(this.cube_r2);
            this.setRotationAngle(this.cube_r2, -0.0436f, 0.0f, 0.0f);
            this.cube_r2.func_78784_a(32, 12).func_228303_a_(-3.0f, -1.0f, 0.0f, 3.0f, 1.0f, 3.0f, 0.0f, false);
            this.cube_r3 = new ModelRenderer((Model)this);
            this.cube_r3.func_78793_a(12.5f, 6.5f, -2.0f);
            this.left_arm.func_78792_a(this.cube_r3);
            this.setRotationAngle(this.cube_r3, -0.0436f, 0.0f, 0.0f);
            this.cube_r3.func_78784_a(32, 12).func_228303_a_(-3.0f, -2.0f, 0.0f, 3.0f, 2.0f, 3.0f, 0.0f, false);
            this.left_arm_r1 = new ModelRenderer((Model)this);
            this.left_arm_r1.func_78793_a(6.0f, 17.5f, -1.0f);
            this.left_arm.func_78792_a(this.left_arm_r1);
            this.setRotationAngle(this.left_arm_r1, -0.0436f, 0.0f, 0.0f);
            this.left_arm_r1.func_78784_a(32, 0).func_228303_a_(4.0f, -22.0f, -1.0f, 2.0f, 10.0f, 2.0f, 0.0f, false);
            this.right_arm = new ModelRenderer((Model)this);
            this.right_arm.func_78793_a(5.0f, 2.0f, 0.0f);
            this.cube_r4 = new ModelRenderer((Model)this);
            this.cube_r4.func_78793_a(-9.5f, 2.0f, -2.0f);
            this.right_arm.func_78792_a(this.cube_r4);
            this.setRotationAngle(this.cube_r4, -0.0436f, 0.0f, 0.0f);
            this.cube_r4.func_78784_a(32, 12).func_228303_a_(-3.0f, -1.0f, 0.0f, 3.0f, 1.0f, 3.0f, 0.0f, false);
            this.cube_r5 = new ModelRenderer((Model)this);
            this.cube_r5.func_78793_a(-9.5f, 3.5f, -2.0f);
            this.right_arm.func_78792_a(this.cube_r5);
            this.setRotationAngle(this.cube_r5, -0.0436f, 0.0f, 0.0f);
            this.cube_r5.func_78784_a(32, 12).func_228303_a_(-3.0f, -1.0f, 0.0f, 3.0f, 1.0f, 3.0f, 0.0f, false);
            this.right_arm_r2 = new ModelRenderer((Model)this);
            this.right_arm_r2.func_78793_a(-6.0f, 23.25f, -2.75f);
            this.right_arm.func_78792_a(this.right_arm_r2);
            this.setRotationAngle(this.right_arm_r2, -0.1309f, 0.0f, 0.0f);
            this.right_arm_r2.func_78784_a(24, 0).func_228303_a_(-6.0f, -18.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, false);
            this.cube_r6 = new ModelRenderer((Model)this);
            this.cube_r6.func_78793_a(-9.5f, 6.5f, -2.0f);
            this.right_arm.func_78792_a(this.cube_r6);
            this.setRotationAngle(this.cube_r6, -0.0436f, 0.0f, 0.0f);
            this.cube_r6.func_78784_a(23, 16).func_228303_a_(-3.0f, -2.0f, 0.0f, 3.0f, 2.0f, 3.0f, 0.0f, false);
            this.right_arm_r3 = new ModelRenderer((Model)this);
            this.right_arm_r3.func_78793_a(-6.0f, 17.5f, -1.0f);
            this.right_arm.func_78792_a(this.right_arm_r3);
            this.setRotationAngle(this.right_arm_r3, -0.0436f, 0.0f, 0.0f);
            this.right_arm_r3.func_78784_a(16, 29).func_228303_a_(-6.0f, -22.0f, -1.0f, 2.0f, 10.0f, 2.0f, 0.0f, false);
            this.left_leg = new ModelRenderer((Model)this);
            this.left_leg.func_78793_a(-2.0f, 12.0f, 0.1f);
            this.left_leg.func_78784_a(8, 29).func_228303_a_(3.0f, -4.0f, -1.1f, 2.0f, 16.0f, 2.0f, 0.0f, false);
            this.left_leg.func_78784_a(32, 12).func_228303_a_(2.5f, -2.5f, -1.6f, 3.0f, 1.0f, 3.0f, 0.0f, false);
            this.right_leg = new ModelRenderer((Model)this);
            this.right_leg.func_78793_a(2.0f, 12.0f, 0.1f);
            this.right_leg.func_78784_a(0, 29).func_228303_a_(-5.0f, -4.0f, -1.1f, 2.0f, 16.0f, 2.0f, 0.0f, false);
            this.right_leg.func_78784_a(32, 12).func_228303_a_(-5.5f, -2.5f, -1.6f, 3.0f, 1.0f, 3.0f, 0.0f, false);
        }

        public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.head.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.body.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.left_arm.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.right_arm.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.left_leg.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.right_leg.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_225597_a_(Entity e, float f, float f1, float f2, float f3, float f4) {
            this.right_arm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1;
            this.left_leg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.head.field_78796_g = f3 / 57.295776f;
            this.head.field_78795_f = f4 / 57.295776f;
            this.left_arm.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.right_leg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GlowingLayer<T extends Entity, M extends EntityModel<T>>
    extends LayerRenderer<T, M> {
        public GlowingLayer(IEntityRenderer<T, M> er) {
            super(er);
        }

        public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("theabyss:textures/elder_glow.png")));
            this.func_215332_c().func_225598_a_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static class CustomEntity
    extends MonsterEntity {
        private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);

        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 30;
            this.func_94061_f(false);
            this.func_200203_b((ITextComponent)new StringTextComponent("Elder LvL.X"));
            this.func_174805_g(true);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, false));
            this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.8));
            this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false, false));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source.func_76364_f() instanceof PotionEntity) {
                return false;
            }
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (source == DamageSource.field_180137_b) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        public boolean func_184222_aU() {
            return false;
        }

        public void func_184178_b(ServerPlayerEntity player) {
            super.func_184178_b(player);
            this.bossInfo.func_186760_a(player);
        }

        public void func_184203_c(ServerPlayerEntity player) {
            super.func_184203_c(player);
            this.bossInfo.func_186761_b(player);
        }

        public void func_70619_bc() {
            super.func_70619_bc();
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }

        public void func_70636_d() {
            super.func_70636_d();
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            Random random = this.field_70146_Z;
            CustomEntity entity = this;
            for (int l = 0; l < 1; ++l) {
                double d0 = x + (double)random.nextFloat();
                double d1 = y + (double)random.nextFloat();
                double d2 = z + (double)random.nextFloat();
                int i1 = random.nextInt(2) * 2 - 1;
                double d3 = ((double)random.nextFloat() - 0.5) * 0.1;
                double d4 = ((double)random.nextFloat() - 0.5) * 0.1;
                double d5 = ((double)random.nextFloat() - 0.5) * 0.1;
                this.field_70170_p.func_195594_a((IParticleData)EndSwordPTParticle.particle, d0, d1, d2, d3, d4, d5);
            }
        }
    }

    private static class ModelRegisterHandler {
        private ModelRegisterHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerModels(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, new Modelabyss_elder(), 0.5f){
                {
                    super(x0, x1, x2);
                    this.func_177094_a(new GlowingLayer(this));
                }

                public ResourceLocation func_110775_a(Entity entity) {
                    return new ResourceLocation("theabyss:textures/elder_glow.png");
                }
            });
        }
    }
}

