/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.config.JsonConfig;
import xiroc.dungeoncrawl.dungeon.Dungeon;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelFeature;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.module.Modules;
import xiroc.dungeoncrawl.theme.WeightedThemeRandomizer;
import xiroc.dungeoncrawl.util.DataReloadListener;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;
import xiroc.dungeoncrawl.util.Tools;
import xiroc.dungeoncrawl.util.WeightedIntegerEntry;

@Mod(value="dungeoncrawl")
public class DungeonCrawl {
    public static final String MODID = "dungeoncrawl";
    public static final String NAME = "Dungeon Crawl";
    public static final String VERSION = "2.2.4";
    public static final Logger LOGGER = LogManager.getLogger((String)"Dungeon Crawl");
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(DungeonModel.Metadata.class, (Object)new DungeonModel.Metadata.Deserializer()).registerTypeAdapter(WeightedThemeRandomizer.class, (Object)new WeightedThemeRandomizer.Deserializer()).registerTypeAdapter(WeightedIntegerEntry.class, (Object)new WeightedIntegerEntry.Deserializer()).setPrettyPrinting().create();
    public static IEventBus EVENT_BUS;

    public DungeonCrawl() {
        LOGGER.info("Here we go! Launching Dungeon Crawl {}...", (Object)VERSION);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Dungeon.DUNGEON.setRegistryName(new ResourceLocation("dungeoncrawl:dungeon".toLowerCase(Locale.ROOT)));
        ForgeRegistries.STRUCTURE_FEATURES.register(Dungeon.DUNGEON);
        Structure.field_236365_a_.put((Object)Dungeon.DUNGEON.getRegistryName().toString().toLowerCase(Locale.ROOT), Dungeon.DUNGEON);
        LOGGER.info(Dungeon.FEATURE);
        LOGGER.info((Object)WorldGenRegistries.field_243654_f.func_177774_c(Dungeon.FEATURE));
        Treasure.init();
        DungeonModelFeature.init();
        DungeonModelBlockType.buildNameTable();
        EVENT_BUS = (IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common Setup");
        Config.load(FMLPaths.CONFIGDIR.get().resolve("dungeon_crawl.toml"));
        StructurePieceTypes.registerAll();
        if (((Boolean)Config.ENABLE_TOOLS.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register((Object)new Tools());
        }
        DungeonModelBlock.init();
        IBlockPlacementHandler.init();
        DungeonBlocks.init();
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(Dungeon.DUNGEON, (Object)Dungeon.SEPARATION_SETTINGS).build();
        DimensionSettings.field_242740_q.func_236108_a_().func_236195_a_().put(Dungeon.DUNGEON, Dungeon.SEPARATION_SETTINGS);
        Modules.load();
    }

    @SubscribeEvent
    public void addReloadListener(AddReloadListenerEvent event) {
        LOGGER.info("Adding datapack reload listener");
        event.addListener((IFutureReloadListener)new DataReloadListener());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomeLoad(BiomeLoadingEvent event) {
        if (!JsonConfig.BIOME_OVERWORLD_BLOCKLIST.contains(event.getName().toString()) && Dungeon.ALLOWED_CATEGORIES.contains(event.getCategory())) {
            LOGGER.debug("Generation Biome: {}", (Object)event.getName());
            event.getGeneration().func_242516_a(Dungeon.FEATURE);
        }
    }

    public static String getDate() {
        return new SimpleDateFormat().format(new Date());
    }

    public static ResourceLocation locate(String path) {
        return new ResourceLocation(MODID, path);
    }
}

