/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final String CONFIG_GENERAL = "general";
    public static final String CONFIG_DUNGEON = "dungeon";
    public static final String CONFIG_WORLDGEN = "world_generation";
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec CONFIG;
    public static final ForgeConfigSpec.IntValue SPAWNER_ENTITIES;
    public static final ForgeConfigSpec.DoubleValue DUNGEON_PROBABILITY;
    public static final ForgeConfigSpec.DoubleValue SHIELD_PROBABILITY;
    public static final ForgeConfigSpec.DoubleValue MOB_SPAWN_RATE;
    public static final ForgeConfigSpec.BooleanValue IGNORE_OVERWORLD_BLACKLIST;
    public static final ForgeConfigSpec.BooleanValue IGNORE_DIMENSION;
    public static final ForgeConfigSpec.BooleanValue VANILLA_SPAWNERS;
    public static final ForgeConfigSpec.BooleanValue NO_SPAWNERS;
    public static final ForgeConfigSpec.BooleanValue NO_NETHER_STUFF;
    public static final ForgeConfigSpec.BooleanValue ENABLE_TOOLS;
    public static final ForgeConfigSpec.BooleanValue ENABLE_DUMMY_PIECES;
    public static final ForgeConfigSpec.BooleanValue SOLID;
    public static final ForgeConfigSpec.BooleanValue NATURAL_DESPAWN;
    public static final ForgeConfigSpec.BooleanValue EXTENDED_DEBUG;

    public static void load(Path path) {
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        config.load();
        CONFIG.setConfig((CommentedConfig)config);
    }

    static {
        BUILDER.comment("General Settings").push(CONFIG_GENERAL);
        ENABLE_TOOLS = BUILDER.comment("Enables the dungeon crawl tools.").define("enable_tools", false);
        ENABLE_DUMMY_PIECES = BUILDER.comment("This option will make pre-2.0.0 worlds playable with version 2.0.0 and later.").define("enable_dummy_pieces", false);
        EXTENDED_DEBUG = BUILDER.comment("Enables extended debug logging to help detecting potential errors. This is enabled by default.").define("extended_debug", true);
        BUILDER.pop();
        BUILDER.comment("Dungeon Settings").push(CONFIG_DUNGEON);
        NO_SPAWNERS = BUILDER.comment("If you dont like the fact that the dungeons contain lots of mob spawners, set this to true! Mobs will get spawned manually during the dungeon generation then. Note that this is a lot more performance demanding than enabling spawners. (Which also depends on the mob spawn rate)").define("no_spawners", false);
        NO_NETHER_STUFF = BUILDER.comment("Set this to true if you want to prevent that the last layer of each dungeon will contain nether content.").define("no_nether_stuff", false);
        MOB_SPAWN_RATE = BUILDER.comment("This value defines how many mobs do get spawned manually during the generation. (if no_spawners = true, there is no effect otherwise)").defineInRange("mob_spawn_rate", 0.05, 0.001, 1.0);
        SPAWNER_ENTITIES = BUILDER.comment("The number of different entities per spawner. Increasing the number increases the diversity of the monster equipment.").defineInRange("spawner_entities", 6, 1, 128);
        IGNORE_OVERWORLD_BLACKLIST = BUILDER.comment("If set to true, the dungeon generation will ignore the biome blacklist and generate dungeons in any overworld biome.").define("ignore_overworld_blacklist", false);
        SHIELD_PROBABILITY = BUILDER.comment("The Probability of a spawner entity having a shield in the offhand.").defineInRange("shield_probability", 0.25, 0.01, 1.0);
        VANILLA_SPAWNERS = BUILDER.comment("Determines if vanilla spawners or modified spawners with armor, weapons etc... should be used.").define("use_vanilla_spawners", false);
        NATURAL_DESPAWN = BUILDER.comment("Whether mobs from spawners should despawn naturally or not.").define("natural_despawn", true);
        BUILDER.pop();
        BUILDER.comment("World Generation Settings").push(CONFIG_WORLDGEN);
        DUNGEON_PROBABILITY = BUILDER.comment("The probability of a dungeon getting generated on each fitting chunk.").defineInRange("dungeon_probability", 0.22, 1.0E-4, 1.0);
        IGNORE_DIMENSION = BUILDER.comment("If this is set to false, no dungeons can be generated outside the overworld.").define("ignore_dimension", false);
        SOLID = BUILDER.comment("Makes the entire dungeon solid, preventing caves, ravines, etc... from interfering with the dungeon.").define("solid", false);
        BUILDER.pop();
        BUILDER.comment("There are a lot more other config options in config/DungeonCrawl.").push("Information");
        CONFIG = BUILDER.build();
    }
}

