/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.config;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.SpecialItemTags;
import xiroc.dungeoncrawl.dungeon.monster.ArmorSet;
import xiroc.dungeoncrawl.util.IJsonConfigurable;

public class JsonConfig
implements IJsonConfigurable {
    public static final String KEY_CONFIG_VERSION = "config_version";
    public static final String KEY_BIOME_BLOCKLIST = "biome_blocklist";
    public static final String KEY_BIOME_OVERWORLD_BLOCKLIST = "biome_overworld_blocklist";
    public static final String KEY_BOSSES = "dungeon_bosses";
    public static final String[] KEYS = new String[]{"dungeon_bosses", "biome_blocklist", "biome_overworld_blocklist"};
    public static List<?> BIOME_BLOCKLIST;
    public static List<?> BIOME_OVERWORLD_BLOCKLIST;
    public static Set<?> COLORED_ARMOR;
    public static ResourceLocation[] BOWS;
    public static ResourceLocation[] SWORDS;
    public static ResourceLocation[] SWORDS_RARE;
    public static ResourceLocation[] PICKAXES;
    public static ResourceLocation[] AXES;
    public static ResourceLocation[] BOW_ENCHANTMENTS;
    public static ResourceLocation[] SWORD_ENCHANTMENTS;
    public static ResourceLocation[] PICKAXE_ENCHANTMENTS;
    public static ResourceLocation[] AXE_ENCHANTMENTS;
    public static ResourceLocation[] ARMOR_ENCHANTMENTS;
    public static ArmorSet[] ARMOR_SETS_1;
    public static ArmorSet[] ARMOR_SETS_2;
    public static ArmorSet[] ARMOR_SETS_3;
    public static ArmorSet[] ARMOR_SETS_RARE;

    public static void load(IJsonConfigurable configurable) {
        File file = configurable.getFile();
        DungeonCrawl.LOGGER.info("Loading {}", (Object)file.getAbsolutePath());
        if (!file.exists()) {
            DungeonCrawl.LOGGER.info("Creating {}", (Object)file.getAbsolutePath());
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            JsonObject object = configurable.create(new JsonObject());
            object.add(KEY_CONFIG_VERSION, DungeonCrawl.GSON.toJsonTree((Object)configurable.getVersion()));
            try {
                FileWriter writer = new FileWriter(file);
                DungeonCrawl.GSON.toJson((JsonElement)object, (Appendable)writer);
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                DungeonCrawl.LOGGER.error("Failed to create {}", (Object)file.getAbsolutePath());
                e.printStackTrace();
            }
        }
        Gson gson = DungeonCrawl.GSON;
        try {
            JsonObject object = (JsonObject)gson.fromJson((Reader)new FileReader(file), JsonObject.class);
            if (object.get(KEY_CONFIG_VERSION).getAsInt() < configurable.getVersion()) {
                if (!configurable.deleteOldVersions()) {
                    DungeonCrawl.LOGGER.info("Creating a backup of {} because it is outdated and will be replaced", (Object)file.getAbsolutePath());
                    File backupFile = FMLPaths.CONFIGDIR.get().resolve("DungeonCrawl/Config Backups/" + System.currentTimeMillis() + "_" + file.getName()).toFile();
                    if (!backupFile.getParentFile().exists()) {
                        backupFile.getParentFile().mkdirs();
                    }
                    Files.write((byte[])Files.toByteArray((File)file), (File)backupFile);
                }
                DungeonCrawl.LOGGER.info("Replacing {}", (Object)file.getAbsoluteFile());
                JsonObject newObject = configurable.create(new JsonObject());
                newObject.add(KEY_CONFIG_VERSION, DungeonCrawl.GSON.toJsonTree((Object)configurable.getVersion()));
                try {
                    FileWriter writer = new FileWriter(file);
                    DungeonCrawl.GSON.toJson((JsonElement)newObject, (Appendable)writer);
                    writer.flush();
                    writer.close();
                }
                catch (Exception e) {
                    DungeonCrawl.LOGGER.error("Failed to create {}", (Object)file.getAbsolutePath());
                    e.printStackTrace();
                }
            }
            configurable.load(object, file);
        }
        catch (Exception e) {
            DungeonCrawl.LOGGER.error("Failed to load {}", (Object)file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    @Override
    public int getVersion() {
        return 0;
    }

    public static JsonElement getOrRewrite(JsonObject object, String name, IJsonConfigurable configurable) {
        return JsonConfig.getOrRewrite(object, name, configurable, false);
    }

    public static JsonElement getOrRewrite(JsonObject object, String name, IJsonConfigurable configurable, boolean rerun) {
        if (object.get(name) != null) {
            return object.get(name);
        }
        File file = configurable.getFile();
        if (rerun) {
            DungeonCrawl.LOGGER.error("Cant find \"{}\" in {}, even after rewriting the file.", (Object)name, (Object)file.getAbsolutePath());
            return DungeonCrawl.GSON.toJsonTree(configurable.getDefaults().get(name));
        }
        DungeonCrawl.LOGGER.info("Rewriting {} due to missing data.", (Object)file.getAbsolutePath());
        JsonConfigManager.rewrite(configurable);
        try {
            return JsonConfig.getOrRewrite((JsonObject)DungeonCrawl.GSON.fromJson((Reader)new FileReader(configurable.getFile()), JsonObject.class), name, configurable, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return DungeonCrawl.GSON.toJsonTree(configurable.getDefaults().get(name));
        }
    }

    @Override
    public File getFile() {
        return FMLPaths.CONFIGDIR.get().resolve("DungeonCrawl/config.json").toFile();
    }

    @Override
    public void load(JsonObject object, File file) {
        BIOME_BLOCKLIST = (List)DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_BIOME_BLOCKLIST, this), ArrayList.class);
        BIOME_OVERWORLD_BLOCKLIST = (List)DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_BIOME_OVERWORLD_BLOCKLIST, this), ArrayList.class);
    }

    @Override
    public JsonObject create(JsonObject object) {
        object.add(KEY_BIOME_BLOCKLIST, DungeonCrawl.GSON.toJsonTree(JsonConfigManager.BIOME_BLACKLIST));
        object.add(KEY_BIOME_OVERWORLD_BLOCKLIST, DungeonCrawl.GSON.toJsonTree(JsonConfigManager.BIOME_OVERWORLD_BLACKLIST));
        return object;
    }

    public static ResourceLocation[] toResourceLocationArray(String[] resourceNames) {
        ResourceLocation[] resourceLocations = new ResourceLocation[resourceNames.length];
        for (int i = 0; i < resourceNames.length; ++i) {
            String[] resource = resourceNames[i].split(":");
            resourceLocations[i] = new ResourceLocation(resource[0], resource[1]);
        }
        return resourceLocations;
    }

    @Override
    public HashMap<String, Object> getDefaults() {
        return JsonConfigManager.DEFAULTS;
    }

    @Override
    public String[] getKeys() {
        return KEYS;
    }

    static {
        COLORED_ARMOR = ImmutableSet.builder().add((Object)"minecraft:leather_boots").add((Object)"minecraft:leather_pants").add((Object)"minecraft:leather_chestplate").add((Object)"minecraft:leather_helmet").build();
        JsonConfig.load(new JsonConfig());
        JsonConfig.load(new SpecialItemTags());
    }

    public static class JsonConfigManager {
        public static final List<?> BIOME_BLACKLIST = Lists.newArrayList((Object[])new String[]{"minecraft:the_end", "minecraft:nether", "minecraft:small_end_islands", "minecraft:end_midlands", "minecraft:end_highlands", "minecraft:end_barrens", "minecraft:the_void", "biomesoplenty:ashen_inferno", "biomesopenty:undergarden", "biomesoplenty:boneyard", "biomesoplenty:visceral_heap"});
        public static final List<?> BIOME_OVERWORLD_BLACKLIST = Lists.newArrayList((Object[])new String[]{"minecraft:ocean", "minecraft:deep_ocean", "minecraft:lukewarm_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:warm_ocean", "minecraft:deep_warm_ocean", "minecraft:cold_ocean", "minecraft:deep_cold_ocean", "minecraft:frozen_ocean", "minecraft:deep_frozen_ocean"});
        public static final HashMap<String, Object> DEFAULTS = new HashMap();

        public static void rewrite(IJsonConfigurable configurable) {
            File file = configurable.getFile();
            try {
                JsonObject object = file.exists() ? (JsonObject)DungeonCrawl.GSON.fromJson((Reader)new FileReader(file), JsonObject.class) : new JsonObject();
                for (String key : configurable.getKeys()) {
                    if (object.has(key)) continue;
                    object.add(key, DungeonCrawl.GSON.toJsonTree(configurable.getDefaults().get(key)));
                }
                FileWriter writer = new FileWriter(file);
                DungeonCrawl.GSON.toJson((JsonElement)object, (Appendable)writer);
                writer.flush();
                writer.close();
            }
            catch (Exception e1) {
                DungeonCrawl.LOGGER.error("An error occurred whilst trying to rewrite {}", (Object)file.getAbsolutePath());
                e1.printStackTrace();
            }
        }

        static {
            DEFAULTS.put(JsonConfig.KEY_BIOME_BLOCKLIST, BIOME_BLACKLIST);
            DEFAULTS.put(JsonConfig.KEY_BIOME_OVERWORLD_BLOCKLIST, BIOME_OVERWORLD_BLACKLIST);
        }
    }
}

