/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import net.minecraft.util.Rotation;
import net.minecraft.util.math.vector.Vector3i;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;

public class ChildPieceHandler {
    public static ChildPieceHandler LARGE_CORRIDOR_START;
    public static ChildPieceHandler LARGE_CORRIDOR_STRAIGHT;
    public static ChildPieceHandler LARGE_CORRIDOR_TURN;
    public static ChildPieceHandler LARGE_CORRIDOR_OPEN;
    public int modelID;
    public ChildPieceSpot[] none;
    public ChildPieceSpot[] clockwise_90;
    public ChildPieceSpot[] clockwise_180;
    public ChildPieceSpot[] counterclockwise_90;

    public ChildPieceHandler(int modelID, ChildPieceSpot[] base) {
        this.modelID = modelID;
        this.none = base;
        this.clockwise_90 = ChildPieceHandler.rotate(base, modelID, Rotation.CLOCKWISE_90);
        this.clockwise_180 = ChildPieceHandler.rotate(base, modelID, Rotation.CLOCKWISE_180);
        this.counterclockwise_90 = ChildPieceHandler.rotate(base, modelID, Rotation.COUNTERCLOCKWISE_90);
    }

    public ChildPieceSpot[] getChildPieceSpots(Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return this.none;
            }
            case CLOCKWISE_90: {
                return this.clockwise_90;
            }
            case CLOCKWISE_180: {
                return this.clockwise_180;
            }
            case COUNTERCLOCKWISE_90: {
                return this.counterclockwise_90;
            }
        }
        return null;
    }

    public static void load() {
        LARGE_CORRIDOR_START = new ChildPieceHandler(DungeonModels.LARGE_CORRIDOR_START.id, new ChildPieceSpot[]{new ChildPieceSpot(1, 1, 0, Rotation.COUNTERCLOCKWISE_90), new ChildPieceSpot(5, 1, 0, Rotation.COUNTERCLOCKWISE_90), new ChildPieceSpot(1, 1, 8, Rotation.CLOCKWISE_90), new ChildPieceSpot(5, 1, 8, Rotation.CLOCKWISE_90)});
        LARGE_CORRIDOR_STRAIGHT = new ChildPieceHandler(DungeonModels.LARGE_CORRIDOR_STRAIGHT.id, new ChildPieceSpot[]{new ChildPieceSpot(0, 1, 0, Rotation.COUNTERCLOCKWISE_90), new ChildPieceSpot(6, 1, 0, Rotation.COUNTERCLOCKWISE_90), new ChildPieceSpot(0, 1, 8, Rotation.CLOCKWISE_90), new ChildPieceSpot(6, 1, 8, Rotation.CLOCKWISE_90)});
        LARGE_CORRIDOR_TURN = new ChildPieceHandler(DungeonModels.LARGE_CORRIDOR_TURN.id, new ChildPieceSpot[]{new ChildPieceSpot(0, 1, 0, Rotation.COUNTERCLOCKWISE_90), new ChildPieceSpot(8, 1, 6, Rotation.NONE)});
        LARGE_CORRIDOR_OPEN = new ChildPieceHandler(DungeonModels.LARGE_CORRIDOR_OPEN.id, new ChildPieceSpot[]{new ChildPieceSpot(0, 1, 0, Rotation.COUNTERCLOCKWISE_90), new ChildPieceSpot(6, 1, 0, Rotation.COUNTERCLOCKWISE_90)});
    }

    public static ChildPieceSpot[] rotate(ChildPieceSpot[] array, int modelID, Rotation rotation) {
        DungeonModel model = DungeonModels.MODELS.get(modelID);
        for (int i = 0; i < array.length; ++i) {
            ChildPieceSpot spot = array[i];
            if (spot == null) continue;
            spot.rotation = rotation;
            spot.offset = ChildPieceHandler.rotateOffset(spot.offset, rotation, model);
        }
        return array;
    }

    public static Vector3i rotateOffset(Vector3i offset, Rotation rotation, DungeonModel model) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return new Vector3i(offset.func_177952_p(), offset.func_177956_o(), offset.func_177958_n());
            }
            case CLOCKWISE_180: {
                return new Vector3i(model.width - offset.func_177958_n() - 1, offset.func_177956_o(), model.length - offset.func_177952_p() - 1);
            }
            case COUNTERCLOCKWISE_90: {
                return new Vector3i(model.width - offset.func_177952_p() - 1, offset.func_177956_o(), model.length - offset.func_177958_n() - 1);
            }
        }
        return offset;
    }

    public static class ChildPieceSpot {
        public Vector3i offset;
        public Rotation rotation;

        public ChildPieceSpot(int xOffset, int yOffset, int zOffset, Rotation rotation) {
            this.offset = new Vector3i(xOffset, yOffset, zOffset);
            this.rotation = rotation;
        }
    }
}

