/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.ImmutableSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.DimensionType;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.eventbus.api.Event;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.api.event.DungeonPlacementCheckEvent;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;

public class Dungeon
extends Structure<NoFeatureConfig> {
    public static final Set<Biome.Category> ALLOWED_CATEGORIES = ImmutableSet.builder().add((Object)Biome.Category.BEACH).add((Object)Biome.Category.DESERT).add((Object)Biome.Category.EXTREME_HILLS).add((Object)Biome.Category.FOREST).add((Object)Biome.Category.ICY).add((Object)Biome.Category.JUNGLE).add((Object)Biome.Category.MESA).add((Object)Biome.Category.PLAINS).add((Object)Biome.Category.RIVER).add((Object)Biome.Category.SAVANNA).add((Object)Biome.Category.SWAMP).add((Object)Biome.Category.TAIGA).add((Object)Biome.Category.RIVER).build();
    public static final String NAME = "dungeoncrawl:dungeon";
    public static final Structure<NoFeatureConfig> DUNGEON = new Dungeon();
    public static final StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> FEATURE = (StructureFeature)WorldGenRegistries.func_243663_a((Registry)WorldGenRegistries.field_243654_f, (String)"dungeoncrawl:dungeon", (Object)DUNGEON.func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
    public static final StructureSeparationSettings SEPARATION_SETTINGS = new StructureSeparationSettings(30, 10, 10387313);
    public static final int SIZE = 15;

    public Dungeon() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.UNDERGROUND_DECORATION;
    }

    protected boolean func_230365_b_() {
        return false;
    }

    protected boolean func_230363_a_(ChunkGenerator p_230363_1_, BiomeProvider p_230363_2_, long p_230363_3_, SharedSeedRandom p_230363_5_, int p_230363_6_, int p_230363_7_, Biome p_230363_8_, ChunkPos p_230363_9_, NoFeatureConfig p_230363_10_) {
        for (Biome biome : p_230363_2_.func_225530_a_(p_230363_6_ * 16, p_230363_1_.func_230356_f_(), p_230363_7_ * 16, 64)) {
            if (biome.func_242440_e().func_242493_a((Structure)this) || ((Boolean)Config.IGNORE_OVERWORLD_BLACKLIST.get()).booleanValue()) continue;
            return false;
        }
        if (DungeonCrawl.EVENT_BUS.post((Event)new DungeonPlacementCheckEvent(p_230363_1_, p_230363_8_, p_230363_6_, p_230363_7_))) {
            return false;
        }
        return p_230363_5_.nextDouble() < (Double)Config.DUNGEON_PROBABILITY.get();
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return NAME;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> p_i51341_1_, int chunkX, int chunkZ, MutableBoundingBox boundsIn, int referenceIn, long seed) {
            super(p_i51341_1_, chunkX, chunkZ, boundsIn, referenceIn, seed);
        }

        public void func_230364_a_(DynamicRegistries dynamicRegistries, ChunkGenerator chunkGenerator, TemplateManager p_230364_3_, int chunkX, int chunkZ, Biome p_230364_6_, NoFeatureConfig p_230364_7_) {
            if (DungeonBuilder.isWorldEligible(chunkGenerator)) {
                ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
                DungeonBuilder builder = new DungeonBuilder(dynamicRegistries, chunkGenerator, chunkpos, (Random)this.field_214631_d);
                this.field_75075_a.addAll(builder.build());
                this.func_202500_a();
                DungeonCrawl.LOGGER.debug("Created the dungeon layout for [{}, {}] with a total of {} pieces.", (Object)chunkX, (Object)chunkZ, (Object)this.field_75075_a.size());
            } else {
                DungeonCrawl.LOGGER.warn("The current world seems to have biomes of overworld-like categories, but is not eligible for dungeon generation.");
            }
        }

        public void func_230366_a_(ISeedReader p_230366_1_, StructureManager p_230366_2_, ChunkGenerator p_230366_3_, Random p_230366_4_, MutableBoundingBox p_230366_5_, ChunkPos p_230366_6_) {
            if (!((Boolean)Config.IGNORE_DIMENSION.get()).booleanValue() && p_230366_1_.func_230315_m_() != p_230366_1_.func_241828_r().func_243612_b(Registry.field_239698_ad_).func_230516_a_(DimensionType.field_235999_c_)) {
                DungeonCrawl.LOGGER.info("Cancelling the generation of an existing Dungeon because it is not in the overworld. To avoid this, set \"ignore_dimension\" in the config to true. Dimension: {}", (Object)p_230366_1_.func_230315_m_());
                return;
            }
            if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
                DungeonCrawl.LOGGER.debug("Starting dungeon generation in chunk [{},{}]", (Object)p_230366_6_.field_77276_a, (Object)p_230366_6_.field_77275_b);
            }
            super.func_230366_a_(p_230366_1_, p_230366_2_, p_230366_3_, p_230366_4_, p_230366_5_, p_230366_6_);
            if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
                DungeonCrawl.LOGGER.debug("Finished dungeon generation in chunk [{},{}]", (Object)p_230366_6_.field_77276_a, (Object)p_230366_6_.field_77275_b);
            }
        }
    }
}

