/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.Event;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.api.event.DungeonBuilderStartEvent;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonFeatures;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.DungeonLayerMap;
import xiroc.dungeoncrawl.dungeon.DungeonStatTracker;
import xiroc.dungeoncrawl.dungeon.generator.DefaultGenerator;
import xiroc.dungeoncrawl.dungeon.generator.DungeonGenerator;
import xiroc.dungeoncrawl.dungeon.generator.DungeonGeneratorSettings;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.piece.DungeonEntrance;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.dungeon.piece.PlaceHolder;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.Position2D;

public class DungeonBuilder {
    public static final DungeonGenerator DEFAULT_GENERATOR = new DefaultGenerator(DungeonGeneratorSettings.DEFAULT);
    public Random rand;
    public Position2D start;
    public DungeonLayer[] layers;
    public DungeonLayerMap[] maps;
    public DungeonStatTracker statTracker;
    public BlockPos startPos;
    public ChunkGenerator chunkGenerator;
    public Biome startBiome;
    public int theme;
    public int subTheme;
    public int lowerTheme;
    public int lowerSubTheme;
    public int bottomTheme;
    public int bottomSubTheme;
    private final DynamicRegistries dynamicRegistries;

    public DungeonBuilder(DynamicRegistries dynamicRegistries, ChunkGenerator chunkGenerator, ChunkPos pos, Random rand) {
        this.dynamicRegistries = dynamicRegistries;
        this.chunkGenerator = chunkGenerator;
        this.rand = rand;
        this.startPos = new BlockPos(pos.field_77276_a * 16 - 63, chunkGenerator.func_230356_f_() - 16, pos.field_77275_b * 16 - 63);
        int layerCount = DEFAULT_GENERATOR.calculateLayerCount(rand, this.startPos.func_177956_o());
        this.layers = new DungeonLayer[layerCount];
        this.maps = new DungeonLayerMap[layerCount];
        this.statTracker = new DungeonStatTracker(layerCount);
        DEFAULT_GENERATOR.initialize(this, pos, rand);
        DungeonBuilderStartEvent startEvent = new DungeonBuilderStartEvent(chunkGenerator, this.startPos, this.statTracker, this.layers.length);
        DungeonCrawl.EVENT_BUS.post((Event)startEvent);
        DungeonCrawl.LOGGER.debug("Creating the layout for a dungeon at (" + this.startPos.func_177958_n() + " | " + this.startPos.func_177956_o() + " | " + this.startPos.func_177952_p() + ") with " + layerCount + " layers. Theme: {} Sub-Theme: {}", (Object)this.theme, (Object)this.subTheme);
    }

    public DungeonBuilder(ServerWorld world, ChunkPos pos) {
        this.dynamicRegistries = world.func_241828_r();
        this.rand = new Random();
        this.startPos = new BlockPos(pos.field_77276_a * 16 - 63, 84, pos.field_77275_b * 16 - 63);
        int layerCount = DEFAULT_GENERATOR.calculateLayerCount(this.rand, this.startPos.func_177956_o());
        this.chunkGenerator = world.func_72863_F().field_186029_c;
        this.layers = new DungeonLayer[layerCount];
        this.maps = new DungeonLayerMap[layerCount];
        this.statTracker = new DungeonStatTracker(layerCount);
        DEFAULT_GENERATOR.initialize(this, pos, this.rand);
    }

    public static boolean isWorldEligible(ServerWorld world, BlockPos pos) {
        return world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, pos.func_177958_n(), pos.func_177952_p()) > 32;
    }

    public static boolean isWorldEligible(ChunkGenerator chunkGenerator) {
        return chunkGenerator.func_230356_f_() > 32;
    }

    public List<DungeonPiece> build() {
        String biome;
        int i;
        ArrayList pieces = Lists.newArrayList();
        int startCoordinate = DungeonBuilder.DEFAULT_GENERATOR.settings.gridSize.apply(0) / 2;
        this.start = new Position2D(startCoordinate, startCoordinate);
        for (i = 0; i < this.layers.length; ++i) {
            int size = DungeonBuilder.DEFAULT_GENERATOR.settings.gridSize.apply(i);
            this.maps[i] = new DungeonLayerMap(size, size);
            this.layers[i] = new DungeonLayer(size, size);
            this.layers[i].map = this.maps[i];
        }
        for (i = 0; i < this.layers.length; ++i) {
            DEFAULT_GENERATOR.generateLayer(this, this.layers[i], i, this.rand, i == 0 ? this.start : this.layers[i - 1].end);
        }
        for (i = 0; i < this.layers.length; ++i) {
            this.processCorridors(this.layers[i], i);
        }
        DungeonEntrance entrance = new DungeonEntrance();
        entrance.setRealPosition(this.startPos.func_177958_n() + this.layers[0].start.x * 9, this.startPos.func_177956_o() + 9, this.startPos.func_177952_p() + this.layers[0].start.z * 9);
        entrance.stage = 0;
        ((DungeonPiece)entrance).setupModel(this, null, pieces, this.rand);
        ((DungeonPiece)entrance).setupBoundingBox();
        this.startBiome = this.chunkGenerator.func_202090_b().func_225526_b_(entrance.x >> 2, this.chunkGenerator.func_230356_f_() >> 2, entrance.z >> 2);
        ResourceLocation biomeName = this.dynamicRegistries.func_243612_b(Registry.field_239720_u_).func_177774_c((Object)this.startBiome);
        if (biomeName != null) {
            biome = biomeName.toString();
        } else {
            DungeonCrawl.LOGGER.warn("Couldn't find the registry name for biome {} - Proceeding with default \"minecraft:plains\".", (Object)this.startBiome.toString());
            biome = "minecraft:plains";
        }
        this.theme = Theme.getTheme(biome, this.rand);
        this.subTheme = Theme.get((int)this.theme).subTheme != null ? Theme.randomizeSubTheme(Theme.get((int)this.theme).subTheme, this.rand) : Theme.getSubTheme(biome, this.rand);
        this.lowerTheme = Theme.randomizeTheme(80, this.rand);
        this.lowerSubTheme = Theme.get((int)this.lowerTheme).subTheme != null ? Theme.randomizeSubTheme(Theme.get((int)this.lowerTheme).subTheme, this.rand) : this.subTheme;
        this.bottomTheme = (Boolean)Config.NO_NETHER_STUFF.get() != false ? Theme.randomizeTheme(81, this.rand) : Theme.randomizeTheme(1, this.rand);
        this.bottomSubTheme = Theme.get((int)this.bottomTheme).subTheme != null ? Theme.randomizeSubTheme(Theme.get((int)this.bottomTheme).subTheme, this.rand) : this.subTheme;
        entrance.theme = this.theme;
        entrance.subTheme = this.subTheme;
        pieces.add(entrance);
        this.postProcessDungeon(pieces, this.rand);
        return pieces;
    }

    public void processCorridors(DungeonLayer layer, int lyr) {
        int stage = Math.min(lyr, 4);
        for (int x = 0; x < layer.width; ++x) {
            for (int z = 0; z < layer.length; ++z) {
                if (layer.segments[x][z] == null || layer.segments[x][z].hasFlag(PlaceHolder.Flag.PLACEHOLDER)) continue;
                layer.segments[x][z].reference.stage = stage;
                if (layer.segments[x][z].reference.getType() != 0) continue;
                DungeonFeatures.processCorridor(this, layer, x, z, this.rand, lyr, stage, this.startPos);
            }
        }
    }

    public void postProcessDungeon(List<DungeonPiece> pieces, Random rand) {
        boolean catacombs = this.layers.length > 3;
        for (int i = 0; i < this.layers.length; ++i) {
            DungeonLayer layer = this.layers[i];
            DungeonModels.ModelCategory layerCategory = DEFAULT_GENERATOR.getCategoryForLayer(i);
            for (int x = 0; x < layer.width; ++x) {
                for (int z = 0; z < layer.length; ++z) {
                    if (layer.segments[x][z] == null || layer.segments[x][z].hasFlag(PlaceHolder.Flag.PLACEHOLDER)) continue;
                    if (i == this.layers.length - 1) {
                        layer.segments[x][z].reference.theme = this.bottomTheme;
                        layer.segments[x][z].reference.subTheme = this.bottomSubTheme;
                    } else if (catacombs && this.layers.length - i < 4) {
                        layer.segments[x][z].reference.theme = this.lowerTheme;
                        layer.segments[x][z].reference.subTheme = this.lowerSubTheme;
                    } else {
                        layer.segments[x][z].reference.theme = this.theme;
                        layer.segments[x][z].reference.subTheme = this.subTheme;
                    }
                    if (!layer.segments[x][z].hasFlag(PlaceHolder.Flag.FIXED_MODEL)) {
                        layer.segments[x][z].reference.setupModel(this, layerCategory, pieces, rand);
                    }
                    if (!layer.segments[x][z].hasFlag(PlaceHolder.Flag.FIXED_POSITION)) {
                        layer.segments[x][z].reference.setRealPosition(this.startPos.func_177958_n() + x * 9, this.startPos.func_177956_o() - i * 9, this.startPos.func_177952_p() + z * 9);
                    }
                    layer.segments[x][z].reference.setupBoundingBox();
                    if (layer.segments[x][z].reference.hasChildPieces()) {
                        layer.segments[x][z].reference.addChildPieces(pieces, this, layerCategory, i, rand);
                    }
                    if (layer.segments[x][z].reference.getType() == 10) {
                        layer.rotateNode(layer.segments[x][z]);
                    }
                    layer.segments[x][z].reference.customSetup(rand);
                    pieces.add(layer.segments[x][z].reference);
                }
            }
        }
    }
}

