/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.piece.PlaceHolder;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonSideRoom;
import xiroc.dungeoncrawl.util.Position2D;
import xiroc.dungeoncrawl.util.Triple;
import xiroc.dungeoncrawl.util.WeightedRandomInteger;

public class DungeonFeatures {
    public static final HashMap<Integer, Triple<Integer, Integer, Integer>> OFFSET_DATA = new HashMap();
    public static final List<CorridorFeature> CORRIDOR_FEATURES;

    public static void processCorridor(DungeonBuilder builder, DungeonLayer layer, int x, int z, Random rand, int lyr, int stage, BlockPos startPos) {
        for (CorridorFeature corridorFeature : CORRIDOR_FEATURES) {
            if (!corridorFeature.process(builder, layer, x, z, rand, lyr, stage, startPos)) continue;
            return;
        }
    }

    public static boolean canPlacePiece(DungeonLayer layer, int x, int z, int width, int length, boolean ignoreStartPosition) {
        if (x + width > 15 || z + length > 15 || x < 0 || z < 0) {
            return false;
        }
        for (int x0 = 0; x0 < width; ++x0) {
            for (int z0 = 0; z0 < length; ++z0) {
                if (ignoreStartPosition && x0 == 0 && z0 == 0 || layer.segments[x + x0][z + z0] == null && layer.map.isPositionFree(x + x0, z + z0)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean canPlacePieceWithHeight(DungeonBuilder builder, int layer, int x, int z, int width, int length, int layerHeight, boolean ignoreStartPosition) {
        if (x + width > 15 || z + length > 15 || x < 0 || z < 0) {
            return false;
        }
        int layers = builder.layers.length;
        int lh = layer - layerHeight;
        if (layer > layers - 1 || layer < 0 || lh > layers || lh < 0) {
            return false;
        }
        boolean up = layerHeight > 0;
        int c = up ? -1 : 1;
        int k = lh + c;
        int lyr = layer;
        while (up ? lyr > k : lyr < k) {
            if (layers - lyr != 0) {
                if (layers - lyr < 0) {
                    return false;
                }
                for (int x0 = 0; x0 < width; ++x0) {
                    for (int z0 = 0; z0 < length; ++z0) {
                        if (ignoreStartPosition && lyr == layer && x0 == 0 && z0 == 0 || builder.layers[lyr].segments[x + x0][z + z0] == null && builder.maps[lyr].isPositionFree(x + x0, z + z0)) continue;
                        return false;
                    }
                }
            }
            lyr += c;
        }
        return true;
    }

    public static void mark(DungeonLayer layer, int x, int z, int width, int length) {
        for (int x0 = 0; x0 < width; ++x0) {
            for (int z0 = 0; z0 < length; ++z0) {
                layer.map.map[x][z] = true;
            }
        }
    }

    public static void mark(DungeonBuilder builder, int layer, int x, int z, int width, int length, int layerHeight) {
        int layers = builder.layers.length;
        boolean up = layerHeight > 0;
        int c = up ? -1 : 1;
        int k = layer - layerHeight + c;
        int lyr = layer;
        while (up ? lyr > k : lyr < k) {
            if (layers - lyr != 0) {
                for (int x0 = 0; x0 < width; ++x0) {
                    for (int z0 = 0; z0 < length; ++z0) {
                        builder.maps[lyr].markPositionAsOccupied(new Position2D(x + x0, z + z0));
                    }
                }
            }
            lyr += c;
        }
    }

    static {
        OFFSET_DATA.put(34, new Triple<Integer, Integer, Integer>(0, -1, 0));
        CORRIDOR_FEATURES = Lists.newArrayList();
        CORRIDOR_FEATURES.add((builder, layer, x, z, rand, lyr, stage, startPos) -> {
            Tuple<Position2D, Rotation> sideRoomData;
            if (layer.segments[x][z].reference.connectedSides < 4 && (double)rand.nextFloat() < 0.075 && (sideRoomData = layer.findSideRoomData(new Position2D(x, z))) != null) {
                DungeonSideRoom sideRoom = new DungeonSideRoom();
                WeightedRandomInteger randomModel = DungeonModels.ModelCategory.get(DungeonModels.ModelCategory.SIDE_ROOM, DungeonModels.ModelCategory.getCategoryForStage(stage));
                if (randomModel == null || randomModel.integers.length <= 0) {
                    return false;
                }
                sideRoom.modelID = randomModel.roll(rand);
                Direction dir = ((Rotation)sideRoomData.func_76340_b()).func_185831_a(Direction.WEST);
                sideRoom.openSide(dir);
                sideRoom.setPosition((Position2D)sideRoomData.func_76341_a());
                sideRoom.setRotation((Rotation)sideRoomData.func_76340_b());
                sideRoom.stage = stage;
                layer.segments[((Position2D)sideRoomData.func_76341_a()).x][((Position2D)sideRoomData.func_76341_a()).z] = new PlaceHolder(sideRoom).addFlag(PlaceHolder.Flag.FIXED_MODEL);
                layer.segments[x][z].reference.openSide(dir.func_176734_d());
                layer.map.markPositionAsOccupied((Position2D)sideRoomData.func_76341_a());
                layer.rotatePiece(layer.segments[x][z]);
                return true;
            }
            return false;
        });
    }

    @FunctionalInterface
    public static interface CorridorFeature {
        public boolean process(DungeonBuilder var1, DungeonLayer var2, int var3, int var4, Random var5, int var6, int var7, BlockPos var8);
    }
}

