/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonLayerMap;
import xiroc.dungeoncrawl.dungeon.DungeonStatTracker;
import xiroc.dungeoncrawl.dungeon.Node;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.piece.DungeonCorridor;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.dungeon.piece.PlaceHolder;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonNodeRoom;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonSecretRoom;
import xiroc.dungeoncrawl.util.Orientation;
import xiroc.dungeoncrawl.util.Position2D;

public class DungeonLayer {
    public PlaceHolder[][] segments;
    public Position2D start;
    public Position2D end;
    public int width;
    public int length;
    public List<Position2D> distantNodes;
    public int nodes;
    public int rooms;
    public int nodesLeft;
    public int roomsLeft;
    public boolean stairsPlaced;
    public DungeonStatTracker.LayerStatTracker statTracker;
    public DungeonLayerMap map;

    public DungeonLayer() {
        this(16, 16);
    }

    public DungeonLayer(int width, int length) {
        this.width = width;
        this.length = length;
        this.statTracker = new DungeonStatTracker.LayerStatTracker();
        this.segments = new PlaceHolder[this.width][this.length];
        this.distantNodes = Lists.newArrayList();
    }

    public void buildConnection(Position2D start, Position2D end) {
        block26: {
            int endZ;
            int endX;
            int startZ;
            int startX;
            block28: {
                block27: {
                    DungeonCorridor corridor;
                    int z;
                    block25: {
                        DungeonCorridor corridor2;
                        int z2;
                        startX = start.x;
                        startZ = start.z;
                        endX = end.x;
                        endZ = end.z;
                        if (startX == endX && startZ == endZ) {
                            return;
                        }
                        if (startX <= endX) break block25;
                        this.segments[startX][startZ].reference.openSide(Direction.WEST);
                        for (int x = startX; x > (startZ == endZ ? endX + 1 : endX); --x) {
                            Direction side;
                            Direction direction = x - 1 == endX ? (startZ < endZ ? Direction.SOUTH : Direction.NORTH) : (side = Direction.WEST);
                            if (this.segments[x - 1][startZ] != null) {
                                this.segments[x - 1][startZ].reference.openSide(side);
                                this.segments[x - 1][startZ].reference.openSide(Direction.EAST);
                                this.rotatePiece(this.segments[x - 1][startZ]);
                                continue;
                            }
                            DungeonCorridor corridor3 = new DungeonCorridor(null, DungeonPiece.DEFAULT_NBT);
                            corridor3.setPosition(x - 1, startZ);
                            corridor3.setRotation(x - 1 == endX ? Orientation.getRotationFromCW90DoubleFacing(startZ > endZ ? Direction.NORTH : Direction.SOUTH, Direction.EAST) : Orientation.getRotationFromFacing(Direction.WEST));
                            corridor3.openSide(side);
                            corridor3.openSide(Direction.EAST);
                            this.segments[x - 1][startZ] = new PlaceHolder(corridor3);
                        }
                        if (startZ > endZ) {
                            this.segments[endX][endZ].reference.openSide(Direction.SOUTH);
                            for (z2 = startZ; z2 > endZ + 1; --z2) {
                                if (this.segments[endX][z2 - 1] != null) {
                                    this.segments[endX][z2 - 1].reference.openSide(Direction.SOUTH);
                                    this.segments[endX][z2 - 1].reference.openSide(z2 - 1 == endZ ? Direction.WEST : Direction.NORTH);
                                    this.rotatePiece(this.segments[endX][z2 - 1]);
                                    continue;
                                }
                                corridor2 = new DungeonCorridor(null, DungeonPiece.DEFAULT_NBT);
                                corridor2.setPosition(endX, z2 - 1);
                                corridor2.setRotation(z2 - 1 == endZ ? Orientation.getRotationFromCW90DoubleFacing(Direction.NORTH, Direction.WEST) : Orientation.getRotationFromFacing(Direction.NORTH));
                                corridor2.openSide(Direction.SOUTH);
                                corridor2.openSide(z2 - 1 == endZ ? Direction.WEST : Direction.NORTH);
                                this.segments[endX][z2 - 1] = new PlaceHolder(corridor2);
                            }
                        } else if (startZ < endZ) {
                            this.segments[endX][endZ].reference.openSide(Direction.NORTH);
                            for (z2 = startZ; z2 < endZ - 1; ++z2) {
                                if (this.segments[endX][z2 + 1] != null) {
                                    this.segments[endX][z2 + 1].reference.openSide(z2 + 1 == endZ ? Direction.WEST : Direction.SOUTH);
                                    this.segments[endX][z2 + 1].reference.openSide(Direction.NORTH);
                                    this.rotatePiece(this.segments[endX][z2 + 1]);
                                    continue;
                                }
                                corridor2 = new DungeonCorridor(null, DungeonPiece.DEFAULT_NBT);
                                corridor2.setPosition(endX, z2 + 1);
                                corridor2.setRotation(z2 + 1 == endZ ? Orientation.getRotationFromCW90DoubleFacing(Direction.NORTH, Direction.WEST) : Orientation.getRotationFromFacing(Direction.SOUTH));
                                corridor2.openSide(z2 + 1 == endZ ? Direction.WEST : Direction.SOUTH);
                                corridor2.openSide(Direction.NORTH);
                                this.segments[endX][z2 + 1] = new PlaceHolder(corridor2);
                            }
                        } else {
                            this.segments[endX][endZ].reference.openSide(Direction.EAST);
                        }
                        break block26;
                    }
                    if (startX >= endX) break block27;
                    this.segments[startX][startZ].reference.openSide(Direction.EAST);
                    for (int x = startX; x < (startZ == endZ ? endX - 1 : endX); ++x) {
                        Direction side;
                        Direction direction = x + 1 == endX ? (startZ < endZ ? Direction.SOUTH : Direction.NORTH) : (side = Direction.EAST);
                        if (this.segments[x + 1][startZ] != null) {
                            this.segments[x + 1][startZ].reference.openSide(side);
                            this.segments[x + 1][startZ].reference.openSide(Direction.WEST);
                            this.rotatePiece(this.segments[x + 1][startZ]);
                            continue;
                        }
                        DungeonCorridor corridor4 = new DungeonCorridor(null, DungeonPiece.DEFAULT_NBT);
                        corridor4.setPosition(x + 1, startZ);
                        corridor4.setRotation(x + 1 == endX ? Orientation.getRotationFromCW90DoubleFacing(startZ > endZ ? Direction.NORTH : Direction.SOUTH, Direction.WEST) : Orientation.getRotationFromFacing(Direction.EAST));
                        corridor4.openSide(side);
                        corridor4.openSide(Direction.WEST);
                        this.segments[x + 1][startZ] = new PlaceHolder(corridor4);
                    }
                    if (startZ > endZ) {
                        this.segments[endX][endZ].reference.openSide(Direction.SOUTH);
                        for (z = startZ; z > endZ + 1; --z) {
                            if (this.segments[endX][z - 1] != null) {
                                this.segments[endX][z - 1].reference.openSide(Direction.SOUTH);
                                this.segments[endX][z - 1].reference.openSide(z - 1 == endZ ? Direction.EAST : Direction.NORTH);
                                this.rotatePiece(this.segments[endX][z - 1]);
                                continue;
                            }
                            corridor = new DungeonCorridor(null, DungeonPiece.DEFAULT_NBT);
                            corridor.setPosition(endX, z - 1);
                            corridor.setRotation(z - 1 == endZ ? Orientation.getRotationFromCW90DoubleFacing(Direction.NORTH, Direction.WEST) : Orientation.getRotationFromFacing(Direction.NORTH));
                            corridor.openSide(Direction.SOUTH);
                            corridor.openSide(z - 1 == endZ ? Direction.WEST : Direction.NORTH);
                            this.segments[endX][z - 1] = new PlaceHolder(corridor);
                        }
                    } else if (startZ < endZ) {
                        this.segments[endX][endZ].reference.openSide(Direction.NORTH);
                        for (z = startZ; z < endZ - 1; ++z) {
                            if (this.segments[endX][z + 1] != null) {
                                this.segments[endX][z + 1].reference.openSide(z + 1 == endZ ? Direction.EAST : Direction.SOUTH);
                                this.segments[endX][z + 1].reference.openSide(Direction.NORTH);
                                this.rotatePiece(this.segments[endX][z + 1]);
                                continue;
                            }
                            corridor = new DungeonCorridor(null, DungeonPiece.DEFAULT_NBT);
                            corridor.setPosition(endX, z + 1);
                            corridor.setRotation(z + 1 == endZ ? Orientation.getRotationFromCW90DoubleFacing(Direction.NORTH, Direction.WEST) : Orientation.getRotationFromFacing(Direction.SOUTH));
                            corridor.openSide(z + 1 == endZ ? Direction.WEST : Direction.SOUTH);
                            corridor.openSide(Direction.NORTH);
                            this.segments[endX][z + 1] = new PlaceHolder(corridor);
                        }
                    } else {
                        this.segments[endX][endZ].reference.openSide(Direction.WEST);
                    }
                    break block26;
                }
                if (startZ <= endZ) break block28;
                this.segments[startX][startZ].reference.openSide(Direction.NORTH);
                this.segments[endX][endZ].reference.openSide(Direction.SOUTH);
                for (int z = startZ; z > endZ + 1; --z) {
                    if (this.segments[endX][z - 1] != null) {
                        this.segments[endX][z - 1].reference.openSide(Direction.NORTH);
                        this.segments[endX][z - 1].reference.openSide(Direction.SOUTH);
                        this.rotatePiece(this.segments[endX][z - 1]);
                        continue;
                    }
                    DungeonCorridor corridor = new DungeonCorridor(null, DungeonPiece.DEFAULT_NBT);
                    corridor.setPosition(endX, z - 1);
                    corridor.setRotation(Orientation.getRotationFromFacing(Direction.NORTH));
                    corridor.openSide(Direction.SOUTH);
                    corridor.openSide(Direction.NORTH);
                    this.segments[endX][z - 1] = new PlaceHolder(corridor);
                }
                break block26;
            }
            if (startZ >= endZ) break block26;
            this.segments[startX][startZ].reference.openSide(Direction.SOUTH);
            this.segments[endX][endZ].reference.openSide(Direction.NORTH);
            for (int z = startZ; z < endZ - 1; ++z) {
                if (this.segments[endX][z + 1] != null) {
                    this.segments[endX][z + 1].reference.openSide(Direction.SOUTH);
                    this.segments[endX][z + 1].reference.openSide(Direction.NORTH);
                    this.rotatePiece(this.segments[endX][z + 1]);
                    continue;
                }
                this.segments[endX][endZ].reference.openSide(Direction.NORTH);
                DungeonCorridor corridor = new DungeonCorridor(null, DungeonPiece.DEFAULT_NBT);
                corridor.setPosition(endX, z + 1);
                corridor.setRotation(Orientation.getRotationFromFacing(Direction.SOUTH));
                corridor.openSide(Direction.SOUTH);
                corridor.openSide(Direction.NORTH);
                this.segments[endX][z + 1] = new PlaceHolder(corridor);
            }
        }
    }

    public Tuple<Position2D, Rotation> findStarterRoomData(Position2D start, Random rand) {
        int index = rand.nextInt(4);
        for (int i = 0; i < 4; ++i) {
            index = (index + i) % 4;
            for (int j = 0; j < 2; ++j) {
                Tuple<Position2D, Rotation> data;
                Position2D current = start.shift(Orientation.FLAT_FACINGS[index], j + 1);
                if (current.isValid(15) && this.segments[current.x][current.z] != null && this.segments[current.x][current.z].reference.getType() == 0 && this.segments[current.x][current.z].reference.connectedSides < 4 && (data = this.findSideRoomData(new Position2D(current.x, current.z))) != null) {
                    return data;
                }
                current = start.shift(Orientation.FLAT_FACINGS[index], 1);
            }
        }
        return null;
    }

    public Tuple<Position2D, Rotation> findSideRoomData(Position2D base) {
        Position2D north = base.shift(Direction.NORTH, 1);
        Position2D east = base.shift(Direction.EAST, 1);
        Position2D south = base.shift(Direction.SOUTH, 1);
        Position2D west = base.shift(Direction.WEST, 1);
        if (north.isValid(this.width, this.length) && this.segments[north.x][north.z] == null) {
            return new Tuple((Object)north, (Object)Rotation.COUNTERCLOCKWISE_90);
        }
        if (east.isValid(this.width, this.length) && this.segments[east.x][east.z] == null) {
            return new Tuple((Object)east, (Object)Rotation.NONE);
        }
        if (south.isValid(this.width, this.length) && this.segments[south.x][south.z] == null) {
            return new Tuple((Object)south, (Object)Rotation.CLOCKWISE_90);
        }
        if (west.isValid(this.width, this.length) && this.segments[west.x][west.z] == null) {
            return new Tuple((Object)west, (Object)Rotation.CLOCKWISE_180);
        }
        return null;
    }

    public void rotatePiece(PlaceHolder placeHolder) {
        if (placeHolder.hasFlag(PlaceHolder.Flag.FIXED_ROTATION)) {
            return;
        }
        DungeonPiece piece = placeHolder.reference;
        switch (piece.connectedSides) {
            case 1: {
                piece.setRotation(Orientation.getRotationFromFacing(DungeonPiece.getOneWayDirection(piece)));
                return;
            }
            case 2: {
                if (piece.sides[0] && piece.sides[2]) {
                    piece.setRotation(Orientation.getRotationFromFacing(Direction.NORTH));
                } else if (piece.sides[1] && piece.sides[3]) {
                    piece.setRotation(Orientation.getRotationFromFacing(Direction.EAST));
                } else {
                    piece.setRotation(Orientation.getRotationFromCW90DoubleFacing(DungeonPiece.getOpenSide(piece, 0), DungeonPiece.getOpenSide(piece, 1)));
                }
                return;
            }
            case 3: {
                piece.setRotation(Orientation.getRotationFromTripleFacing(DungeonPiece.getOpenSide(piece, 0), DungeonPiece.getOpenSide(piece, 1), DungeonPiece.getOpenSide(piece, 2)));
            }
        }
    }

    public void rotateNode(PlaceHolder placeHolder) {
        if (placeHolder.hasFlag(PlaceHolder.Flag.FIXED_ROTATION)) {
            return;
        }
        DungeonNodeRoom node = (DungeonNodeRoom)placeHolder.reference;
        Rotation rotation = node.node.compare(new Node(node.sides[0], node.sides[1], node.sides[2], node.sides[3]));
        if (rotation != null) {
            node.field_186169_c = rotation;
        } else {
            DungeonCrawl.LOGGER.error("Could not find a proper rotation for [{} {} {} {}].", (Object)node.sides[0], (Object)node.sides[1], (Object)node.sides[2], (Object)node.sides[3]);
        }
    }

    public Direction findNext(DungeonPiece piece, Direction base) {
        if (piece.connectedSides >= 4) {
            return null;
        }
        if (piece.sides[(base.func_176736_b() + 2) % 4]) {
            return this.findNext(piece, base.func_176746_e());
        }
        return base;
    }

    public boolean placeSecretRoom(DungeonCorridor corridor, Position2D position, Random rand) {
        Position2D pos2;
        Direction direction = corridor.field_186169_c == Rotation.NONE || corridor.field_186169_c == Rotation.CLOCKWISE_180 ? (rand.nextBoolean() ? Direction.NORTH : Direction.SOUTH) : (rand.nextBoolean() ? Direction.EAST : Direction.WEST);
        Position2D pos = position.shift(direction, 2);
        if (pos.isValid(this.width, this.length)) {
            pos2 = position.shift(direction, 1);
            if (this.segments[pos.x][pos.z] == null && this.segments[pos2.x][pos2.z] == null) {
                DungeonSecretRoom room = new DungeonSecretRoom(null, DungeonPiece.DEFAULT_NBT);
                int x = Math.min(pos.x, pos2.x);
                int z = Math.min(pos.z, pos2.z);
                room.setPosition(x, z);
                room.setRotation(Orientation.getRotationFromFacing(direction));
                this.segments[x][z] = new PlaceHolder(room);
                Position2D other = DungeonLayer.getOther(x, z, direction);
                this.segments[other.x][other.z] = new PlaceHolder(room).addFlag(PlaceHolder.Flag.PLACEHOLDER);
                corridor.field_186169_c = Orientation.getRotationFromFacing(direction).func_185830_a(Rotation.CLOCKWISE_90);
                corridor.modelID = DungeonModels.CORRIDOR_SECRET_ROOM_ENTRANCE.id;
                this.segments[position.x][position.z].addFlag(PlaceHolder.Flag.FIXED_MODEL);
                return true;
            }
        }
        if ((pos = position.shift(direction = direction.func_176734_d(), 2)).isValid(this.width, this.length)) {
            pos2 = position.shift(direction, 1);
            if (this.segments[pos.x][pos.z] == null && this.segments[pos2.x][pos2.z] == null) {
                DungeonSecretRoom room = new DungeonSecretRoom(null, DungeonPiece.DEFAULT_NBT);
                int x = Math.min(pos.x, pos2.x);
                int z = Math.min(pos.z, pos2.z);
                room.setPosition(x, z);
                room.setRotation(Orientation.getRotationFromFacing(direction));
                this.segments[x][z] = new PlaceHolder(room);
                Position2D other = DungeonLayer.getOther(x, z, direction);
                this.segments[other.x][other.z] = new PlaceHolder(room).addFlag(PlaceHolder.Flag.PLACEHOLDER);
                corridor.field_186169_c = Orientation.getRotationFromFacing(direction).func_185830_a(Rotation.CLOCKWISE_90);
                corridor.modelID = DungeonModels.CORRIDOR_SECRET_ROOM_ENTRANCE.id;
                this.segments[position.x][position.z].addFlag(PlaceHolder.Flag.FIXED_MODEL);
                return true;
            }
        }
        return false;
    }

    private static Position2D getOther(int x, int z, Direction direction) {
        switch (direction) {
            case EAST: 
            case WEST: {
                return new Position2D(x + 1, z);
            }
            case SOUTH: 
            case NORTH: {
                return new Position2D(x, z + 1);
            }
        }
        throw new UnsupportedOperationException("Can't get other position from direction " + direction.toString());
    }

    public boolean canPutDoubleRoom(Position2D pos, Direction direction) {
        if (!pos.isValid(this.width, this.length) || this.segments[pos.x][pos.z] != null && this.map.isPositionFree(pos.x, pos.z)) {
            return false;
        }
        switch (direction) {
            case NORTH: {
                return pos.z > 0 && this.segments[pos.x][pos.z - 1] == null && this.map.isPositionFree(pos.x, pos.z - 1);
            }
            case EAST: {
                return pos.x < this.width - 1 && this.segments[pos.x + 1][pos.z] == null && this.map.isPositionFree(pos.x + 1, pos.z);
            }
            case SOUTH: {
                return pos.z < this.length - 1 && this.segments[pos.x][pos.z + 1] == null && this.map.isPositionFree(pos.x, pos.z + 1);
            }
            case WEST: {
                return pos.x > 0 && this.segments[pos.x - 1][pos.z] == null && this.map.isPositionFree(pos.x - 1, pos.z);
            }
        }
        return false;
    }

    public Position2D getLargeRoomPos(Position2D pos) {
        int a = 14;
        int x = pos.x;
        int z = pos.z;
        if (x < a && z < a && this.get(x + 1, z) == null && this.get(x + 1, z + 1) == null && this.get(x, z + 1) == null) {
            return pos;
        }
        if (x < a && z > 0 && this.get(x + 1, z) == null && this.get(x + 1, z - 1) == null && this.get(x, z - 1) == null) {
            return new Position2D(x, z - 1);
        }
        if (x > 0 && z < a && this.get(x - 1, z) == null && this.get(x - 1, z + 1) == null && this.get(x, z + 1) == null) {
            return new Position2D(x - 1, z);
        }
        if (x > 0 && z > 0 && this.get(x - 1, z) == null && this.get(x - 1, z - 1) == null && this.get(x, z - 1) == null) {
            return new Position2D(x - 1, z - 1);
        }
        return null;
    }

    public static Position2D getLargeRoomPos(DungeonLayer layer, Position2D pos) {
        int a = 14;
        int x = pos.x;
        int z = pos.z;
        if (x < a && z < a && layer.get(x + 1, z) == null && layer.get(x + 1, z + 1) == null && layer.get(x, z + 1) == null) {
            return pos;
        }
        if (x < a && z > 0 && layer.get(x + 1, z) == null && layer.get(x + 1, z - 1) == null && layer.get(x, z - 1) == null) {
            return new Position2D(x, z - 1);
        }
        if (x > 0 && z < a && layer.get(x - 1, z) == null && layer.get(x - 1, z + 1) == null && layer.get(x, z + 1) == null) {
            return new Position2D(x - 1, z);
        }
        if (x > 0 && z > 0 && layer.get(x - 1, z) == null && layer.get(x - 1, z - 1) == null && layer.get(x, z - 1) == null) {
            return new Position2D(x - 1, z - 1);
        }
        return null;
    }

    public DungeonPiece get(int x, int z) {
        return this.segments[x][z] == null ? null : this.segments[x][z].reference;
    }
}

