/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;

public class Node {
    public static final Node DEAD_END = new Node(false, false, false, true);
    public static final Node STRAIGHT = new Node(false, true, false, true);
    public static final Node TURN = new Node(false, false, true, true);
    public static final Node FORK = new Node(false, true, true, true);
    public static final Node ALL = new Node(true, true, true, true);
    private final boolean[] sides;

    public Node(boolean north, boolean east, boolean south, boolean west) {
        this.sides = new boolean[]{north, east, south, west};
    }

    public Node(boolean[] values) {
        this.sides = values;
    }

    public boolean canConnect(Direction side) {
        return this.sides[(side.func_176736_b() + 2) % 4];
    }

    public Direction findClosest(Direction base) {
        if (this.canConnect(base)) {
            return base;
        }
        if (this.canConnect(base = base.func_176746_e())) {
            return base;
        }
        if (this.canConnect(base = base.func_176734_d())) {
            return base;
        }
        if (this.canConnect(base = base.func_176735_f())) {
            return base;
        }
        return null;
    }

    public Node rotate(Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return new Node(this.sides[3], this.sides[0], this.sides[1], this.sides[2]);
            }
            case COUNTERCLOCKWISE_90: {
                return new Node(this.sides[1], this.sides[2], this.sides[3], this.sides[0]);
            }
            case CLOCKWISE_180: {
                return new Node(this.sides[2], this.sides[3], this.sides[0], this.sides[1]);
            }
        }
        return this;
    }

    public Rotation compare(Node node) {
        return Node.compare(node, this, Rotation.NONE, 0);
    }

    private static Rotation compare(Node node, Node rotatedNode, Rotation currentRotation, int depth) {
        if (depth > 3) {
            return null;
        }
        for (int i = 0; i < node.sides.length; ++i) {
            if (!node.sides[i] || rotatedNode.sides[i]) continue;
            return Node.compare(node, rotatedNode.rotate(Rotation.CLOCKWISE_90), currentRotation.func_185830_a(Rotation.CLOCKWISE_90), ++depth);
        }
        return currentRotation;
    }
}

