/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.block;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.loot.LootTables;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;
import xiroc.dungeoncrawl.util.Orientation;

public class Chest
implements IBlockPlacementHandler {
    @Override
    public void placeBlock(IWorld world, BlockState state, BlockPos pos, Random rand, Treasure.Type treasureType, int theme, int lootLevel) {
        world.func_180501_a(pos, state, 3);
        if (world.func_175625_s(pos) instanceof LockableLootTileEntity) {
            ResourceLocation lootTable = Treasure.SPECIAL_LOOT_TABLES.get((Object)treasureType);
            LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)world.func_201674_k(), (BlockPos)pos, (ResourceLocation)(lootTable == null ? Chest.getLootTable(theme, lootLevel, rand) : lootTable));
        } else {
            DungeonCrawl.LOGGER.warn("Failed to fetch a chest/barrel entity at {}", (Object)pos.toString());
        }
    }

    public static ResourceLocation getLootTable(int theme, int lootLevel, Random rand) {
        switch (lootLevel) {
            case 0: {
                return (double)rand.nextFloat() < 0.1 ? LootTables.field_186430_l : Loot.CHEST_STAGE_1;
            }
            case 1: {
                return (double)rand.nextFloat() < 0.1 ? LootTables.field_186422_d : Loot.CHEST_STAGE_2;
            }
            case 2: {
                return (double)rand.nextFloat() < 0.1 ? LootTables.field_186422_d : Loot.CHEST_STAGE_3;
            }
            case 3: {
                return (double)rand.nextFloat() < 0.1 ? LootTables.field_186427_i : Loot.CHEST_STAGE_4;
            }
            case 4: {
                return (double)rand.nextFloat() < 0.1 ? LootTables.field_186427_i : Loot.CHEST_STAGE_5;
            }
        }
        return Loot.CHEST_STAGE_5;
    }

    public static class TrappedChest
    implements IBlockPlacementHandler {
        @Override
        public void placeBlock(IWorld world, BlockState state, BlockPos pos, Random rand, Treasure.Type treasureType, int theme, int lootLevel) {
            if (state.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Orientation.RANDOM_FACING_FLAT.roll(rand));
            }
            world.func_180501_a(pos, state, 3);
            if (world.func_175625_s(pos) instanceof LockableLootTileEntity) {
                ResourceLocation lootTable = Treasure.SPECIAL_LOOT_TABLES.get((Object)treasureType);
                LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)world.func_201674_k(), (BlockPos)pos, (ResourceLocation)(lootTable == null ? Chest.getLootTable(theme, lootLevel, rand) : lootTable));
            } else {
                DungeonCrawl.LOGGER.warn("Failed to fetch a trapped chest entity at {}", (Object)pos.toString());
            }
        }
    }
}

