/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.decoration;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.dungeon.block.WeightedRandomBlock;
import xiroc.dungeoncrawl.dungeon.decoration.IDungeonDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.dungeon.model.PlacementBehaviour;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.util.IBlockStateProvider;

public class FloorDecoration
implements IDungeonDecoration {
    private final float chance;
    private final IBlockStateProvider blockStateProvider;

    public FloorDecoration(IBlockStateProvider blockStateProvider, float chance) {
        this.blockStateProvider = blockStateProvider;
        this.chance = chance;
    }

    @Override
    public void decorate(DungeonModel model, IWorld world, BlockPos pos, int width, int height, int length, MutableBoundingBox worldGenBounds, MutableBoundingBox structureBounds, DungeonPiece piece, int stage) {
        for (int x = 0; x < model.width; ++x) {
            for (int z = 0; z < model.length; ++z) {
                for (int y = 0; y < model.height; ++y) {
                    BlockPos blockPos = IDungeonDecoration.getRotatedBlockPos(x, y + 1, z, pos, model, piece.field_186169_c);
                    if (model.model[x][y][z] == null || model.model[x][y][z].type != DungeonModelBlockType.FLOOR || y >= model.height - 1 || !worldGenBounds.func_175898_b((Vector3i)blockPos) || !structureBounds.func_175898_b((Vector3i)blockPos) || !world.func_175623_d(new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y + 1, pos.func_177952_p() + z)) || !FloorDecoration.checkSolid(world, new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z), worldGenBounds, structureBounds) || !(WeightedRandomBlock.RANDOM.nextFloat() < this.chance)) continue;
                    piece.setBlockState(this.blockStateProvider.get(), world, worldGenBounds, null, blockPos, 0, 0, PlacementBehaviour.SOLID);
                }
            }
        }
    }

    private static boolean checkSolid(IWorld world, BlockPos pos, MutableBoundingBox worldGenBounds, MutableBoundingBox structureBounds) {
        return worldGenBounds.func_175898_b((Vector3i)pos) && structureBounds.func_175898_b((Vector3i)pos) && world.func_180495_p(pos).func_200132_m();
    }

    public static class NextToSolid
    implements IDungeonDecoration {
        private final float chance;
        private final IBlockStateProvider blockStateProvider;

        public NextToSolid(IBlockStateProvider blockStateProvider, float chance) {
            this.blockStateProvider = blockStateProvider;
            this.chance = chance;
        }

        @Override
        public void decorate(DungeonModel model, IWorld world, BlockPos pos, int width, int height, int length, MutableBoundingBox worldGenBounds, MutableBoundingBox structureBounds, DungeonPiece piece, int stage) {
            for (int x = 0; x < model.width; ++x) {
                for (int z = 0; z < model.length; ++z) {
                    for (int y = 0; y < model.height; ++y) {
                        if (model.model[x][y][z] == null || model.model[x][y][z].type != DungeonModelBlockType.FLOOR || y >= model.height - 1) continue;
                        BlockPos p = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y + 1, pos.func_177952_p() + z);
                        BlockPos blockPos = IDungeonDecoration.getRotatedBlockPos(x, y + 1, z, pos, model, piece.field_186169_c);
                        if (!worldGenBounds.func_175898_b((Vector3i)blockPos) || !structureBounds.func_175898_b((Vector3i)blockPos) || !world.func_175623_d(p) || !world.func_180495_p(p.func_177977_b()).func_200132_m() || !FloorDecoration.checkSolid(world, p.func_177978_c(), worldGenBounds, structureBounds) && !FloorDecoration.checkSolid(world, p.func_177974_f(), worldGenBounds, structureBounds) && !FloorDecoration.checkSolid(world, p.func_177968_d(), worldGenBounds, structureBounds) && !FloorDecoration.checkSolid(world, p.func_177976_e(), worldGenBounds, structureBounds) || !(WeightedRandomBlock.RANDOM.nextFloat() < this.chance)) continue;
                        piece.setBlockState(this.blockStateProvider.get(), world, worldGenBounds, null, blockPos, 0, 0, PlacementBehaviour.SOLID);
                    }
                }
            }
        }
    }
}

