/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.decoration;

import com.google.gson.JsonObject;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.decoration.FloorDecoration;
import xiroc.dungeoncrawl.dungeon.decoration.ScatteredDecoration;
import xiroc.dungeoncrawl.dungeon.decoration.VineDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.theme.JsonThemeHandler;
import xiroc.dungeoncrawl.util.IBlockStateProvider;

@FunctionalInterface
public interface IDungeonDecoration {
    public void decorate(DungeonModel var1, IWorld var2, BlockPos var3, int var4, int var5, int var6, MutableBoundingBox var7, MutableBoundingBox var8, DungeonPiece var9, int var10);

    public static IDungeonDecoration fromJson(JsonObject object) {
        if (object.has("type")) {
            String type;
            switch (type = object.get("type").getAsString().toLowerCase()) {
                case "vines": {
                    return new VineDecoration();
                }
                case "scattered": {
                    IBlockStateProvider blockStateProvider;
                    float chance;
                    float f = chance = object.has("chance") ? object.get("chance").getAsFloat() : 0.25f;
                    if (object.has("block")) {
                        blockStateProvider = JsonThemeHandler.deserialize(object, "block");
                        if (blockStateProvider != null) {
                            return new ScatteredDecoration(blockStateProvider, chance);
                        }
                    } else {
                        DungeonCrawl.LOGGER.warn("Missing entry 'block'");
                        return null;
                    }
                }
                case "floor": {
                    IBlockStateProvider blockStateProvider;
                    float chance;
                    float f = chance = object.has("chance") ? object.get("chance").getAsFloat() : 0.5f;
                    if (object.has("block")) {
                        blockStateProvider = JsonThemeHandler.deserialize(object, "block");
                        if (blockStateProvider != null) {
                            return new FloorDecoration(blockStateProvider, chance);
                        }
                    } else {
                        DungeonCrawl.LOGGER.warn("Missing entry 'block'");
                        return null;
                    }
                }
                case "floor_next_to_solid": {
                    IBlockStateProvider blockStateProvider;
                    float chance;
                    float f = chance = object.has("chance") ? object.get("chance").getAsFloat() : 0.5f;
                    if (object.has("block")) {
                        blockStateProvider = JsonThemeHandler.deserialize(object, "block");
                        if (blockStateProvider == null) break;
                        return new FloorDecoration.NextToSolid(blockStateProvider, chance);
                    }
                    DungeonCrawl.LOGGER.warn("Missing entry 'block'");
                    return null;
                }
            }
            DungeonCrawl.LOGGER.warn("Unknown decoration type '{}'", (Object)type);
            return null;
        }
        return null;
    }

    public static BlockPos getRotatedBlockPos(int x, int y, int z, BlockPos base, DungeonModel model, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return new BlockPos(base.func_177958_n() + model.length - z - 1, base.func_177956_o() + y, base.func_177952_p() + x);
            }
            case CLOCKWISE_180: {
                return new BlockPos(base.func_177958_n() + model.width - x - 1, base.func_177956_o() + y, base.func_177952_p() + model.length - z - 1);
            }
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(base.func_177958_n() + z, base.func_177956_o() + y, base.func_177952_p() + model.width - x - 1);
            }
        }
        return new BlockPos(base.func_177958_n() + x, base.func_177956_o() + y, base.func_177952_p() + z);
    }
}

