/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.generator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.ChunkPos;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonFeatures;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.generator.DungeonGenerator;
import xiroc.dungeoncrawl.dungeon.generator.DungeonGeneratorSettings;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.piece.DungeonCorridor;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.dungeon.piece.DungeonStairs;
import xiroc.dungeoncrawl.dungeon.piece.PlaceHolder;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonNodeRoom;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonRoom;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonSideRoom;
import xiroc.dungeoncrawl.util.Orientation;
import xiroc.dungeoncrawl.util.Position2D;

public class DefaultGenerator
extends DungeonGenerator {
    private int layers;
    private int[] nodesLeft;
    private int[] roomsLeft;
    private int[] nodes;
    private int[] rooms;
    private boolean[] secretRoom;

    public DefaultGenerator(DungeonGeneratorSettings settings) {
        super(settings);
    }

    @Override
    public void initialize(DungeonBuilder dungeonBuilder, ChunkPos chunkPos, Random rand) {
        this.nodesLeft = new int[this.layers];
        this.roomsLeft = new int[this.layers];
        this.nodes = new int[this.layers];
        this.rooms = new int[this.layers];
        this.secretRoom = new boolean[this.layers];
        for (int layer = 0; layer < this.layers; ++layer) {
            this.nodesLeft[layer] = this.settings.maxNodes.apply(rand, layer);
            this.roomsLeft[layer] = this.settings.maxRooms.apply(rand, layer);
        }
        this.secretRoom[rand.nextInt((int)2)] = true;
    }

    @Override
    public int calculateLayerCount(Random rand, int height) {
        this.layers = Math.min(this.maxLayers, height / 9);
        return this.layers;
    }

    @Override
    public DungeonModels.ModelCategory getCategoryForLayer(int layer) {
        return DungeonModels.ModelCategory.getCategoryForStage(layer);
    }

    @Override
    public void generateLayer(DungeonBuilder dungeonBuilder, DungeonLayer dungeonLayer, int layer, Random rand, Position2D startPosition) {
        DungeonStairs s = new DungeonStairs(null, DungeonPiece.DEFAULT_NBT).bottom();
        s.setPosition(startPosition.x, startPosition.z);
        dungeonLayer.segments[s.posX][s.posZ] = new PlaceHolder(s).addFlag(PlaceHolder.Flag.FIXED_ROTATION);
        dungeonLayer.stairsPlaced = false;
        dungeonLayer.start = startPosition;
        Direction[] directions = Orientation.FLAT_FACINGS;
        int maxDirections = 3 + rand.nextInt(2);
        int counter = 0;
        int start = rand.nextInt(4);
        for (int i = 0; i < 4; ++i) {
            Direction direction;
            if (counter >= maxDirections || !this.findPositionAndContinue(dungeonBuilder, dungeonLayer, startPosition, direction = directions[(i + start) % 4], rand, this.minDistance, this.maxDistance, layer, 1)) continue;
            ++counter;
        }
        DungeonCrawl.LOGGER.debug("Finished basic generation of layer {}: Generated {}/{} nodes and {}/{} rooms.", (Object)layer, (Object)this.nodes[layer], (Object)(this.nodes[layer] + this.nodesLeft[layer]), (Object)this.rooms[layer], (Object)(this.rooms[layer] + this.roomsLeft[layer]));
        if (layer == 0) {
            this.createStarterRoom(dungeonBuilder, dungeonLayer, rand, layer);
        }
        if (this.secretRoom[layer]) {
            ArrayList corridors = Lists.newArrayList();
            for (int x = 0; x < dungeonLayer.width; ++x) {
                for (int z = 0; z < dungeonLayer.length; ++z) {
                    if (dungeonLayer.segments[x][z] == null || dungeonLayer.segments[x][z].reference.getType() != 0) continue;
                    corridors.add(new Tuple((Object)((DungeonCorridor)dungeonLayer.segments[x][z].reference), (Object)new Position2D(x, z)));
                }
            }
            if (!corridors.isEmpty()) {
                Tuple corridor;
                for (int i = 0; i < 5 && !dungeonLayer.placeSecretRoom((DungeonCorridor)((Object)(corridor = (Tuple)corridors.get(rand.nextInt(corridors.size()))).func_76341_a()), (Position2D)corridor.func_76340_b(), rand); ++i) {
                }
            }
        }
        if (layer == this.layers - 1 && !dungeonLayer.distantNodes.isEmpty()) {
            Position2D pos = dungeonLayer.distantNodes.get(rand.nextInt(dungeonLayer.distantNodes.size()));
            if (dungeonLayer.segments[pos.x][pos.z] != null && dungeonLayer.segments[pos.x][pos.z].reference instanceof DungeonNodeRoom) {
                DungeonNodeRoom room = (DungeonNodeRoom)dungeonLayer.segments[pos.x][pos.z].reference;
                room.lootRoom = true;
                room.large = true;
            }
        }
        DungeonCrawl.LOGGER.debug("Finished generation of layer {}", (Object)layer);
    }

    public void layerGenerationStep(DungeonBuilder builder, DungeonLayer dungeonLayer, Position2D currentPosition, Position2D lastPosition, Random rand, int layer, int depth) {
        if (depth > this.maxDepth || this.nodesLeft[layer] == 0 && this.roomsLeft[layer] == 0) {
            return;
        }
        if (depth >= this.minStairsDepth && !dungeonLayer.stairsPlaced && layer != 4) {
            Direction toLast = currentPosition.directionTo(lastPosition);
            dungeonLayer.end = currentPosition;
            DungeonStairs stairs = new DungeonStairs(null, DungeonPiece.DEFAULT_NBT).top();
            stairs.openSide(toLast);
            stairs.setPosition(dungeonLayer.end.x, dungeonLayer.end.z);
            dungeonLayer.segments[stairs.posX][stairs.posZ] = new PlaceHolder(stairs).addFlag(PlaceHolder.Flag.FIXED_ROTATION);
            dungeonLayer.stairsPlaced = true;
            dungeonLayer.buildConnection(lastPosition, currentPosition);
            Direction[] directions = Orientation.getFlatFacingsWithout(toLast);
            int maxDirections = depth < 3 ? 1 + rand.nextInt(3) : rand.nextInt(3);
            int counter = 0;
            int start = rand.nextInt(3);
            for (int i = 0; i < 3; ++i) {
                Direction direction;
                if (counter >= maxDirections || !this.findPositionAndContinue(builder, dungeonLayer, currentPosition, direction = directions[(i + start) % 3], rand, this.minDistance, this.maxDistance, layer, ++depth)) continue;
                ++counter;
            }
            return;
        }
        if (depth <= this.maxNodeDepth && depth >= this.minNodeDepth && this.nodesLeft[layer] > 0) {
            Position2D center = currentPosition.shift(lastPosition.directionTo(currentPosition), 1);
            if (DungeonFeatures.canPlacePiece(dungeonLayer, center.x - 1, center.z - 1, 3, 3, false)) {
                this.createNodeRoom(center, dungeonLayer);
                int n = layer;
                this.nodes[n] = this.nodes[n] + 1;
                int n2 = layer;
                this.nodesLeft[n2] = this.nodesLeft[n2] - 1;
                if (depth > 1) {
                    dungeonLayer.distantNodes.add(center);
                }
                dungeonLayer.buildConnection(lastPosition, currentPosition);
                Direction[] directions = Orientation.getFlatFacingsWithout(currentPosition.directionTo(lastPosition));
                int maxDirections = depth < 3 ? 1 + rand.nextInt(3) : rand.nextInt(3);
                int counter = 0;
                int start = rand.nextInt(3);
                for (int i = 0; i < 3; ++i) {
                    if (counter >= maxDirections) continue;
                    Direction direction = directions[(i + start) % 3];
                    if (!this.findPositionAndContinue(builder, dungeonLayer, currentPosition.shift(currentPosition.directionTo(center), 1).shift(direction, 1), direction, rand, this.minDistance, this.maxDistance, layer, ++depth)) continue;
                    ++counter;
                }
                return;
            }
        }
        if (depth <= this.maxRoomDepth && depth >= this.minRoomDepth && this.roomsLeft[layer] > 0) {
            DungeonRoom room = new DungeonRoom(null, DungeonPiece.DEFAULT_NBT);
            room.setPosition(currentPosition);
            dungeonLayer.segments[currentPosition.x][currentPosition.z] = new PlaceHolder(room);
            int n = layer;
            this.rooms[n] = this.rooms[n] + 1;
            int n3 = layer;
            this.roomsLeft[n3] = this.roomsLeft[n3] - 1;
            dungeonLayer.buildConnection(lastPosition, currentPosition);
            Direction[] directions = Orientation.getFlatFacingsWithout(currentPosition.directionTo(lastPosition));
            int maxDirections = depth < 3 ? 1 + rand.nextInt(3) : rand.nextInt(3);
            int counter = 0;
            int start = rand.nextInt(3);
            for (int i = 0; i < 3; ++i) {
                Direction direction;
                if (counter >= maxDirections || !this.findPositionAndContinue(builder, dungeonLayer, currentPosition, direction = directions[(i + start) % 3], rand, this.minDistance, this.maxDistance, layer, ++depth)) continue;
                ++counter;
            }
        }
    }

    public boolean findPositionAndContinue(DungeonBuilder builder, DungeonLayer dungeonLayer, Position2D origin, Direction direction, Random rand, int min, int max, int layer, int depth) {
        switch (direction) {
            case NORTH: {
                if (origin.z > min) {
                    Position2D pos = origin.shift(direction, this.randomDistances ? min + rand.nextInt(Math.min(max, origin.z) - min + 1) : Math.min(1 + max, origin.z));
                    if (dungeonLayer.segments[pos.x][pos.z] == null && dungeonLayer.map.isPositionFree(pos.x, pos.z)) {
                        this.layerGenerationStep(builder, dungeonLayer, pos, origin, rand, layer, depth);
                        return true;
                    }
                }
                return false;
            }
            case EAST: {
                int east = 15 - origin.x - 1;
                if (east > min) {
                    Position2D pos = origin.shift(direction, this.randomDistances ? min + rand.nextInt(Math.min(max, east) - min + 1) : Math.min(1 + max, east));
                    if (dungeonLayer.segments[pos.x][pos.z] == null && dungeonLayer.map.isPositionFree(pos.x, pos.z)) {
                        this.layerGenerationStep(builder, dungeonLayer, pos, origin, rand, layer, depth);
                        return true;
                    }
                }
                return false;
            }
            case SOUTH: {
                int south = 15 - origin.z - 1;
                if (south > min) {
                    Position2D pos = origin.shift(direction, this.randomDistances ? min + rand.nextInt(Math.min(max, south) - min + 1) : Math.min(1 + max, south));
                    if (dungeonLayer.segments[pos.x][pos.z] == null && dungeonLayer.map.isPositionFree(pos.x, pos.z)) {
                        this.layerGenerationStep(builder, dungeonLayer, pos, origin, rand, layer, depth);
                        return true;
                    }
                }
                return false;
            }
            case WEST: {
                if (origin.x > min) {
                    Position2D pos = origin.shift(direction, this.randomDistances ? min + rand.nextInt(Math.min(max, origin.x) - min + 1) : Math.min(1 + max, origin.x));
                    if (dungeonLayer.segments[pos.x][pos.z] == null && dungeonLayer.map.isPositionFree(pos.x, pos.z)) {
                        this.layerGenerationStep(builder, dungeonLayer, pos, origin, rand, layer, depth);
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public void createNodeRoom(Position2D center, DungeonLayer dungeonLayer) {
        DungeonNodeRoom nodeRoom = new DungeonNodeRoom();
        nodeRoom.setPosition(center.x, center.z);
        PlaceHolder placeHolder = new PlaceHolder(nodeRoom).addFlag(PlaceHolder.Flag.PLACEHOLDER);
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (x == 0 && z == 0) continue;
                dungeonLayer.segments[center.x + x][center.z + z] = placeHolder;
            }
        }
        dungeonLayer.segments[center.x][center.z] = new PlaceHolder(nodeRoom);
    }

    public void createStarterRoom(DungeonBuilder builder, DungeonLayer dungeonLayer, Random rand, int layer) {
        Tuple<Position2D, Rotation> sideRoomData = dungeonLayer.findStarterRoomData(dungeonLayer.start, rand);
        if (sideRoomData != null) {
            DungeonSideRoom room = new DungeonSideRoom();
            room.modelID = 76;
            Direction dir = ((Rotation)sideRoomData.func_76340_b()).func_185831_a(Direction.WEST);
            room.openSide(dir);
            room.setPosition(((Position2D)sideRoomData.func_76341_a()).x, ((Position2D)sideRoomData.func_76341_a()).z);
            room.setRotation((Rotation)sideRoomData.func_76340_b());
            room.modelID = DungeonModels.STARTER_ROOM.id;
            room.stage = layer;
            dungeonLayer.map.markPositionAsOccupied((Position2D)sideRoomData.func_76341_a());
            dungeonLayer.segments[((Position2D)sideRoomData.func_76341_a()).x][((Position2D)sideRoomData.func_76341_a()).z] = new PlaceHolder(room).addFlag(PlaceHolder.Flag.FIXED_MODEL);
            Position2D connectedSegment = ((Position2D)sideRoomData.func_76341_a()).shift(dir, 1);
            if (dungeonLayer.segments[connectedSegment.x][connectedSegment.z] != null) {
                dungeonLayer.segments[connectedSegment.x][connectedSegment.z].reference.openSide(dir.func_176734_d());
                dungeonLayer.rotatePiece(dungeonLayer.segments[connectedSegment.x][connectedSegment.z]);
            }
        }
    }

    @Override
    public boolean supportsMutation() {
        return false;
    }

    @Override
    public void mutate(Random rand) {
    }
}

