/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.generator;

import java.util.Random;
import net.minecraft.util.math.ChunkPos;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.generator.DungeonGeneratorSettings;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.util.Position2D;

public abstract class DungeonGenerator {
    public DungeonGeneratorSettings settings;
    public int[] maxNodes;
    public int[] maxRooms;
    public int maxLayers;
    public int maxDepth;
    public int minDistance;
    public int maxDistance;
    public int minNodeDepth;
    public int maxNodeDepth;
    public int minRoomDepth;
    public int maxRoomDepth;
    public int minStairsDepth;
    public boolean randomDistances;

    public DungeonGenerator(DungeonGeneratorSettings settings) {
        this.loadSettings(settings);
    }

    public void loadSettings(DungeonGeneratorSettings settings) {
        this.maxNodes = new int[settings.maxLayers];
        this.maxRooms = new int[settings.maxLayers];
        this.minDistance = settings.minDistance;
        this.maxDistance = settings.maxDistance;
        this.maxLayers = settings.maxLayers;
        this.maxDepth = settings.maxDepth;
        this.minNodeDepth = settings.minNodeDepth;
        this.maxNodeDepth = settings.maxNodeDepth;
        this.minRoomDepth = settings.minRoomDepth;
        this.maxRoomDepth = settings.maxRoomDepth;
        this.minStairsDepth = settings.minStairsDepth;
        this.randomDistances = settings.randomDistances;
        this.settings = settings;
    }

    public boolean doesLayerHaveSecretRoom(int layer) {
        return false;
    }

    public abstract void initialize(DungeonBuilder var1, ChunkPos var2, Random var3);

    public abstract int calculateLayerCount(Random var1, int var2);

    public abstract void generateLayer(DungeonBuilder var1, DungeonLayer var2, int var3, Random var4, Position2D var5);

    public abstract boolean supportsMutation();

    public abstract void mutate(Random var1);

    public abstract DungeonModels.ModelCategory getCategoryForLayer(int var1);
}

