/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.generator;

import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;

public class DungeonGeneratorSettings {
    private static final Function<Integer, Integer> DEFAULT_GRID_SIZE = layer -> 15;
    public static final DungeonGeneratorSettings DEFAULT = new DungeonGeneratorSettings((rand, layer) -> 3 + layer, (rand, layer) -> 4 + (int)(1.5 * (double)layer.intValue()), 5, 2, 4, 5, 1, 3, 1, 5, 2, true);
    public static final DungeonGeneratorSettings LARGE = new DungeonGeneratorSettings((rand, layer) -> 5 + layer / 2, (rand, layer) -> 6 + layer, 5, 1, 3, 5, 1, 4, 1, 5, 2, true);
    public static final DungeonGeneratorSettings COMPLEX = new DungeonGeneratorSettings((rand, layer) -> 3 + layer / 2, (rand, layer) -> 10, 5, 1, 1, 7, 1, 4, 1, 7, 3, true);
    public static final DungeonGeneratorSettings CATACOMB_LABYRINTH = new DungeonGeneratorSettings((rand, layer) -> 6 + layer, (rand, layer) -> 20 + layer, layer -> 20 + layer, 5, 1, 3, 20, 1, 15, 1, 20, 5, true);
    public final Function<Integer, Integer> gridSize;
    public final BiFunction<Random, Integer, Integer> maxNodes;
    public final BiFunction<Random, Integer, Integer> maxRooms;
    public final int maxLayers;
    public final int minDistance;
    public final int maxDistance;
    public final int maxDepth;
    public final int minNodeDepth;
    public final int maxNodeDepth;
    public final int minRoomDepth;
    public final int maxRoomDepth;
    public final int minStairsDepth;
    public final boolean randomDistances;

    public DungeonGeneratorSettings(BiFunction<Random, Integer, Integer> maxNodes, BiFunction<Random, Integer, Integer> maxRooms, int maxLayers, int minDistance, int maxDistance, int maxDepth, int minNodeDepth, int maxNodeDepth, int minRoomDepth, int maxRoomDepth, int minStairsDepth, boolean randomDistances) {
        this.maxNodes = maxNodes;
        this.maxRooms = maxRooms;
        this.gridSize = DEFAULT_GRID_SIZE;
        this.maxLayers = maxLayers;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.maxDepth = maxDepth;
        this.minNodeDepth = minNodeDepth;
        this.maxNodeDepth = maxNodeDepth;
        this.minRoomDepth = minRoomDepth;
        this.maxRoomDepth = maxRoomDepth;
        this.minStairsDepth = minStairsDepth;
        this.randomDistances = randomDistances;
    }

    public DungeonGeneratorSettings(BiFunction<Random, Integer, Integer> maxNodes, BiFunction<Random, Integer, Integer> maxRooms, Function<Integer, Integer> gridSize, int maxLayers, int minDistance, int maxDistance, int maxDepth, int minNodeDepth, int maxNodeDepth, int minRoomDepth, int maxRoomDepth, int minStairsDepth, boolean randomDistances) {
        this.maxNodes = maxNodes;
        this.maxRooms = maxRooms;
        this.gridSize = gridSize;
        this.maxLayers = maxLayers;
        this.maxDistance = maxDistance;
        this.minDistance = minDistance;
        this.maxDepth = maxDepth;
        this.minNodeDepth = minNodeDepth;
        this.maxNodeDepth = maxNodeDepth;
        this.minRoomDepth = minRoomDepth;
        this.maxRoomDepth = maxRoomDepth;
        this.minStairsDepth = minStairsDepth;
        this.randomDistances = randomDistances;
    }
}

