/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelFeature;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.MultipartModelData;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.util.DirectionalBlockPos;
import xiroc.dungeoncrawl.util.JSONUtils;
import xiroc.dungeoncrawl.util.Orientation;
import xiroc.dungeoncrawl.util.WeightedRandom;

public class DungeonModel {
    public ResourceLocation location;
    public Integer id;
    public int width;
    public int height;
    public int length;
    public DungeonModelBlock[][][] model;
    @Nullable
    public FeaturePosition[] featurePositions;
    @Nullable
    public List<WeightedRandom<MultipartModelData>> multipartData;
    @Nullable
    public Metadata metadata;

    public DungeonModel(DungeonModelBlock[][][] model, FeaturePosition[] featurePositions) {
        this.model = model;
        this.width = model.length;
        this.height = model[0].length;
        this.length = model[0][0].length;
        this.featurePositions = featurePositions;
    }

    public void setLocation(ResourceLocation location) {
        this.location = location;
    }

    public DungeonModel setId(int id) {
        DungeonModels.MODELS.put(id, this);
        this.id = id;
        return this;
    }

    public void loadMetadata(Metadata metadata) {
        this.metadata = metadata;
        this.id = metadata.id;
        DungeonModels.MODELS.put(this.id, this);
        if (metadata.type != null) {
            metadata.type.members.add(this);
        }
        if (metadata.offset != null) {
            DungeonModels.OFFSETS.put(this.id, metadata.offset);
        }
        if (metadata.treasureType != null) {
            Treasure.MODEL_TREASURE_TYPES.put(this.id, metadata.treasureType);
        }
        if (metadata.size != null) {
            metadata.size.members.add(this);
        }
        if (metadata.stages != null) {
            for (int stage : metadata.stages) {
                DungeonModels.ModelCategory.getCategoryForStage((int)(stage - 1)).members.add(this);
            }
        }
        if (metadata.multipartData != null) {
            this.multipartData = metadata.multipartData;
        }
    }

    public MutableBoundingBox createBoundingBox(int x, int y, int z, Rotation rotation) {
        switch (rotation) {
            case NONE: 
            case CLOCKWISE_180: {
                return new MutableBoundingBox(x, y, z, x + this.width, y + this.height, z + this.length);
            }
            case CLOCKWISE_90: 
            case COUNTERCLOCKWISE_90: {
                return new MutableBoundingBox(x, y, z, x + this.length, y + this.height, z + this.width);
            }
        }
        DungeonCrawl.LOGGER.warn("Unknown rotation: {}", (Object)rotation);
        return new MutableBoundingBox(x, y, z, x + this.width, y + this.height, z + this.length);
    }

    public MutableBoundingBox createBoundingBox(BlockPos origin, Rotation rotation) {
        switch (rotation) {
            case NONE: 
            case CLOCKWISE_180: {
                return new MutableBoundingBox(origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p(), origin.func_177958_n() + this.width, origin.func_177956_o() + this.height, origin.func_177952_p() + this.length);
            }
            case CLOCKWISE_90: 
            case COUNTERCLOCKWISE_90: {
                return new MutableBoundingBox(origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p(), origin.func_177958_n() + this.length, origin.func_177956_o() + this.height, origin.func_177952_p() + this.width);
            }
        }
        DungeonCrawl.LOGGER.warn("Unknown rotation: {}", (Object)rotation);
        return new MutableBoundingBox(origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p(), origin.func_177958_n() + this.width, origin.func_177956_o() + this.height, origin.func_177952_p() + this.length);
    }

    public String toString() {
        return "{" + this.id + (this.metadata != null ? ", " + (this.metadata.type != null ? this.metadata.type.toString() : "-") + (this.metadata.stages != null ? ", " + Arrays.toString(this.metadata.stages) : "") + "}" : "}");
    }

    public static class Metadata {
        public DungeonModels.ModelCategory type;
        public DungeonModels.ModelCategory size;
        public Integer id;
        public DungeonModelFeature feature;
        public DungeonModelFeature.Metadata featureMetadata;
        public Treasure.Type treasureType;
        public List<WeightedRandom<MultipartModelData>> multipartData;
        public boolean variation;
        public Vector3i offset;
        public int[] stages;
        public int[] weights;

        private Metadata(DungeonModels.ModelCategory type, DungeonModels.ModelCategory size, Integer id, DungeonModelFeature feature, DungeonModelFeature.Metadata featureMetadata, Vector3i offset, Treasure.Type treasureType, List<WeightedRandom<MultipartModelData>> multipartData, boolean variation, int[] stages, int[] weights) {
            this.type = type;
            this.size = size;
            this.id = id;
            this.feature = feature;
            this.featureMetadata = featureMetadata;
            this.offset = offset;
            this.multipartData = multipartData;
            this.treasureType = treasureType;
            this.variation = variation;
            this.stages = stages;
            this.weights = weights;
        }

        public static class Deserializer
        implements JsonDeserializer<Metadata> {
            public Metadata deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject object = json.getAsJsonObject();
                String modelType = object.get("type").getAsString();
                int id = object.get("id").getAsInt();
                DungeonModelFeature feature = null;
                DungeonModelFeature.Metadata featureMetadata = null;
                int[] stages = null;
                int[] weights = null;
                Vector3i offset = null;
                boolean variation = false;
                JsonObject data = null;
                Treasure.Type treasureType = null;
                ArrayList multipartData = null;
                if (object.has("data")) {
                    JsonArray array;
                    int size;
                    data = object.getAsJsonObject("data");
                    stages = data.has("stages") ? (int[])DungeonCrawl.GSON.fromJson(data.get("stages"), int[].class) : null;
                    weights = data.has("weights") ? (int[])DungeonCrawl.GSON.fromJson(data.get("weights"), int[].class) : null;
                    Vector3i vector3i = offset = data.has("offset") ? JSONUtils.getOffset(data.getAsJsonObject("offset")) : null;
                    if (data.has("feature")) {
                        JsonObject featureData = data.getAsJsonObject("feature");
                        feature = DungeonModelFeature.getFromName(featureData.get("type").getAsString());
                        featureMetadata = new DungeonModelFeature.Metadata(featureData);
                    }
                    if (data.has("variation")) {
                        variation = data.get("variation").getAsBoolean();
                    }
                    if (data.has("treasure_type")) {
                        try {
                            treasureType = Treasure.Type.valueOf(data.get("treasure_type").getAsString().toUpperCase(Locale.ROOT));
                        }
                        catch (IllegalArgumentException e) {
                            DungeonCrawl.LOGGER.error("Invalid treasure type {} for model {}", (Object)data.get("treasure_type"), (Object)id);
                            e.printStackTrace();
                        }
                    }
                    if (data.has("multipart") && (size = (array = data.getAsJsonArray("multipart")).size()) > 0) {
                        multipartData = new ArrayList();
                        for (int i = 0; i < size; ++i) {
                            JsonArray array1 = array.get(i).getAsJsonArray();
                            WeightedRandom.Builder builder = new WeightedRandom.Builder();
                            array1.forEach(element1 -> {
                                JsonObject object1 = element1.getAsJsonObject();
                                MultipartModelData multipartModelData = MultipartModelData.fromJson(object1);
                                builder.add(multipartModelData, JSONUtils.getWeightOrDefault(object1));
                                if (multipartModelData != MultipartModelData.EMPTY) {
                                    DungeonModels.REFERENCES_TO_UPDATE.add(multipartModelData);
                                }
                            });
                            multipartData.add(builder.build());
                        }
                    }
                }
                if (modelType.equalsIgnoreCase("node")) {
                    if (data != null) {
                        DungeonModels.ModelCategory size;
                        String sizeString = data.get("size").getAsString();
                        String typeString = data.get("type").getAsString();
                        if (sizeString.equals("large")) {
                            size = DungeonModels.ModelCategory.LARGE_NODE;
                        } else if (sizeString.equals("normal")) {
                            size = DungeonModels.ModelCategory.NORMAL_NODE;
                        } else {
                            throw new JsonParseException("Unknown node size \" " + sizeString + "\"");
                        }
                        return new Metadata(DungeonModels.ModelCategory.valueOf("NODE_" + typeString.toUpperCase(Locale.ROOT)), size, id, feature, featureMetadata, offset, treasureType, multipartData, variation, stages, weights);
                    }
                    throw new RuntimeException("Missing metadata for a node model. (ID: " + id + ")");
                }
                return new Metadata(Deserializer.getModelCategory(modelType), null, id, feature, featureMetadata, offset, treasureType, multipartData, variation, stages, weights);
            }

            @Nullable
            private static DungeonModels.ModelCategory getModelCategory(String name) {
                if (name.toLowerCase().equals("normal")) {
                    return null;
                }
                try {
                    return DungeonModels.ModelCategory.valueOf(name.toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException e) {
                    DungeonCrawl.LOGGER.warn("Unknown model type: {} ({})", (Object)name, (Object)name.toUpperCase(Locale.ROOT));
                    return null;
                }
            }
        }
    }

    public static class FeaturePosition {
        public Vector3i position;
        public Direction facing;

        public FeaturePosition(int x, int y, int z) {
            this.position = new Vector3i(x, y, z);
        }

        public FeaturePosition(int x, int y, int z, Direction facing) {
            this.position = new Vector3i(x, y, z);
            this.facing = facing;
        }

        public FeaturePosition rotate(Rotation rotation, DungeonModel model) {
            switch (rotation) {
                case CLOCKWISE_90: {
                    return new FeaturePosition(model.length - this.position.func_177952_p() - 1, this.position.func_177956_o(), this.position.func_177958_n(), Orientation.rotateY(this.facing));
                }
                case CLOCKWISE_180: {
                    return new FeaturePosition(model.width - this.position.func_177958_n() - 1, this.position.func_177956_o(), model.length - this.position.func_177952_p() - 1, Orientation.horizontalOpposite(this.facing));
                }
                case COUNTERCLOCKWISE_90: {
                    return new FeaturePosition(this.position.func_177952_p(), this.position.func_177956_o(), model.width - this.position.func_177958_n() - 1, Orientation.rotateYCCW(this.facing));
                }
            }
            return this;
        }

        public BlockPos blockPos(int x, int y, int z) {
            return new BlockPos(x + this.position.func_177958_n(), y + this.position.func_177956_o(), z + this.position.func_177952_p());
        }

        public BlockPos blockPos(int x, int y, int z, Rotation rotation, DungeonModel model) {
            switch (rotation) {
                case CLOCKWISE_90: {
                    return new BlockPos(x + model.length - this.position.func_177952_p() - 1, y + this.position.func_177956_o(), z + this.position.func_177958_n());
                }
                case CLOCKWISE_180: {
                    return new BlockPos(x + model.length - this.position.func_177952_p() - 1, y + this.position.func_177956_o(), z + model.width - this.position.func_177958_n() - 1);
                }
                case COUNTERCLOCKWISE_90: {
                    return new BlockPos(x + this.position.func_177952_p(), y + this.position.func_177956_o(), z + model.width - this.position.func_177958_n() - 1);
                }
            }
            return new BlockPos(x + this.position.func_177958_n(), y + this.position.func_177956_o(), z + this.position.func_177952_p());
        }

        public DirectionalBlockPos directionalBlockPos(int x, int y, int z, Rotation rotation, DungeonModel model) {
            switch (rotation) {
                case CLOCKWISE_90: {
                    return new DirectionalBlockPos(x + model.length - this.position.func_177952_p() - 1, y + this.position.func_177956_o(), z + this.position.func_177958_n(), Orientation.rotateY(this.facing));
                }
                case CLOCKWISE_180: {
                    return new DirectionalBlockPos(x + model.width - this.position.func_177958_n() - 1, y + this.position.func_177956_o(), z + model.length - this.position.func_177952_p() - 1, Orientation.horizontalOpposite(this.facing));
                }
                case COUNTERCLOCKWISE_90: {
                    return new DirectionalBlockPos(x + this.position.func_177952_p(), y + this.position.func_177956_o(), z + model.width - this.position.func_177958_n() - 1, Orientation.rotateYCCW(this.facing));
                }
            }
            return new DirectionalBlockPos(x + this.position.func_177958_n(), y + this.position.func_177956_o(), z + this.position.func_177952_p(), this.facing);
        }

        public DirectionalBlockPos directionalBlockPos(int x, int y, int z) {
            return new DirectionalBlockPos(x + this.position.func_177958_n(), y + this.position.func_177956_o(), z + this.position.func_177952_p(), this.facing);
        }

        public DirectionalBlockPos directionalBlockPos(int x, int y, int z, Direction facing) {
            return new DirectionalBlockPos(x + this.position.func_177958_n(), y + this.position.func_177956_o(), z + this.position.func_177952_p(), facing);
        }
    }
}

