/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.theme.Theme;

public class DungeonModelBlock {
    private static final Tuple<BlockState, Boolean> CAVE_AIR = DungeonModelBlock.tuple(DungeonBlocks.CAVE_AIR, false);
    public static HashMap<DungeonModelBlockType, DungeonModelBlockStateProvider> PROVIDERS = new HashMap();
    public DungeonModelBlockType type;
    public PropertyHolder[] properties;
    public Integer variation;
    public ResourceLocation resource;

    public DungeonModelBlock(DungeonModelBlockType type) {
        this.type = type;
    }

    public CompoundNBT getAsNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("type", this.type.toString());
        if (this.resource != null) {
            tag.func_74778_a("resourceName", this.resource.toString());
        }
        if (this.properties != null) {
            ListNBT properties = new ListNBT();
            for (PropertyHolder holder : this.properties) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74778_a("property", holder.property.func_177701_a());
                nbt.func_74778_a("value", holder.value.toString().toLowerCase(Locale.ROOT));
                properties.add((Object)nbt);
            }
            if (properties.size() > 0) {
                tag.func_218657_a("properties", (INBT)properties);
            }
        }
        if (this.variation != null) {
            tag.func_74768_a("variation", this.variation.intValue());
        }
        return tag;
    }

    public static DungeonModelBlock fromNBT(CompoundNBT nbt) {
        if (!nbt.func_74764_b("type")) {
            return null;
        }
        String type = nbt.func_74779_i("type");
        if (!DungeonModelBlockType.NAME_TO_TYPE.containsKey(type)) {
            DungeonCrawl.LOGGER.warn("Unknown model block type: {}", (Object)type);
            return null;
        }
        DungeonModelBlock block = new DungeonModelBlock(DungeonModelBlockType.NAME_TO_TYPE.get(type));
        if (nbt.func_74764_b("resourceName")) {
            block.resource = new ResourceLocation(nbt.func_74779_i("resourceName"));
        }
        if (nbt.func_74764_b("properties")) {
            ListNBT properties = nbt.func_150295_c("properties", 10);
            block.properties = new PropertyHolder[properties.size()];
            for (int i = 0; i < properties.size(); ++i) {
                CompoundNBT data = (CompoundNBT)properties.get(i);
                block.properties[i] = new PropertyHolder(data.func_74779_i("property"), data.func_74779_i("value"));
            }
        }
        if (nbt.func_74764_b("variation")) {
            block.variation = nbt.func_74762_e("variation");
        }
        return block;
    }

    public DungeonModelBlock loadDataFromState(BlockState state) {
        ArrayList properties = Lists.newArrayList();
        for (Property property : state.func_235904_r_()) {
            properties.add(new PropertyHolder(property, state.func_177229_b(property)));
        }
        this.properties = properties.toArray(new PropertyHolder[0]);
        if (this.type == DungeonModelBlockType.CARPET) {
            for (int i = 0; i < DungeonBlocks.CARPET.length; ++i) {
                if (state.func_177230_c() != DungeonBlocks.CARPET[i]) continue;
                this.variation = i;
            }
            this.resource = state.func_177230_c().getRegistryName();
        } else if (this.type == DungeonModelBlockType.OTHER) {
            this.resource = state.func_177230_c().getRegistryName();
        }
        return this;
    }

    public Tuple<BlockState, Boolean> create(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        boolean postProcessing = false;
        if (this.properties != null) {
            for (PropertyHolder holder : this.properties) {
                state = holder.apply(state);
                postProcessing = true;
            }
        }
        return DungeonModelBlock.tuple(state.rotate(world, pos, rotation), postProcessing);
    }

    public Tuple<BlockState, Boolean> create(BlockState state) {
        boolean postProcessing = false;
        if (this.properties != null) {
            for (PropertyHolder holder : this.properties) {
                state = holder.apply(state);
                postProcessing = true;
            }
        }
        return DungeonModelBlock.tuple(state, postProcessing);
    }

    public static void init() {
        PROVIDERS.put(DungeonModelBlockType.NONE, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> null);
        PROVIDERS.put(DungeonModelBlockType.CARPET, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> {
            Block b;
            Block block2 = b = block.variation != null && variation != null ? DungeonBlocks.CARPET[(block.variation + variation[block.variation]) % DungeonBlocks.CARPET.length] : (Block)ForgeRegistries.BLOCKS.getValue(block.resource);
            if (b == null) {
                b = DungeonBlocks.CARPET[rand.nextInt(DungeonBlocks.CARPET.length)];
            }
            return block.create(b.func_176223_P());
        });
        PROVIDERS.put(DungeonModelBlockType.BARREL, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(Blocks.field_222422_lK.func_176223_P(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.MATERIAL, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(subTheme.material.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.SOLID, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(theme.solid.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.NORMAL, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(theme.normal.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.NORMAL_2, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(theme.normal2.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.STAIRS, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(theme.stairs.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.SOLID_STAIRS, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(theme.solidStairs.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.MATERIAL_STAIRS, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(subTheme.stairs.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.SLAB, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(theme.slab.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.SOLID_SLAB, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(theme.solidSlab.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.WOODEN_SLAB, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(subTheme.slab.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.WOODEN_PRESSURE_PLATE, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(subTheme.pressurePlate.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.FENCE, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(subTheme.fence.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.FENCE_GATE, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(subTheme.fenceGate.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.WOODEN_BUTTON, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(subTheme.button.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.SKULL, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> {
            Tuple<BlockState, Boolean> skull = block.create(Blocks.field_196703_eM.func_176223_P(), world, pos, rotation);
            BlockState state = (BlockState)skull.func_76341_a();
            if (state.func_235901_b_((Property)BlockStateProperties.field_208138_am)) {
                int r = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208138_am);
                int add = rand.nextInt(3);
                if (rand.nextBoolean()) {
                    if ((r -= add) < 0) {
                        r += 16;
                    }
                } else {
                    r = (r + add) % 16;
                }
                state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208138_am, (Comparable)Integer.valueOf(r));
                return new Tuple((Object)state, skull.func_76340_b());
            }
            return skull;
        });
        PROVIDERS.put(DungeonModelBlockType.CHEST, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(DungeonBlocks.CHEST, world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.FLOOR, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(theme.floor.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.SPAWNER, (Boolean)Config.NO_SPAWNERS.get() != false ? (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> CAVE_AIR : (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> DungeonModelBlock.tuple(DungeonBlocks.SPAWNER, false));
        PROVIDERS.put(DungeonModelBlockType.TRAPDOOR, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(subTheme.trapDoor.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.PILLAR, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(subTheme.wallLog.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.DOOR, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(subTheme.door.get(), world, pos, rotation));
        PROVIDERS.put(DungeonModelBlockType.OTHER, (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> {
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(block.resource);
            if (b != null) {
                return block.create(b.func_176223_P(), world, pos, rotation);
            }
            DungeonCrawl.LOGGER.warn("Unknown block {}", (Object)block.resource.toString());
            return CAVE_AIR;
        });
    }

    public static Tuple<BlockState, Boolean> getBlockState(DungeonModelBlock block, Rotation rotation, IWorld world, BlockPos pos, Theme theme, Theme.SubTheme subTheme, Random rand, byte[] variation, int stage) {
        DungeonModelBlockStateProvider provider = PROVIDERS.get((Object)block.type);
        if (provider == null) {
            return DungeonModelBlock.tuple(Blocks.field_201941_jj.func_176223_P(), false);
        }
        return provider.get(block, rotation, world, pos, theme, subTheme, rand, variation, stage);
    }

    private static Tuple<BlockState, Boolean> tuple(BlockState state, boolean postProcessing) {
        return new Tuple((Object)state, (Object)postProcessing);
    }

    private static class PropertyHolder {
        public String propertyName;
        public String valueName;
        public Property<?> property;
        public Object value;

        public PropertyHolder(String propertyName, String valueName) {
            this.propertyName = propertyName;
            this.valueName = valueName;
        }

        public PropertyHolder(Property<?> property, Object value) {
            this.property = property;
            this.value = value;
        }

        public <T extends Comparable<T>> BlockState apply(BlockState state) {
            if (this.property == null) {
                for (Property p : state.func_235904_r_()) {
                    if (!p.func_177701_a().equals(this.propertyName)) continue;
                    this.property = p;
                    Optional optional = p.func_185929_b(this.valueName);
                    if (optional.isPresent()) {
                        this.value = optional.get();
                        continue;
                    }
                    DungeonCrawl.LOGGER.error("Couldn't parse property {} with value {}", (Object)p.func_177701_a(), (Object)this.valueName);
                }
            }
            if (state.func_235901_b_(this.property)) {
                return (BlockState)state.func_206870_a(this.property, (Comparable)this.value);
            }
            return state;
        }
    }

    @FunctionalInterface
    public static interface DungeonModelBlockStateProvider {
        public Tuple<BlockState, Boolean> get(DungeonModelBlock var1, Rotation var2, IWorld var3, BlockPos var4, Theme var5, Theme.SubTheme var6, Random var7, byte[] var8, int var9);
    }
}

