/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import java.util.Hashtable;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.model.ModelBlockDefinition;
import xiroc.dungeoncrawl.dungeon.model.PlacementBehaviour;

public enum DungeonModelBlockType {
    NONE,
    SOLID_STAIRS(PlacementBehaviour.SOLID),
    SOLID(PlacementBehaviour.SOLID),
    NORMAL,
    NORMAL_2(PlacementBehaviour.SOLID),
    PILLAR,
    FLOOR(PlacementBehaviour.RANDOM_IF_SOLID_NEARBY),
    MATERIAL_STAIRS,
    STAIRS,
    SPAWNER,
    CHEST,
    TRAPDOOR,
    SLAB,
    SOLID_SLAB(PlacementBehaviour.SOLID),
    BARREL,
    DOOR,
    FENCE,
    FENCE_GATE,
    WOODEN_SLAB,
    WOODEN_BUTTON,
    WOODEN_PRESSURE_PLATE,
    VANILLA_WALL,
    MATERIAL,
    SKULL,
    CARPET,
    OTHER;

    public final PlacementBehaviour placementBehavior;
    public static final Hashtable<String, DungeonModelBlockType> NAME_TO_TYPE;

    private DungeonModelBlockType() {
        this(PlacementBehaviour.NON_SOLID);
    }

    private DungeonModelBlockType(PlacementBehaviour placementBehavior) {
        this.placementBehavior = placementBehavior;
    }

    public boolean isSolid(IWorld world, BlockPos pos, Random rand, int relativeX, int relativeY, int relativeZ) {
        return (Boolean)Config.SOLID.get() != false || this.placementBehavior.function.isSolid(world, pos, rand, relativeX, relativeY, relativeZ);
    }

    public static DungeonModelBlockType get(Block block, ModelBlockDefinition definition) {
        if (definition.definition.containsKey(block)) {
            return definition.definition.get(block);
        }
        if (definition.fallback != null && definition.fallback.definition.containsKey(block)) {
            return definition.fallback.definition.get(block);
        }
        if (BlockTags.field_200028_e.func_230235_a_((Object)block)) {
            return CARPET;
        }
        return OTHER;
    }

    public static void buildNameTable() {
        for (DungeonModelBlockType type : DungeonModelBlockType.values()) {
            NAME_TO_TYPE.put(type.name(), type);
        }
    }

    static {
        NAME_TO_TYPE = new Hashtable();
    }
}

