/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.util.DirectionalBlockPos;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;
import xiroc.dungeoncrawl.util.Orientation;

public interface DungeonModelFeature {
    public static final HashMap<String, DungeonModelFeature> FEATURES = new HashMap();
    public static final DungeonModelFeature CHESTS = (world, rand, pos, positions, bounds, theme, subTheme, stage) -> {
        for (DirectionalBlockPos position : positions) {
            if (!bounds.func_175898_b((Vector3i)position.position) || !world.func_180495_p(position.position.func_177977_b()).func_200132_m()) continue;
            IBlockPlacementHandler.CHEST.placeBlock(world, (BlockState)DungeonBlocks.CHEST.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)position.direction), position.position, rand, Treasure.Type.DEFAULT, theme, stage);
        }
    };
    public static final DungeonModelFeature TNT_CHESTS = (world, rand, pos, positions, bounds, theme, subTheme, stage) -> {
        for (DirectionalBlockPos position : positions) {
            if (!bounds.func_175898_b((Vector3i)position.position) || !world.func_180495_p(position.position.func_177977_b()).func_200132_m()) continue;
            IBlockPlacementHandler.CHEST.placeBlock(world, (BlockState)Blocks.field_150447_bR.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Orientation.RANDOM_FACING_FLAT.roll(rand)), position.position, rand, Treasure.Type.DEFAULT, theme, stage);
            if (world.func_175623_d(position.position.func_177979_c(2))) continue;
            world.func_180501_a(position.position.func_177979_c(2), Blocks.field_150335_W.func_176223_P(), 2);
        }
    };
    public static final DungeonModelFeature SPAWNERS = (world, rand, pos, positions, bounds, theme, subTheme, stage) -> {
        if (((Boolean)Config.NO_SPAWNERS.get()).booleanValue()) {
            return;
        }
        for (DirectionalBlockPos position : positions) {
            if (!bounds.func_175898_b((Vector3i)position.position) || !world.func_180495_p(position.position.func_177977_b()).func_200132_m()) continue;
            IBlockPlacementHandler.SPAWNER.placeBlock(world, DungeonBlocks.SPAWNER, position.position, rand, null, theme, stage);
        }
    };
    public static final DungeonModelFeature CATACOMB = (world, rand, pos, positions, bounds, theme, subTheme, stage) -> {
        for (DirectionalBlockPos position : positions) {
            if (bounds.func_175898_b((Vector3i)position.position) && world.func_180495_p(position.position.func_177977_b()).func_200132_m()) {
                IBlockPlacementHandler.CHEST.placeBlock(world, (BlockState)DungeonBlocks.CHEST.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)position.direction), position.position, rand, Treasure.Type.CATACOMB, theme, stage);
            }
            if (((Boolean)Config.NO_SPAWNERS.get()).booleanValue()) {
                return;
            }
            BlockPos spawner = position.position.func_177972_a(position.direction);
            if (!bounds.func_175898_b((Vector3i)spawner) || !world.func_180495_p(spawner.func_177977_b()).func_200132_m()) continue;
            IBlockPlacementHandler.SPAWNER.placeBlock(world, DungeonBlocks.SPAWNER, spawner, rand, null, theme, stage);
        }
    };

    public void build(IWorld var1, Random var2, BlockPos var3, DirectionalBlockPos[] var4, MutableBoundingBox var5, int var6, int var7, int var8);

    public static void setup(DungeonPiece piece, DungeonModel model, DungeonModel.FeaturePosition[] featurePositions, Rotation rotation, Random rand, Metadata metadata, int x, int y, int z) {
        int i;
        piece.featurePositions = new DirectionalBlockPos[new RandomValueRange((float)metadata.min, (float)Math.min(metadata.max, featurePositions.length)).func_186511_a(rand)];
        int[] checkArray = new int[featurePositions.length];
        for (i = 0; i < checkArray.length; ++i) {
            checkArray[i] = i;
        }
        for (i = 0; i < piece.featurePositions.length; ++i) {
            int a = rand.nextInt(featurePositions.length);
            while (checkArray[a] != a) {
                a = checkArray[a];
            }
            checkArray[a] = (a + 1) % checkArray.length;
            piece.featurePositions[i] = featurePositions[a].directionalBlockPos(x, y, z, rotation, model);
        }
    }

    public static void init() {
        FEATURES.put("chests", CHESTS);
        FEATURES.put("tnt_chests", TNT_CHESTS);
        FEATURES.put("spawners", SPAWNERS);
        FEATURES.put("catacomb", CATACOMB);
    }

    public static DungeonModelFeature getFromName(String name) {
        DungeonModelFeature feature = FEATURES.get(name.toLowerCase());
        if (feature != null) {
            return feature;
        }
        throw new IllegalArgumentException("Unknown model feature: " + name);
    }

    public static class Metadata {
        public final int min;
        public final int max;

        public Metadata(JsonObject object) {
            this.min = object.get("min").getAsInt();
            this.max = object.get("max").getAsInt();
        }
    }
}

