/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3i;
import org.jline.utils.InputStreamReader;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.ModelHandler;
import xiroc.dungeoncrawl.dungeon.model.MultipartModelData;
import xiroc.dungeoncrawl.util.WeightedIntegerEntry;
import xiroc.dungeoncrawl.util.WeightedRandomInteger;

public class DungeonModels {
    public static final HashMap<Integer, DungeonModel> MODELS = new HashMap();
    public static final HashMap<String, DungeonModel> PATH_TO_MODEL = new HashMap();
    public static final HashMap<Integer, WeightedRandomInteger> WEIGHTED_MODELS = new HashMap();
    public static final HashMap<String, DungeonModel> NAME_TO_MODEL = (Boolean)Config.ENABLE_TOOLS.get() != false ? new HashMap() : null;
    public static final HashMap<Integer, Vector3i> OFFSETS = new HashMap();
    public static final Vector3i NO_OFFSET = new Vector3i(0, 0, 0);
    public static final ArrayList<MultipartModelData> REFERENCES_TO_UPDATE = new ArrayList();
    public static DungeonModel CORRIDOR;
    public static DungeonModel CORRIDOR_2;
    public static DungeonModel CORRIDOR_3;
    public static DungeonModel CORRIDOR_STONE;
    public static DungeonModel CORRIDOR_ROOM;
    public static DungeonModel CORRIDOR_SECRET_ROOM_ENTRANCE;
    public static DungeonModel ENTRANCE;
    public static DungeonModel FOOD_SIDE_ROOM;
    public static DungeonModel LARGE_CORRIDOR_START;
    public static DungeonModel LARGE_CORRIDOR_STRAIGHT;
    public static DungeonModel LARGE_CORRIDOR_OPEN;
    public static DungeonModel LARGE_CORRIDOR_TURN;
    public static DungeonModel LOOT_ROOM;
    public static DungeonModel OLD_LOOT_ROOM;
    public static DungeonModel PRISON_CELL;
    public static DungeonModel SECRET_ROOM;
    public static DungeonModel STAIRCASE;
    public static DungeonModel STAIRS_BOTTOM;
    public static DungeonModel STAIRS_BOTTOM_2;
    public static DungeonModel STAIRS_TOP;
    public static DungeonModel STARTER_ROOM;

    public static synchronized void load(IResourceManager resourceManager) {
        REFERENCES_TO_UPDATE.clear();
        MODELS.clear();
        PATH_TO_MODEL.clear();
        WEIGHTED_MODELS.clear();
        OFFSETS.clear();
        ModelCategory.clear();
        LARGE_CORRIDOR_START = DungeonModels.loadModel("models/dungeon/corridor/large_corridor_start.nbt", resourceManager).setId(28);
        LARGE_CORRIDOR_STRAIGHT = DungeonModels.loadModel("models/dungeon/corridor/large_corridor_straight.nbt", resourceManager).setId(29);
        LARGE_CORRIDOR_TURN = DungeonModels.loadModel("models/dungeon/corridor/large_corridor_turn.nbt", resourceManager).setId(30);
        LARGE_CORRIDOR_OPEN = DungeonModels.loadModel("models/dungeon/corridor/large_corridor_open.nbt", resourceManager).setId(31);
        OLD_LOOT_ROOM = DungeonModels.loadModel("models/dungeon/old_loot_room.nbt", resourceManager).setId(35);
        DungeonModels.loadModel("models/dungeon/corridor/old_corridor_secret_room_entrance.nbt", resourceManager).setId(7);
        PRISON_CELL = DungeonModels.loadModel("models/dungeon/prison_cell.nbt", resourceManager).setId(64);
        STAIRCASE = DungeonModels.loadModel("models/dungeon/staircase.nbt", resourceManager).setId(72);
        STAIRS_TOP = DungeonModels.loadModel("models/dungeon/stairs_top.nbt", resourceManager).setId(73);
        STAIRS_BOTTOM = DungeonModels.loadModel("models/dungeon/stairs_bottom.nbt", resourceManager).setId(74);
        STAIRS_BOTTOM_2 = DungeonModels.loadModel("models/dungeon/stairs_bottom_2.nbt", resourceManager).setId(75);
        FOOD_SIDE_ROOM = DungeonModels.load("models/dungeon/room/", "food_side_room", resourceManager);
        ENTRANCE = DungeonModels.load("models/dungeon/entrance/", "roguelike_entrance", resourceManager);
        LOOT_ROOM = DungeonModels.load("models/dungeon/", "loot_room", resourceManager);
        SECRET_ROOM = DungeonModels.load("models/dungeon/room/", "secret_room", resourceManager);
        STARTER_ROOM = DungeonModels.load("models/dungeon/room/", "starter_room", resourceManager);
        DungeonModels.load("models/dungeon/room/", "tnt_trap_side_room", resourceManager);
        DungeonModels.load("models/dungeon/corridor/", "corridor", resourceManager);
        DungeonModels.load("models/dungeon/corridor/", "corridor_2", resourceManager);
        DungeonModels.load("models/dungeon/corridor/", "corridor_3", resourceManager);
        DungeonModels.load("models/dungeon/corridor/", "old_corridor", resourceManager);
        DungeonModels.load("models/dungeon/corridor/", "old_corridor_3", resourceManager);
        DungeonModels.load("models/dungeon/corridor/", "stone_corridor", resourceManager);
        DungeonModels.load("models/dungeon/corridor/", "corridor_room", resourceManager);
        DungeonModels.load("models/dungeon/corridor/", "corridor_fire", resourceManager);
        DungeonModels.load("models/dungeon/corridor/", "corridor_spawner", resourceManager);
        DungeonModels.load("models/dungeon/corridor/", "corridor_light", resourceManager);
        CORRIDOR_SECRET_ROOM_ENTRANCE = DungeonModels.load("models/dungeon/corridor/", "corridor_secret_room_entrance", resourceManager);
        DungeonModels.load("models/dungeon/corridor/dark/", "corridor", resourceManager);
        DungeonModels.load("models/dungeon/corridor/dark/", "corridor_2", resourceManager);
        DungeonModels.load("models/dungeon/corridor/dark/", "corridor_3", resourceManager);
        DungeonModels.load("models/dungeon/corridor/dark/", "corridor_4", resourceManager);
        DungeonModels.load("models/dungeon/corridor/dark/", "corridor_spawner", resourceManager);
        DungeonModels.load("models/dungeon/corridor/linker/", "cake_room", resourceManager);
        DungeonModels.load("models/dungeon/corridor/linker/", "corridor_linker", resourceManager);
        DungeonModels.load("models/dungeon/corridor/linker/", "corridor_linker_2", resourceManager);
        DungeonModels.load("models/dungeon/corridor/linker/", "corridor_linker_3", resourceManager);
        DungeonModels.load("models/dungeon/corridor/linker/", "corridor_linker_4", resourceManager);
        DungeonModels.load("models/dungeon/corridor/linker/", "corridor_linker_5", resourceManager);
        DungeonModels.load("models/dungeon/node/", "forge", resourceManager);
        DungeonModels.load("models/dungeon/node/", "node", resourceManager);
        DungeonModels.load("models/dungeon/node/", "node_jukebox", resourceManager);
        DungeonModels.load("models/dungeon/node/", "node_fork", resourceManager);
        DungeonModels.load("models/dungeon/node/", "node_catacomb_dead_end", resourceManager);
        DungeonModels.load("models/dungeon/node/", "node_catacomb_turn", resourceManager);
        DungeonModels.load("models/dungeon/node/", "node_turn", resourceManager);
        DungeonModels.load("models/dungeon/node/", "node_water", resourceManager);
        DungeonModels.load("models/dungeon/node/", "node_water_2", resourceManager);
        DungeonModels.load("models/dungeon/node/", "node_water_dead_end", resourceManager);
        DungeonModels.load("models/dungeon/node/", "node_water_fork", resourceManager);
        DungeonModels.load("models/dungeon/node/", "node_water_straight", resourceManager);
        DungeonModels.load("models/dungeon/node/", "node_prison_fork", resourceManager);
        DungeonModels.load("models/dungeon/node/", "node_prison", resourceManager);
        DungeonModels.load("models/dungeon/node/", "large_node", resourceManager);
        DungeonModels.load("models/dungeon/node/", "large_node_library", resourceManager);
        DungeonModels.load("models/dungeon/node/dark/", "node_lava", resourceManager);
        DungeonModels.load("models/dungeon/node/dark/", "node_lava_2", resourceManager);
        DungeonModels.load("models/dungeon/node/connector/", "node_connector", resourceManager);
        DungeonModels.load("models/dungeon/node/connector/", "node_connector_2", resourceManager);
        DungeonModels.load("models/dungeon/node/connector/", "node_connector_3", resourceManager);
        DungeonModels.load("models/dungeon/node/connector/", "node_connector_4", resourceManager);
        DungeonModels.load("models/dungeon/node/connector/", "node_connector_5", resourceManager);
        DungeonModels.load("models/dungeon/node/connector/", "node_connector_catacomb", resourceManager);
        DungeonModels.load("models/dungeon/node/connector/", "node_connector_basic", resourceManager);
        DungeonModels.load("models/dungeon/room/", "spawner_room", resourceManager);
        DungeonModels.load("models/dungeon/room/", "spawner_room_2", resourceManager);
        DungeonModels.load("models/dungeon/room/", "spawner_room_material", resourceManager);
        DungeonModels.load("models/dungeon/room/", "spawner_room_material_2", resourceManager);
        DungeonModels.load("models/dungeon/room/dark/", "spawner_room", resourceManager);
        DungeonModels.load("models/dungeon/corridor/multipart/", "corridor_default", resourceManager);
        DungeonModels.load("models/dungeon/corridor/multipart/", "corridor_variant", resourceManager);
        DungeonModels.load("models/dungeon/corridor/multipart/", "corridor_variant_2", resourceManager);
        DungeonModels.load("models/dungeon/corridor/multipart/", "corridor_crops", resourceManager);
        DungeonModels.load("models/dungeon/corridor/multipart/", "corridor_chest", resourceManager);
        DungeonModels.load("models/dungeon/corridor/multipart/", "corridor_spawner", resourceManager);
        DungeonModels.load("models/dungeon/corridor/multipart/", "corridor_light", resourceManager);
        DungeonModels.load("models/dungeon/corridor/multipart/", "corridor_light_switch", resourceManager);
        DungeonModels.load("models/dungeon/corridor/multipart/", "corridor_bookshelf", resourceManager);
        resourceManager.func_199003_a(DungeonCrawl.locate("models/dungeon/additional").func_110623_a(), s -> s.endsWith(".nbt")).forEach(resource -> {
            DungeonCrawl.LOGGER.debug("Additional resource: {}", (Object)resource.toString());
            DungeonModel model = DungeonModels.loadModel(resource, resourceManager);
            ResourceLocation metadata = new ResourceLocation(resource.func_110624_b(), resource.func_110623_a().substring(0, resource.func_110623_a().indexOf(".nbt")) + ".json");
            DungeonCrawl.LOGGER.debug("Looking for metadata file {}", (Object)metadata.toString());
            if (resourceManager.func_219533_b(metadata)) {
                DungeonCrawl.LOGGER.debug("Loading metadata for {}", (Object)resource.func_110623_a());
                try {
                    DungeonModel.Metadata data = (DungeonModel.Metadata)DungeonCrawl.GSON.fromJson((Reader)new InputStreamReader(resourceManager.func_199002_a(metadata).func_199027_b()), DungeonModel.Metadata.class);
                    model.loadMetadata(data);
                }
                catch (Exception e) {
                    DungeonCrawl.LOGGER.error("Failed to load metadata for {}", (Object)resource.func_110623_a());
                    e.printStackTrace();
                }
            } else {
                DungeonCrawl.LOGGER.warn("Missing metadata for {}", (Object)resource.func_110623_a());
            }
        });
        REFERENCES_TO_UPDATE.forEach(MultipartModelData::updateReference);
        HashMap<Integer, DungeonModel[]> tempMap = new HashMap<Integer, DungeonModel[]>();
        for (int i = 0; i < 5; ++i) {
            ModelCategory stage = ModelCategory.STAGES[i];
            for (ModelCategory nodeType : ModelCategory.NODE_TYPES) {
                WeightedRandomInteger.Builder builder = new WeightedRandomInteger.Builder();
                ModelCategory[] category = new ModelCategory[]{ModelCategory.NORMAL_NODE, stage, nodeType};
                for (DungeonModel dungeonModel : ModelCategory.getIntersection(tempMap, category)) {
                    builder.entries.add(new WeightedIntegerEntry(dungeonModel.metadata.weights[i], dungeonModel.id));
                }
                for (ModelCategory modelCategory : ModelCategory.getSecondaryNodeCategories(nodeType)) {
                    for (DungeonModel model : ModelCategory.getIntersection(tempMap, ModelCategory.NORMAL_NODE, stage, modelCategory)) {
                        builder.entries.add(new WeightedIntegerEntry(1, model.id));
                    }
                }
                WEIGHTED_MODELS.put(Arrays.hashCode((Object[])category), builder.build());
                builder = new WeightedRandomInteger.Builder();
                category = new ModelCategory[]{ModelCategory.LARGE_NODE, stage, nodeType};
                for (DungeonModel dungeonModel : ModelCategory.getIntersection(tempMap, category)) {
                    builder.entries.add(new WeightedIntegerEntry(dungeonModel.metadata.weights[i], dungeonModel.id));
                }
                for (ModelCategory modelCategory : ModelCategory.getSecondaryNodeCategories(nodeType)) {
                    for (DungeonModel model : ModelCategory.getIntersection(tempMap, ModelCategory.LARGE_NODE, stage, modelCategory)) {
                        builder.entries.add(new WeightedIntegerEntry(1, model.id));
                    }
                }
                WEIGHTED_MODELS.put(Arrays.hashCode((Object[])category), builder.build());
            }
            DungeonModels.createWeightedRandomIntegers(tempMap, ModelCategory.CORRIDOR, stage, i);
            DungeonModels.createWeightedRandomIntegers(tempMap, ModelCategory.CORRIDOR_LINKER, stage, i);
            DungeonModels.createWeightedRandomIntegers(tempMap, ModelCategory.NODE_CONNECTOR, stage, i);
            DungeonModels.createWeightedRandomIntegers(tempMap, ModelCategory.SIDE_ROOM, stage, i);
            DungeonModels.createWeightedRandomIntegers(tempMap, ModelCategory.ROOM, stage, i);
        }
        ModelCategory.CORRIDOR.requirePresentModels(0, 1, 2, 3, 4);
        ModelCategory.CORRIDOR_LINKER.requirePresentModels(0, 1, 2, 3, 4);
        ModelCategory.NODE_CONNECTOR.requirePresentModels(0, 1, 2, 3, 4);
        ModelCategory.ROOM.requirePresentModels(0, 1, 2, 3, 4);
        ModelCategory.NORMAL_NODE.requirePresentModels(ModelCategory.NODE_FULL, 0, 1, 2, 3, 4);
        ModelCategory.NORMAL_NODE.requirePresentModels(ModelCategory.NODE_FORK, 0, 1, 2, 3, 4);
        ModelCategory.NORMAL_NODE.requirePresentModels(ModelCategory.NODE_STRAIGHT, 0, 1, 2, 3, 4);
        ModelCategory.NORMAL_NODE.requirePresentModels(ModelCategory.NODE_TURN, 0, 1, 2, 3, 4);
        ModelCategory.NORMAL_NODE.requirePresentModels(ModelCategory.NODE_DEAD_END, 0, 1, 2, 3, 4);
        ModelCategory.LARGE_NODE.requirePresentModels(ModelCategory.NODE_FULL, 2, 3, 4);
        ModelCategory.LARGE_NODE.requirePresentModels(ModelCategory.NODE_FORK, 2, 3, 4);
        ModelCategory.LARGE_NODE.requirePresentModels(ModelCategory.NODE_STRAIGHT, 2, 3, 4);
        ModelCategory.LARGE_NODE.requirePresentModels(ModelCategory.NODE_TURN, 2, 3, 4);
        ModelCategory.LARGE_NODE.requirePresentModels(ModelCategory.NODE_DEAD_END, 2, 3, 4);
    }

    public static DungeonModel load(String directory, String file, IResourceManager resourceManager) {
        DungeonModel model = DungeonModels.loadModel(directory + file + ".nbt", resourceManager);
        ResourceLocation metadata = DungeonCrawl.locate(directory + file + ".json");
        if (resourceManager.func_219533_b(metadata)) {
            try {
                DungeonModel.Metadata data = (DungeonModel.Metadata)DungeonCrawl.GSON.fromJson((Reader)new InputStreamReader(resourceManager.func_199002_a(metadata).func_199027_b()), DungeonModel.Metadata.class);
                model.loadMetadata(data);
            }
            catch (Exception e) {
                DungeonCrawl.LOGGER.error("Failed to load metadata for {}", (Object)file);
                e.printStackTrace();
            }
        }
        return model;
    }

    public static DungeonModel loadModel(String path, IResourceManager resourceManager) {
        DungeonCrawl.LOGGER.debug("Loading {}", (Object)path);
        try {
            DataInputStream input = new DataInputStream(resourceManager.func_199002_a(DungeonCrawl.locate(path)).func_199027_b());
            CompoundNBT nbt = (CompoundNBT)CompoundNBT.field_229675_a_.func_225649_b_((DataInput)input, 16, NBTSizeTracker.field_152451_a);
            ResourceLocation resource = DungeonCrawl.locate(path);
            DungeonModel model = ModelHandler.getModelFromNBT(nbt);
            String key = path.substring("models/dungeon/".length(), path.indexOf(".nbt"));
            PATH_TO_MODEL.put(key, model);
            DungeonCrawl.LOGGER.debug("Model {} has key: {}", (Object)path, (Object)key);
            model.setLocation(resource);
            return model;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to load " + path);
        }
    }

    public static DungeonModel loadModel(ResourceLocation resource, IResourceManager resourceManager) {
        DungeonCrawl.LOGGER.debug("Loading {}", (Object)resource.func_110623_a());
        try {
            DataInputStream input = new DataInputStream(resourceManager.func_199002_a(resource).func_199027_b());
            CompoundNBT nbt = (CompoundNBT)CompoundNBT.field_229675_a_.func_225649_b_((DataInput)input, 16, NBTSizeTracker.field_152451_a);
            DungeonModel model = ModelHandler.getModelFromNBT(nbt);
            String path = resource.func_110623_a();
            String key = path.substring("models/dungeon/".length(), path.indexOf(".nbt"));
            PATH_TO_MODEL.put(key, model);
            DungeonCrawl.LOGGER.debug("Model {} has key (2): {}", (Object)path, (Object)key);
            model.setLocation(resource);
            return model;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to load " + resource.func_110623_a());
        }
    }

    private static void createWeightedRandomIntegers(HashMap<Integer, DungeonModel[]> tempMap, ModelCategory baseCategory, ModelCategory stageCategory, int stage) {
        WeightedRandomInteger.Builder builder = new WeightedRandomInteger.Builder();
        ModelCategory[] categories = new ModelCategory[]{baseCategory, stageCategory};
        for (DungeonModel model : ModelCategory.getIntersection(tempMap, categories)) {
            builder.entries.add(new WeightedIntegerEntry(model.metadata.weights[stage], model.id));
        }
        WEIGHTED_MODELS.put(Arrays.hashCode((Object[])categories), builder.build());
    }

    public static Vector3i getOffset(int model) {
        return OFFSETS.getOrDefault(model, NO_OFFSET);
    }

    public static enum ModelCategory {
        STAGE_1,
        STAGE_2,
        STAGE_3,
        STAGE_4,
        STAGE_5,
        NODE_DEAD_END,
        NODE_STRAIGHT,
        NODE_TURN,
        NODE_FORK,
        NODE_FULL,
        NORMAL_NODE,
        LARGE_NODE,
        CORRIDOR,
        CORRIDOR_LINKER,
        NODE_CONNECTOR,
        ENTRANCE,
        SIDE_ROOM,
        ROOM;

        public static final ModelCategory[] STAGES;
        public static final ModelCategory[] NODE_TYPES;
        public static final ModelCategory[] EMPTY;
        public final List<DungeonModel> members = Lists.newArrayList();

        public void requirePresentModels(int ... stages) {
            for (int stage : stages) {
                int hashCode = 1;
                hashCode = 31 * hashCode + this.hashCode();
                if (WEIGHTED_MODELS.containsKey(hashCode = 31 * hashCode + ModelCategory.getCategoryForStage(stage).hashCode()) && DungeonModels.WEIGHTED_MODELS.get((Object)Integer.valueOf((int)hashCode)).integers.length != 0) continue;
                throw new RuntimeException("There is no present " + (Object)((Object)this) + " model for stage " + (stage + 1));
            }
        }

        public void requirePresentModels(ModelCategory secondaryCategory, int ... stages) {
            for (int stage : stages) {
                int hashCode = 1;
                hashCode = 31 * hashCode + this.hashCode();
                hashCode = 31 * hashCode + ModelCategory.getCategoryForStage(stage).hashCode();
                if (WEIGHTED_MODELS.containsKey(hashCode = 31 * hashCode + secondaryCategory.hashCode()) && DungeonModels.WEIGHTED_MODELS.get((Object)Integer.valueOf((int)hashCode)).integers.length != 0) continue;
                throw new RuntimeException("There is no present " + (Object)((Object)this) + "(" + (Object)((Object)secondaryCategory) + ") model for stage " + (stage + 1));
            }
        }

        public static void clear() {
            for (ModelCategory category : ModelCategory.values()) {
                category.members.clear();
            }
        }

        public static WeightedRandomInteger get(ModelCategory ... categories) {
            int hash = Arrays.hashCode((Object[])categories);
            return WEIGHTED_MODELS.get(hash);
        }

        public static DungeonModel[] getIntersection(HashMap<Integer, DungeonModel[]> map, ModelCategory ... categories) {
            int hash = Arrays.hashCode((Object[])categories);
            if (map.containsKey(hash)) {
                return map.get(hash);
            }
            ArrayList intersection = Lists.newArrayList();
            block0: for (DungeonModel model : categories[0].members) {
                for (int i = 1; i < categories.length; ++i) {
                    if (!categories[i].members.contains(model)) continue block0;
                }
                intersection.add(model);
            }
            DungeonModel[] array = intersection.toArray(new DungeonModel[0]);
            map.put(hash, array);
            return array;
        }

        public static ModelCategory[] getSecondaryNodeCategories(ModelCategory primeCategory) {
            switch (primeCategory) {
                case NODE_DEAD_END: {
                    return new ModelCategory[]{NODE_TURN, NODE_STRAIGHT, NODE_FORK, NODE_FULL};
                }
                case NODE_FORK: {
                    return new ModelCategory[]{NODE_FULL};
                }
                case NODE_STRAIGHT: 
                case NODE_TURN: {
                    return new ModelCategory[]{NODE_FULL, NODE_FORK};
                }
            }
            return EMPTY;
        }

        public static ModelCategory getCategoryForStage(int stage) {
            if (stage < 0) {
                return STAGE_1;
            }
            if (stage > 4) {
                return STAGE_5;
            }
            return STAGES[stage];
        }

        static {
            STAGES = new ModelCategory[]{STAGE_1, STAGE_2, STAGE_3, STAGE_4, STAGE_5};
            NODE_TYPES = new ModelCategory[]{NODE_FULL, NODE_FORK, NODE_STRAIGHT, NODE_TURN, NODE_DEAD_END};
            EMPTY = new ModelCategory[0];
        }
    }
}

