/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;

public class ModelBlockDefinition {
    private static final String PATH = "block_definitions";
    public static final Hashtable<String, ModelBlockDefinition> DEFINITIONS = new Hashtable();
    private static final HashMap<Block, DungeonModelBlockType> DEFAULT = new HashMap();
    public static final ModelBlockDefinition DEFAULT_DEFINITION;
    public ModelBlockDefinition fallback;
    public HashMap<Block, DungeonModelBlockType> definition;
    public HashMap<DungeonModelBlockType, Block> invertedDefinition;

    public ModelBlockDefinition(HashMap<Block, DungeonModelBlockType> definition) {
        this.definition = definition;
        this.invertedDefinition = new HashMap();
        this.definition.forEach((block, type) -> this.invertedDefinition.put((DungeonModelBlockType)((Object)type), (Block)block));
    }

    @Nullable
    public Block getBlock(DungeonModelBlock block) {
        if (block.type == DungeonModelBlockType.OTHER) {
            return (Block)ForgeRegistries.BLOCKS.getValue(block.resource);
        }
        if (block.type == DungeonModelBlockType.CARPET) {
            return DungeonBlocks.CARPET[block.variation];
        }
        if (this.invertedDefinition.containsKey((Object)block.type)) {
            return this.invertedDefinition.get((Object)block.type);
        }
        if (this.fallback != null && this.fallback.invertedDefinition.containsKey((Object)block.type)) {
            return this.fallback.invertedDefinition.get((Object)block.type);
        }
        return Blocks.field_150350_a;
    }

    public static void loadJson(IResourceManager resourceManager) {
        ArrayList referencesToUpdate = Lists.newArrayList();
        resourceManager.func_199003_a(PATH, s -> s.endsWith(".json")).forEach(resource -> ModelBlockDefinition.loadDefinition(resourceManager, resource, referencesToUpdate));
        for (Tuple reference : referencesToUpdate) {
            String key = (String)reference.func_76340_b();
            if (DEFINITIONS.containsKey(key)) {
                ((ModelBlockDefinition)reference.func_76341_a()).fallback = DEFINITIONS.get(key);
                continue;
            }
            DungeonCrawl.LOGGER.warn("Unknown fallback model block definition: {}", (Object)key);
        }
    }

    private static void loadDefinition(IResourceManager resourceManager, ResourceLocation resourceLocation, List<Tuple<ModelBlockDefinition, String>> referencesToUpdate) {
        DungeonCrawl.LOGGER.debug("Loading {}", (Object)resourceLocation);
        JsonParser parser = new JsonParser();
        HashMap<Block, DungeonModelBlockType> definition = new HashMap<Block, DungeonModelBlockType>();
        try {
            JsonObject object = parser.parse((Reader)new InputStreamReader(resourceManager.func_199002_a(resourceLocation).func_199027_b())).getAsJsonObject();
            object.getAsJsonObject("definition").entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key));
                if (block != null) {
                    String value = ((JsonElement)entry.getValue()).getAsString().toUpperCase();
                    if (DungeonModelBlockType.NAME_TO_TYPE.containsKey(value)) {
                        definition.put(block, DungeonModelBlockType.valueOf(value));
                    } else {
                        DungeonCrawl.LOGGER.warn("Unknown model block type: {}", (Object)value);
                    }
                } else {
                    DungeonCrawl.LOGGER.warn("Unknown block: {}", (Object)key);
                }
            });
            ModelBlockDefinition blockDefinition = new ModelBlockDefinition(definition);
            if (object.has("fallback")) {
                referencesToUpdate.add((Tuple<ModelBlockDefinition, String>)new Tuple((Object)blockDefinition, (Object)object.get("fallback").getAsString()));
            }
            String key = resourceLocation.func_110623_a().substring(PATH.length() + 1, resourceLocation.func_110623_a().length() - ".json".length());
            DEFINITIONS.put(key, blockDefinition);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        DEFAULT.put(Blocks.field_150350_a, null);
        DEFAULT.put(Blocks.field_180401_cv, DungeonModelBlockType.NONE);
        DEFAULT.put(Blocks.field_150390_bg, DungeonModelBlockType.SOLID_STAIRS);
        DEFAULT.put(Blocks.field_150347_e, DungeonModelBlockType.NORMAL);
        DEFAULT.put(Blocks.field_150343_Z, DungeonModelBlockType.NORMAL_2);
        DEFAULT.put(Blocks.field_196696_di, DungeonModelBlockType.SOLID);
        DEFAULT.put(Blocks.field_222413_lB, DungeonModelBlockType.VANILLA_WALL);
        DEFAULT.put(Blocks.field_196662_n, DungeonModelBlockType.MATERIAL);
        DEFAULT.put(Blocks.field_196617_K, DungeonModelBlockType.PILLAR);
        DEFAULT.put(Blocks.field_180413_ao, DungeonModelBlockType.DOOR);
        DEFAULT.put(Blocks.field_150476_ad, DungeonModelBlockType.MATERIAL_STAIRS);
        DEFAULT.put(Blocks.field_196622_bq, DungeonModelBlockType.WOODEN_SLAB);
        DEFAULT.put(Blocks.field_196689_eF, DungeonModelBlockType.WOODEN_BUTTON);
        DEFAULT.put(Blocks.field_180407_aO, DungeonModelBlockType.FENCE);
        DEFAULT.put(Blocks.field_180390_bo, DungeonModelBlockType.FENCE_GATE);
        DEFAULT.put(Blocks.field_196663_cq, DungeonModelBlockType.WOODEN_PRESSURE_PLATE);
        DEFAULT.put(Blocks.field_196636_cW, DungeonModelBlockType.TRAPDOOR);
        DEFAULT.put(Blocks.field_150351_n, DungeonModelBlockType.FLOOR);
        DEFAULT.put(Blocks.field_196659_cl, DungeonModelBlockType.STAIRS);
        DEFAULT.put(Blocks.field_196646_bz, DungeonModelBlockType.SLAB);
        DEFAULT.put(Blocks.field_150474_ac, DungeonModelBlockType.SPAWNER);
        DEFAULT.put(Blocks.field_150486_ae, DungeonModelBlockType.CHEST);
        DEFAULT.put(Blocks.field_222422_lK, DungeonModelBlockType.BARREL);
        DEFAULT.put(Blocks.field_196703_eM, DungeonModelBlockType.SKULL);
        DEFAULT_DEFINITION = new ModelBlockDefinition(DEFAULT);
        DEFINITIONS.put("default", DEFAULT_DEFINITION);
    }
}

