/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.Lists;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.dungeon.model.ModelBlockDefinition;

public class ModelHandler {
    public static void readAndSaveModelToFile(String name, ModelBlockDefinition definition, World world, BlockPos pos, int width, int height, int length) {
        DungeonCrawl.LOGGER.info("Reading and saving {} to disk. Size: {}, {}, {}", (Object)name, (Object)width, (Object)height, (Object)length);
        DungeonModelBlock[][][] model = new DungeonModelBlock[width][height][length];
        ArrayList featurePositions = Lists.newArrayList();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    BlockState state = world.func_180495_p(new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z));
                    if (state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == Blocks.field_150357_h) {
                        model[x][y][z] = null;
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_226904_lY_) {
                        featurePositions.add(new DungeonModel.FeaturePosition(x, y, z, (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)));
                        continue;
                    }
                    model[x][y][z] = new DungeonModelBlock(DungeonModelBlockType.get(state.func_177230_c(), definition)).loadDataFromState(state);
                }
            }
        }
        ModelHandler.writeModelToFile(new DungeonModel(model, featurePositions.isEmpty() ? null : featurePositions.toArray(new DungeonModel.FeaturePosition[0])), ((ServerWorld)world).func_73046_m().func_71238_n().getAbsolutePath() + "/models/" + name + ".nbt");
    }

    public static void writeModelToFile(DungeonModel model, String file) {
        try {
            File f;
            DungeonCrawl.LOGGER.info("Writing a model to disk at {}. ", (Object)file);
            if (model.featurePositions != null) {
                DungeonCrawl.LOGGER.info("There are {} feature positions.", (Object)model.featurePositions.length);
            }
            if (!(f = new File(file)).getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            ModelHandler.convertModelToNBT(model).func_74734_a((DataOutput)new DataOutputStream(new FileOutputStream(file)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static CompoundNBT convertModelToNBT(DungeonModel model) {
        byte width = (byte)(model.width > 127 ? -(model.width - 127) : model.width);
        byte length = (byte)(model.length > 127 ? -(model.length - 127) : model.length);
        byte height = (byte)(model.height > 127 ? -(model.height - 127) : model.height);
        CompoundNBT newModel = new CompoundNBT();
        newModel.func_74774_a("length", length);
        newModel.func_74774_a("height", height);
        newModel.func_74774_a("width", width);
        ListNBT blocks = new ListNBT();
        for (int x = 0; x < model.width; ++x) {
            ListNBT blocks2 = new ListNBT();
            for (int y = 0; y < model.height; ++y) {
                ListNBT blocks3 = new ListNBT();
                for (int z = 0; z < model.length; ++z) {
                    if (model.model[x][y][z] != null) {
                        blocks3.add((Object)model.model[x][y][z].getAsNBT());
                        continue;
                    }
                    blocks3.add((Object)new CompoundNBT());
                }
                blocks2.add((Object)blocks3);
            }
            blocks.add((Object)blocks2);
        }
        if (model.featurePositions != null && model.featurePositions.length > 0) {
            ListNBT list = new ListNBT();
            CompoundNBT amount = new CompoundNBT();
            amount.func_74768_a("amount", model.featurePositions.length);
            list.add((Object)amount);
            for (DungeonModel.FeaturePosition pos : model.featurePositions) {
                CompoundNBT vecCompound = new CompoundNBT();
                vecCompound.func_74768_a("x", pos.position.func_177958_n());
                vecCompound.func_74768_a("y", pos.position.func_177956_o());
                vecCompound.func_74768_a("z", pos.position.func_177952_p());
                if (pos.facing != null) {
                    vecCompound.func_74778_a("facing", pos.facing.toString());
                }
                list.add((Object)vecCompound);
            }
            newModel.func_218657_a("featurePositions", (INBT)list);
        }
        newModel.func_218657_a("model", (INBT)blocks);
        return newModel;
    }

    public static DungeonModel getModelFromNBT(CompoundNBT nbt) {
        int width = nbt.func_74762_e("width");
        int height = nbt.func_74762_e("height");
        int length = nbt.func_74762_e("length");
        ListNBT blocks = nbt.func_150295_c("model", 9);
        DungeonModelBlock[][][] model = new DungeonModelBlock[width][height][length];
        for (int x = 0; x < width; ++x) {
            ListNBT blocks2 = blocks.func_202169_e(x);
            for (int y = 0; y < height; ++y) {
                ListNBT blocks3 = blocks2.func_202169_e(y);
                for (int z = 0; z < length; ++z) {
                    model[x][y][z] = DungeonModelBlock.fromNBT(blocks3.func_150305_b(z));
                }
            }
        }
        DungeonModel.FeaturePosition[] featurePositions = null;
        if (nbt.func_150297_b("featurePositions", 9)) {
            ListNBT list = nbt.func_150295_c("featurePositions", 10);
            int amount = list.func_150305_b(0).func_74762_e("amount");
            featurePositions = new DungeonModel.FeaturePosition[amount];
            for (int i = 1; i < list.size(); ++i) {
                CompoundNBT compound = list.func_150305_b(i);
                featurePositions[i - 1] = compound.func_74764_b("facing") ? new DungeonModel.FeaturePosition(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z"), Direction.valueOf((String)compound.func_74779_i("facing").toUpperCase(Locale.ROOT))) : new DungeonModel.FeaturePosition(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z"));
            }
        }
        return new DungeonModel(model, featurePositions);
    }
}

