/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.gson.JsonObject;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.vector.Vector3i;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.piece.DungeonMultipartModelPiece;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.util.JSONUtils;
import xiroc.dungeoncrawl.util.Orientation;

public class MultipartModelData {
    public static final MultipartModelData EMPTY = new MultipartModelData(-1, DungeonModels.NO_OFFSET, Rotation.NONE);
    public final Vector3i offset;
    public final Rotation rotation;
    @Nullable
    public DungeonModel model;
    @Nullable
    private String key;
    @Nullable
    private Integer id;

    public MultipartModelData(@Nonnull String key, Vector3i offset, Rotation rotation) {
        this.key = key;
        this.offset = offset;
        this.rotation = rotation;
    }

    public MultipartModelData(int id, Vector3i offset, Rotation rotation) {
        this.id = id;
        this.offset = offset;
        this.rotation = rotation;
    }

    public DungeonMultipartModelPiece createMultipartPiece(DungeonPiece parentPiece, DungeonModel parent, Rotation rotation, int x, int y, int z) {
        if (this.model != null) {
            DungeonMultipartModelPiece piece = new DungeonMultipartModelPiece(null, DungeonPiece.DEFAULT_NBT);
            Vector3i pos = Orientation.rotatedMultipartOffset(parent, this.model, this.offset, rotation);
            piece.setRealPosition(x + pos.func_177958_n(), y + pos.func_177956_o(), z + pos.func_177952_p());
            piece.modelID = this.model.id;
            piece.field_186169_c = this.rotation.func_185830_a(rotation);
            piece.stage = parentPiece.stage;
            piece.theme = parentPiece.theme;
            piece.subTheme = parentPiece.subTheme;
            piece.setupBoundingBox();
            return piece;
        }
        throw new RuntimeException("Can't create a multipart piece without a model.");
    }

    public void updateReference() {
        if (this == EMPTY) {
            return;
        }
        if (this.key != null) {
            this.model = DungeonModels.PATH_TO_MODEL.get(this.key);
        } else if (this.id != null) {
            this.model = DungeonModels.MODELS.get(this.id);
        }
        if (this.model == null) {
            throw new RuntimeException("A multipart model data instance does neither have a valid model key nor a valid model id. Model key: " + this.key + ", Model id: " + this.id);
        }
    }

    public static MultipartModelData fromJson(JsonObject object) {
        if (object.has("model_key")) {
            Vector3i offset = object.has("offset") ? JSONUtils.getOffset(object.getAsJsonObject("offset")) : DungeonModels.NO_OFFSET;
            Rotation rotation = object.has("rotation") ? Rotation.valueOf((String)object.get("rotation").getAsString().toUpperCase(Locale.ROOT)) : Rotation.NONE;
            return new MultipartModelData(object.get("model_key").getAsString(), offset, rotation);
        }
        if (object.has("model_id")) {
            Vector3i offset = object.has("offset") ? JSONUtils.getOffset(object.getAsJsonObject("offset")) : DungeonModels.NO_OFFSET;
            Rotation rotation = object.has("rotation") ? Rotation.valueOf((String)object.get("rotation").getAsString().toUpperCase(Locale.ROOT)) : Rotation.NONE;
            return new MultipartModelData(object.get("model_id").getAsInt(), offset, rotation);
        }
        return EMPTY;
    }
}

