/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.MultipartModelData;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.WeightedRandom;

public class DungeonCorridor
extends DungeonPiece {
    public byte[] corridorFeatures;
    public int specialType;

    public DungeonCorridor(TemplateManager manager, CompoundNBT p_i51343_2_) {
        super(StructurePieceTypes.CORRIDOR, p_i51343_2_);
        this.specialType = p_i51343_2_.func_74762_e("specialType");
        if (p_i51343_2_.func_74764_b("corridorFeatures")) {
            this.corridorFeatures = p_i51343_2_.func_74770_j("corridorFeatures");
        }
    }

    @Override
    public void setupModel(DungeonBuilder builder, DungeonModels.ModelCategory layerCategory, List<DungeonPiece> pieces, Random rand) {
        this.modelID = this.connectedSides == 2 && this.isStraight() ? DungeonModels.ModelCategory.get(DungeonModels.ModelCategory.CORRIDOR, layerCategory).roll(rand).intValue() : DungeonModels.ModelCategory.get(DungeonModels.ModelCategory.CORRIDOR_LINKER, layerCategory).roll(rand).intValue();
    }

    public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        int z;
        DungeonModel model = DungeonModels.MODELS.get(this.modelID);
        boolean ew = this.field_186169_c == Rotation.NONE || this.field_186169_c == Rotation.CLOCKWISE_180;
        int x = ew ? this.x : this.x + (9 - model.length) / 2;
        int n = z = ew ? this.z + (9 - model.length) / 2 : this.z;
        if (this.modelID == DungeonModels.CORRIDOR_SECRET_ROOM_ENTRANCE.id || this.modelID == 7) {
            switch (this.field_186169_c) {
                case NONE: {
                    --z;
                    break;
                }
                case CLOCKWISE_90: {
                    ++x;
                    break;
                }
                case CLOCKWISE_180: {
                    ++z;
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    --x;
                }
            }
        }
        BlockPos pos = new BlockPos(x, this.y + DungeonModels.getOffset(this.modelID).func_177956_o(), z);
        this.buildRotated(model, (IWorld)worldIn, structureBoundingBoxIn, pos, Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, this.field_186169_c, false);
        if (model.metadata != null && model.metadata.feature != null && this.featurePositions != null) {
            model.metadata.feature.build((IWorld)worldIn, randomIn, pos, this.featurePositions, structureBoundingBoxIn, this.theme, this.subTheme, this.stage);
        }
        if (this.connectedSides > 2) {
            this.entrances(worldIn, structureBoundingBoxIn, model);
        }
        this.decorate((IWorld)worldIn, pos, model.width, model.height, model.length, Theme.get(this.theme), structureBoundingBoxIn, this.field_74887_e, model);
        if (((Boolean)Config.NO_SPAWNERS.get()).booleanValue()) {
            DungeonCorridor.spawnMobs(worldIn, this, model.width, model.length, new int[]{1});
        }
        return true;
    }

    @Override
    public void addChildPieces(List<DungeonPiece> pieces, DungeonBuilder builder, DungeonModels.ModelCategory layerCategory, int layer, Random rand) {
        DungeonModel model = DungeonModels.MODELS.get(this.modelID);
        if (model != null && model.multipartData != null) {
            int z;
            boolean ew = this.field_186169_c == Rotation.NONE || this.field_186169_c == Rotation.CLOCKWISE_180;
            int x = ew ? this.x : this.x + (9 - model.length) / 2;
            int n = z = ew ? this.z + (9 - model.length) / 2 : this.z;
            if (this.modelID == DungeonModels.CORRIDOR_SECRET_ROOM_ENTRANCE.id || this.modelID == 7) {
                switch (this.field_186169_c) {
                    case NONE: {
                        --z;
                        break;
                    }
                    case CLOCKWISE_90: {
                        ++x;
                        break;
                    }
                    case CLOCKWISE_180: {
                        ++z;
                        break;
                    }
                    case COUNTERCLOCKWISE_90: {
                        --x;
                    }
                }
            }
            for (WeightedRandom<MultipartModelData> randomData : model.multipartData) {
                pieces.add(randomData.roll(rand).createMultipartPiece(this, model, this.field_186169_c, x, this.y, z));
            }
        }
    }

    @Override
    public void setupBoundingBox() {
        Vector3i offset = DungeonModels.getOffset(this.modelID);
        this.field_74887_e = this.modelID == DungeonModels.CORRIDOR_SECRET_ROOM_ENTRANCE.id ? new MutableBoundingBox(this.x - 1, this.y + offset.func_177956_o(), this.z - 1, this.x + 10, this.y + offset.func_177956_o() + 8, this.z + 10) : new MutableBoundingBox(this.x, this.y + offset.func_177956_o(), this.z, this.x + 8, this.y + offset.func_177956_o() + 8, this.z + 8);
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74768_a("specialType", this.specialType);
        if (this.corridorFeatures != null) {
            tagCompound.func_74773_a("corridorFeatures", this.corridorFeatures);
        }
    }

    public boolean isStraight() {
        return this.sides[0] && this.sides[2] || this.sides[1] && this.sides[3];
    }
}

