/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.piece.DungeonCorridor;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.theme.Theme;

public class DungeonCorridorLarge
extends DungeonPiece {
    public int type;
    public int maxCellCount;
    public int[] cells;

    public DungeonCorridorLarge(DungeonCorridor corridor, int type) {
        super(StructurePieceTypes.LARGE_CORRIDOR, DEFAULT_NBT);
        this.sides = corridor.sides;
        this.connectedSides = corridor.connectedSides;
        this.field_186169_c = corridor.field_186169_c;
        this.stage = corridor.stage;
        this.posX = corridor.posX;
        this.posZ = corridor.posZ;
        this.type = type;
    }

    public DungeonCorridorLarge(TemplateManager manager, CompoundNBT nbt) {
        super(StructurePieceTypes.LARGE_CORRIDOR, nbt);
        this.type = nbt.func_74762_e("type");
    }

    @Override
    public void setupModel(DungeonBuilder builder, DungeonModels.ModelCategory layerCategory, List<DungeonPiece> pieces, Random rand) {
        if (this.type == 0) {
            this.modelID = DungeonModels.LARGE_CORRIDOR_START.id;
        } else if (this.type == 1) {
            switch (this.connectedSides) {
                case 2: {
                    if (this.sides[0] && this.sides[2] || this.sides[1] && this.sides[3]) {
                        this.modelID = DungeonModels.LARGE_CORRIDOR_STRAIGHT.id;
                        return;
                    }
                    this.type = 2;
                    this.modelID = DungeonModels.LARGE_CORRIDOR_TURN.id;
                    return;
                }
                case 3: {
                    this.type = 3;
                    this.modelID = DungeonModels.LARGE_CORRIDOR_OPEN.id;
                    return;
                }
            }
            this.modelID = DungeonModels.LARGE_CORRIDOR_STRAIGHT.id;
        }
    }

    public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        BlockPos pos = new BlockPos(this.x, this.y, this.z);
        DungeonModel model = DungeonModels.MODELS.get(this.modelID);
        this.buildRotated(model, (IWorld)worldIn, structureBoundingBoxIn, pos, Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, this.field_186169_c, false);
        this.decorate((IWorld)worldIn, pos, model.width, model.height, model.length, Theme.get(this.theme), structureBoundingBoxIn, this.field_74887_e, model);
        return true;
    }

    @Override
    public void setupBoundingBox() {
        this.field_74887_e = new MutableBoundingBox(this.x, this.y, this.z, this.x + 8, this.y + 8, this.z + 8);
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74768_a("type", this.type);
    }

    @Override
    public boolean hasChildPieces() {
        return false;
    }
}

