/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.block.WeightedRandomBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.theme.Theme;

public class DungeonEntrance
extends DungeonPiece {
    public DungeonEntrance() {
        super(StructurePieceTypes.ENTRANCE);
    }

    public DungeonEntrance(TemplateManager manager, CompoundNBT nbt) {
        super(StructurePieceTypes.ENTRANCE, nbt);
    }

    @Override
    public void setupModel(DungeonBuilder builder, DungeonModels.ModelCategory layerCategory, List<DungeonPiece> pieces, Random rand) {
        if (DungeonModels.ModelCategory.ENTRANCE.members.isEmpty()) {
            DungeonCrawl.LOGGER.warn("The entrance model list is empty. Using the RLD default entrance.");
            this.modelID = DungeonModels.ENTRANCE.id;
        } else {
            this.modelID = DungeonModels.ModelCategory.ENTRANCE.members.get((int)rand.nextInt((int)DungeonModels.ModelCategory.ENTRANCE.members.size())).id;
        }
    }

    public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        int cursorHeight;
        int height = worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, this.x + 4, this.z + 4);
        Theme buildTheme = Theme.get(this.theme);
        Theme.SubTheme sub = Theme.getSub(this.subTheme);
        for (cursorHeight = this.y; cursorHeight < height && height - cursorHeight > 4; cursorHeight += 8) {
            super.build(DungeonModels.STAIRCASE, (IWorld)worldIn, structureBoundingBoxIn, new BlockPos(this.x + 2, cursorHeight, this.z + 2), buildTheme, sub, Treasure.Type.DEFAULT, this.stage, true);
        }
        DungeonModel entrance = DungeonModels.MODELS.get(this.modelID);
        Vector3i offset = DungeonModels.getOffset(entrance.id);
        BlockPos pos = new BlockPos(this.x + offset.func_177958_n(), cursorHeight + offset.func_177956_o(), this.z + offset.func_177952_p());
        this.buildFull(entrance, (IWorld)worldIn, structureBoundingBoxIn, pos, Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.SUPPLY, this.stage, true);
        if (entrance.metadata != null && entrance.metadata.feature != null && this.featurePositions != null) {
            entrance.metadata.feature.build((IWorld)worldIn, randomIn, pos, this.featurePositions, structureBoundingBoxIn, this.theme, this.subTheme, this.stage);
        }
        this.decorate((IWorld)worldIn, pos, entrance.width, entrance.height, entrance.length, Theme.get(this.theme), structureBoundingBoxIn, new MutableBoundingBox(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), pos.func_177958_n() + entrance.width, pos.func_177956_o() + entrance.height, pos.func_177952_p() + entrance.length), entrance);
        return true;
    }

    @Override
    public void setupBoundingBox() {
        DungeonModel model = DungeonModels.MODELS.get(this.modelID);
        Vector3i offset = DungeonModels.getOffset(this.modelID);
        this.field_74887_e = new MutableBoundingBox(this.x + offset.func_177958_n(), this.y + offset.func_177956_o(), this.z + offset.func_177952_p(), this.x + offset.func_177958_n() + model.width - 1, this.y + offset.func_177956_o() + model.height - 1, this.z + offset.func_177952_p() + model.length - 1);
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
    }

    @Override
    public void build(DungeonModel model, IWorld world, MutableBoundingBox boundsIn, BlockPos pos, Theme theme, Theme.SubTheme subTheme, Treasure.Type treasureType, int lootLevel, boolean fillAir) {
        int xStart = Math.max(boundsIn.field_78897_a, pos.func_177958_n()) - pos.func_177958_n();
        int width = Math.min(model.width, boundsIn.field_78893_d - pos.func_177958_n() - xStart + 1);
        int zStart = Math.max(boundsIn.field_78896_c, pos.func_177952_p()) - pos.func_177952_p();
        int length = Math.min(model.length, boundsIn.field_78892_f - pos.func_177952_p() - zStart + 1);
        for (int x = xStart; x < width; ++x) {
            for (int y = 0; y < model.height; ++y) {
                for (int z = zStart; z < length; ++z) {
                    if (model.model[x][y][z] == null) {
                        this.setBlockState(field_202556_l, world, boundsIn, treasureType, pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z, this.theme, lootLevel, DungeonModelBlockType.SOLID);
                        continue;
                    }
                    BlockPos position = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    Tuple<BlockState, Boolean> result = DungeonModelBlock.getBlockState(model.model[x][y][z], Rotation.NONE, world, position, theme, subTheme, WeightedRandomBlock.RANDOM, this.variation, lootLevel);
                    if (result == null) continue;
                    this.setBlockState((BlockState)result.func_76341_a(), world, boundsIn, treasureType, pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z, this.theme, lootLevel, fillAir ? DungeonModelBlockType.SOLID : model.model[x][y][z].type);
                    if (((Boolean)result.func_76340_b()).booleanValue()) {
                        world.func_217349_x(position).func_201594_d(position);
                    }
                    if (y != 0 || !world.func_175623_d(position.func_177977_b()) || model.model[x][0][z].type != DungeonModelBlockType.SOLID) continue;
                    this.buildPillar(world, theme, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), boundsIn);
                }
            }
        }
    }

    @Override
    public void buildFull(DungeonModel model, IWorld world, MutableBoundingBox boundsIn, BlockPos pos, Theme theme, Theme.SubTheme subTheme, Treasure.Type treasureType, int lootLevel, boolean fillAir) {
        for (int x = 0; x < model.width; ++x) {
            for (int y = 0; y < model.height; ++y) {
                for (int z = 0; z < model.length; ++z) {
                    BlockPos position = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    if (!boundsIn.func_175898_b((Vector3i)position)) continue;
                    if (model.model[x][y][z] == null) {
                        this.setBlockState(field_202556_l, world, boundsIn, treasureType, position, this.theme, lootLevel, DungeonModelBlockType.SOLID);
                        continue;
                    }
                    Tuple<BlockState, Boolean> result = DungeonModelBlock.getBlockState(model.model[x][y][z], Rotation.NONE, world, position, theme, subTheme, WeightedRandomBlock.RANDOM, this.variation, lootLevel);
                    if (result == null) continue;
                    this.setBlockState((BlockState)result.func_76341_a(), world, boundsIn, treasureType, position, this.theme, lootLevel, fillAir ? DungeonModelBlockType.SOLID : model.model[x][y][z].type);
                    if (((Boolean)result.func_76340_b()).booleanValue()) {
                        world.func_217349_x(position).func_201594_d(position);
                    }
                    if (y != 0 || !world.func_175623_d(position.func_177977_b()) || model.model[x][0][z].type != DungeonModelBlockType.SOLID) continue;
                    this.buildPillar(world, theme, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), boundsIn);
                }
            }
        }
    }
}

