/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.theme.Theme;

public class DungeonNodeConnector
extends DungeonPiece {
    public DungeonNodeConnector() {
        super(StructurePieceTypes.NODE_CONNECTOR);
    }

    public DungeonNodeConnector(TemplateManager manager, CompoundNBT nbt) {
        super(StructurePieceTypes.NODE_CONNECTOR, nbt);
    }

    public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        DungeonModel model = DungeonModels.MODELS.get(this.modelID);
        BlockPos pos = new BlockPos(this.x, this.y + DungeonModels.getOffset(this.modelID).func_177956_o(), this.z);
        this.buildRotated(model, (IWorld)worldIn, structureBoundingBoxIn, pos, Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, this.field_186169_c, false);
        if (model.metadata != null && model.metadata.feature != null && this.featurePositions != null) {
            model.metadata.feature.build((IWorld)worldIn, randomIn, pos, this.featurePositions, structureBoundingBoxIn, this.theme, this.subTheme, this.stage);
        }
        this.decorate((IWorld)worldIn, pos, model.width, model.height, model.length, Theme.get(this.theme), structureBoundingBoxIn, this.field_74887_e, model);
        return true;
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public void setupModel(DungeonBuilder builder, DungeonModels.ModelCategory layerCategory, List<DungeonPiece> pieces, Random rand) {
        this.modelID = DungeonModels.ModelCategory.get(DungeonModels.ModelCategory.NODE_CONNECTOR, layerCategory).roll(rand);
    }

    public void adjustPositionAndBounds() {
        DungeonModel model = DungeonModels.MODELS.get(this.modelID);
        if (this.field_186169_c == Rotation.NONE || this.field_186169_c == Rotation.CLOCKWISE_180) {
            int minZ = this.z - (model.length - 3) / 2;
            this.field_74887_e = new MutableBoundingBox(this.x, this.y, minZ, this.x + 4, this.y + model.height - 1, minZ + model.length - 1);
        } else {
            int minX = this.x - (model.length - 3) / 2;
            this.field_74887_e = new MutableBoundingBox(minX, this.y, this.z, minX + model.length - 1, this.y + model.height - 1, this.z + 4);
        }
        this.setRealPosition(this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c);
    }

    @Override
    public void setupBoundingBox() {
        DungeonModel model = DungeonModels.MODELS.get(this.modelID);
        Vector3i offset = DungeonModels.getOffset(this.modelID);
        this.field_74887_e = this.field_186169_c == Rotation.NONE || this.field_186169_c == Rotation.CLOCKWISE_180 ? new MutableBoundingBox(this.x, this.y + offset.func_177956_o(), this.z, this.x + 4, this.y + offset.func_177956_o() + model.height - 1, this.z + model.length - 1) : new MutableBoundingBox(this.x, this.y + offset.func_177956_o(), this.z, this.x + model.length - 1, this.y + offset.func_177956_o() + model.height - 1, this.z + 4);
    }
}

