/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.block.Spawner;
import xiroc.dungeoncrawl.dungeon.block.WeightedRandomBlock;
import xiroc.dungeoncrawl.dungeon.decoration.IDungeonDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelFeature;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.MultipartModelData;
import xiroc.dungeoncrawl.dungeon.model.PlacementBehaviour;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.DirectionalBlockPos;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;
import xiroc.dungeoncrawl.util.Orientation;
import xiroc.dungeoncrawl.util.Position2D;
import xiroc.dungeoncrawl.util.WeightedRandom;

public abstract class DungeonPiece
extends StructurePiece {
    public static final CompoundNBT DEFAULT_NBT;
    private static final Set<Block> BLOCKS_NEEDING_POSTPROCESSING;
    public Rotation field_186169_c;
    public int connectedSides;
    public int posX;
    public int posZ;
    public int theme;
    public int subTheme;
    public int x;
    public int y;
    public int z;
    public int stage;
    public int modelID;
    public boolean[] sides = new boolean[4];
    public DirectionalBlockPos[] featurePositions;
    public byte[] variation;

    public DungeonPiece(IStructurePieceType p_i51343_1_) {
        super(p_i51343_1_, DEFAULT_NBT);
        this.field_186169_c = Rotation.NONE;
    }

    public DungeonPiece(IStructurePieceType p_i51343_1_, CompoundNBT p_i51343_2_) {
        super(p_i51343_1_, p_i51343_2_);
        this.sides[0] = p_i51343_2_.func_74767_n("north");
        this.sides[1] = p_i51343_2_.func_74767_n("east");
        this.sides[2] = p_i51343_2_.func_74767_n("south");
        this.sides[3] = p_i51343_2_.func_74767_n("west");
        this.connectedSides = p_i51343_2_.func_74762_e("connectedSides");
        this.posX = p_i51343_2_.func_74762_e("posX");
        this.posZ = p_i51343_2_.func_74762_e("posZ");
        this.x = p_i51343_2_.func_74762_e("x");
        this.y = p_i51343_2_.func_74762_e("y");
        this.z = p_i51343_2_.func_74762_e("z");
        this.theme = p_i51343_2_.func_74762_e("theme");
        this.subTheme = p_i51343_2_.func_74762_e("subTheme");
        this.stage = p_i51343_2_.func_74762_e("stage");
        this.modelID = p_i51343_2_.func_74762_e("model");
        this.field_186169_c = Orientation.getRotation(p_i51343_2_.func_74762_e("rotation"));
        if (p_i51343_2_.func_150297_b("featurePositions", 9)) {
            this.featurePositions = DungeonPiece.readAllPositions(p_i51343_2_.func_150295_c("featurePositions", 10));
        }
        if (p_i51343_2_.func_74764_b("variation")) {
            this.variation = p_i51343_2_.func_74770_j("variation");
        }
        this.setupBoundingBox();
    }

    public abstract int getType();

    public abstract void setupModel(DungeonBuilder var1, DungeonModels.ModelCategory var2, List<DungeonPiece> var3, Random var4);

    public abstract void setupBoundingBox();

    public void openSide(Direction side) {
        switch (side) {
            case NORTH: {
                if (this.sides[0]) {
                    return;
                }
                this.sides[0] = true;
                ++this.connectedSides;
                return;
            }
            case EAST: {
                if (this.sides[1]) {
                    return;
                }
                this.sides[1] = true;
                ++this.connectedSides;
                return;
            }
            case SOUTH: {
                if (this.sides[2]) {
                    return;
                }
                this.sides[2] = true;
                ++this.connectedSides;
                return;
            }
            case WEST: {
                if (this.sides[3]) {
                    return;
                }
                this.sides[3] = true;
                ++this.connectedSides;
                return;
            }
            case UP: {
                if (this.sides[4]) {
                    return;
                }
                this.sides[4] = true;
                ++this.connectedSides;
                return;
            }
            case DOWN: {
                if (this.sides[5]) {
                    return;
                }
                this.sides[5] = true;
                ++this.connectedSides;
                return;
            }
        }
        DungeonCrawl.LOGGER.warn("Failed to open a segment side: Unknown side " + side);
    }

    public void setRotation(Rotation rotation) {
        this.field_186169_c = rotation;
    }

    public Rotation func_214809_Y_() {
        return this.field_186169_c;
    }

    public void setPosition(int x, int z) {
        this.posX = x;
        this.posZ = z;
    }

    public void setPosition(Position2D position) {
        this.posX = position.x;
        this.posZ = position.z;
    }

    public void setRealPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void func_143011_b(CompoundNBT tagCompound) {
        tagCompound.func_74757_a("north", this.sides[0]);
        tagCompound.func_74757_a("east", this.sides[1]);
        tagCompound.func_74757_a("south", this.sides[2]);
        tagCompound.func_74757_a("west", this.sides[3]);
        tagCompound.func_74768_a("connectedSides", this.connectedSides);
        tagCompound.func_74768_a("posX", this.posX);
        tagCompound.func_74768_a("posZ", this.posZ);
        tagCompound.func_74768_a("x", this.x);
        tagCompound.func_74768_a("y", this.y);
        tagCompound.func_74768_a("z", this.z);
        tagCompound.func_74768_a("stage", this.stage);
        tagCompound.func_74768_a("theme", this.theme);
        tagCompound.func_74768_a("subTheme", this.subTheme);
        tagCompound.func_74768_a("model", this.modelID);
        tagCompound.func_74768_a("rotation", Orientation.getInt(this.field_186169_c));
        if (this.featurePositions != null) {
            ListNBT list = new ListNBT();
            DungeonPiece.writeAllPositions(this.featurePositions, list);
            tagCompound.func_218657_a("featurePositions", (INBT)list);
        }
        if (this.variation != null) {
            tagCompound.func_74773_a("variation", this.variation);
        }
    }

    public void customSetup(Random rand) {
        DungeonModel model = DungeonModels.MODELS.get(this.modelID);
        if (model.metadata != null && model.metadata.featureMetadata != null && model.featurePositions != null && model.featurePositions.length > 0) {
            Vector3i offset = DungeonModels.getOffset(this.modelID);
            DungeonModelFeature.setup(this, model, model.featurePositions, this.field_186169_c, rand, model.metadata.featureMetadata, this.x + offset.func_177958_n(), this.y + offset.func_177956_o(), this.z + offset.func_177952_p());
        }
    }

    public void setBlockState(BlockState state, IWorld world, MutableBoundingBox boundsIn, Treasure.Type treasureType, BlockPos pos, int theme, int lootLevel, DungeonModelBlockType type) {
        if (state == null) {
            return;
        }
        if (DungeonPiece.isBlockProtected(world, state, pos) || world.func_175623_d(pos) && !type.isSolid(world, pos, WeightedRandomBlock.RANDOM, 0, 0, 0)) {
            return;
        }
        IBlockPlacementHandler.getHandler(state.func_177230_c()).placeBlock(world, state, pos, world.func_201674_k(), treasureType, theme, lootLevel);
        if (BLOCKS_NEEDING_POSTPROCESSING.contains(state.func_177230_c())) {
            world.func_217349_x(pos).func_201594_d(pos);
        }
    }

    public void setBlockState(BlockState state, IWorld world, MutableBoundingBox boundsIn, Treasure.Type treasureType, BlockPos pos, int theme, int lootLevel, PlacementBehaviour placementBehaviour) {
        if (state == null) {
            return;
        }
        if (DungeonPiece.isBlockProtected(world, state, pos) || world.func_175623_d(pos) && !placementBehaviour.function.isSolid(world, pos, WeightedRandomBlock.RANDOM, 0, 0, 0)) {
            return;
        }
        IBlockPlacementHandler.getHandler(state.func_177230_c()).placeBlock(world, state, pos, world.func_201674_k(), treasureType, theme, lootLevel);
        if (BLOCKS_NEEDING_POSTPROCESSING.contains(state.func_177230_c())) {
            world.func_217349_x(pos).func_201594_d(pos);
        }
    }

    public void setBlockState(BlockState state, IWorld world, MutableBoundingBox boundsIn, Treasure.Type treasureType, int x, int y, int z, int theme, int lootLevel, DungeonModelBlockType type) {
        BlockPos pos = new BlockPos(x, y, z);
        if (state == null) {
            return;
        }
        if (DungeonPiece.isBlockProtected(world, state, pos) || world.func_175623_d(pos) && !type.isSolid(world, pos, WeightedRandomBlock.RANDOM, 0, 0, 0)) {
            return;
        }
        IBlockPlacementHandler.getHandler(state.func_177230_c()).placeBlock(world, state, pos, world.func_201674_k(), treasureType, theme, lootLevel);
        if (BLOCKS_NEEDING_POSTPROCESSING.contains(state.func_177230_c())) {
            world.func_217349_x(pos).func_201594_d(pos);
        }
    }

    public void setBlockState(BlockState state, IWorld world, MutableBoundingBox boundsIn, Treasure.Type treasureType, int x, int y, int z, int theme, int lootLevel, PlacementBehaviour placementBehaviour) {
        BlockPos pos = new BlockPos(x, y, z);
        if (state == null) {
            return;
        }
        if (DungeonPiece.isBlockProtected(world, state, pos) || world.func_175623_d(pos) && !placementBehaviour.function.isSolid(world, pos, WeightedRandomBlock.RANDOM, 0, 0, 0)) {
            return;
        }
        IBlockPlacementHandler.getHandler(state.func_177230_c()).placeBlock(world, state, pos, world.func_201674_k(), treasureType, theme, lootLevel);
        if (BLOCKS_NEEDING_POSTPROCESSING.contains(state.func_177230_c())) {
            world.func_217349_x(pos).func_201594_d(pos);
        }
    }

    public void setBlockState(BlockState state, IWorld world, MutableBoundingBox boundsIn, Treasure.Type treasureType, int x, int y, int z, int theme, int lootLevel, boolean fillAir) {
        BlockPos pos = new BlockPos(x, y, z);
        if (state == null) {
            return;
        }
        if (DungeonPiece.isBlockProtected(world, state, pos) || world.func_175623_d(pos) && !fillAir) {
            return;
        }
        IBlockPlacementHandler.getHandler(state.func_177230_c()).placeBlock(world, state, pos, world.func_201674_k(), treasureType, theme, lootLevel);
        if (BLOCKS_NEEDING_POSTPROCESSING.contains(state.func_177230_c())) {
            world.func_217349_x(pos).func_201594_d(pos);
        }
    }

    public void func_175811_a(ISeedReader worldIn, BlockState blockstateIn, int x, int y, int z, MutableBoundingBox boundingboxIn) {
        BlockPos blockPos = new BlockPos(x, y, z);
        if (DungeonPiece.isBlockProtected((IWorld)worldIn, blockstateIn, blockPos)) {
            return;
        }
        worldIn.func_180501_a(blockPos, blockstateIn, 3);
        if (BLOCKS_NEEDING_POSTPROCESSING.contains(blockstateIn.func_177230_c())) {
            worldIn.func_217349_x(blockPos).func_201594_d(blockPos);
        }
    }

    public void replaceBlockState(IWorld worldIn, BlockState blockstateIn, int x, int y, int z, MutableBoundingBox boundingboxIn) {
        BlockPos blockPos = new BlockPos(x, y, z);
        if (DungeonPiece.isBlockProtected(worldIn, blockstateIn, blockPos) || worldIn.func_180495_p(blockPos).isAir((IBlockReader)worldIn, blockPos)) {
            return;
        }
        if (boundingboxIn.func_175898_b((Vector3i)blockPos)) {
            worldIn.func_180501_a(blockPos, blockstateIn, 3);
            if (BLOCKS_NEEDING_POSTPROCESSING.contains(blockstateIn.func_177230_c())) {
                worldIn.func_217349_x(blockPos).func_201594_d(blockPos);
            }
        }
    }

    public boolean hasChildPieces() {
        DungeonModel model = DungeonModels.MODELS.get(this.modelID);
        return model != null && model.multipartData != null;
    }

    public void addChildPieces(List<DungeonPiece> pieces, DungeonBuilder builder, DungeonModels.ModelCategory layerCategory, int layer, Random rand) {
        DungeonModel model = DungeonModels.MODELS.get(this.modelID);
        if (model != null && model.multipartData != null) {
            for (WeightedRandom<MultipartModelData> randomData : model.multipartData) {
                pieces.add(randomData.roll(rand).createMultipartPiece(this, model, this.field_186169_c, this.x, this.y, this.z));
            }
        }
    }

    public static void setBlockState(IWorld worldIn, BlockState blockstateIn, int x, int y, int z, MutableBoundingBox boundingboxIn, boolean fillAir) {
        BlockPos blockPos = new BlockPos(x, y, z);
        if (!fillAir && worldIn.func_175623_d(blockPos)) {
            return;
        }
        if (boundingboxIn.func_175898_b((Vector3i)blockPos)) {
            worldIn.func_180501_a(blockPos, blockstateIn, 2);
            if (BLOCKS_NEEDING_POSTPROCESSING.contains(blockstateIn.func_177230_c())) {
                worldIn.func_217349_x(blockPos).func_201594_d(blockPos);
            }
        }
    }

    public void build(DungeonModel model, IWorld world, MutableBoundingBox boundsIn, BlockPos pos, Theme theme, Theme.SubTheme subTheme, Treasure.Type treasureType, int lootLevel, boolean fillAir) {
        this.buildFull(model, world, boundsIn, pos, theme, subTheme, treasureType, lootLevel, fillAir);
    }

    public void buildFull(DungeonModel model, IWorld world, MutableBoundingBox boundsIn, BlockPos pos, Theme theme, Theme.SubTheme subTheme, Treasure.Type treasureType, int lootLevel, boolean fillAir) {
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Building {} with model id {} at ({} | {} | {})", (Object)model.location, (Object)model.id, (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
        for (int x = 0; x < model.width; ++x) {
            for (int y = model.height - 1; y >= 0; --y) {
                for (int z = 0; z < model.length; ++z) {
                    BlockPos position = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    if (!boundsIn.func_175898_b((Vector3i)position)) continue;
                    if (model.model[x][y][z] == null) {
                        this.setBlockState(field_202556_l, world, boundsIn, treasureType, position, this.theme, lootLevel, PlacementBehaviour.NON_SOLID);
                        continue;
                    }
                    Tuple<BlockState, Boolean> result = DungeonModelBlock.getBlockState(model.model[x][y][z], Rotation.NONE, world, position, theme, subTheme, WeightedRandomBlock.RANDOM, this.variation, lootLevel);
                    if (result == null) continue;
                    this.setBlockState((BlockState)result.func_76341_a(), world, boundsIn, treasureType, position, this.theme, lootLevel, fillAir ? DungeonModelBlockType.SOLID : model.model[x][y][z].type);
                    if (((Boolean)result.func_76340_b()).booleanValue()) {
                        world.func_217349_x(position).func_201594_d(position);
                    }
                    if (y != 0 || model.height <= 1 || !world.func_175623_d(position.func_177977_b()) || model.model[x][1][z] == null || model.model[x][0][z].type != DungeonModelBlockType.SOLID || model.model[x][1][z].type != DungeonModelBlockType.SOLID) continue;
                    this.buildPillar(world, theme, pos.func_177958_n() + x, pos.func_177956_o(), pos.func_177952_p() + z, boundsIn);
                }
            }
        }
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Finished building {} with model id {} at ({} | {} | {})", (Object)model.location, (Object)model.id, (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
    }

    public void buildRotated(DungeonModel model, IWorld world, MutableBoundingBox boundsIn, BlockPos pos, Theme theme, Theme.SubTheme subTheme, Treasure.Type treasureType, int lootLevel, Rotation rotation, boolean fillAir) {
        this.buildRotatedFull(model, world, boundsIn, pos, theme, subTheme, treasureType, lootLevel, rotation, fillAir);
    }

    public void buildRotatedFull(DungeonModel model, IWorld world, MutableBoundingBox boundsIn, BlockPos pos, Theme theme, Theme.SubTheme subTheme, Treasure.Type treasureType, int lootLevel, Rotation rotation, boolean fillAir) {
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Building {} with model id {} and rotation {} at ({} | {} | {})", (Object)model.location, (Object)model.id, (Object)rotation, (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
        switch (rotation) {
            case CLOCKWISE_90: {
                for (int x = 0; x < model.width; ++x) {
                    for (int y = model.height - 1; y >= 0; --y) {
                        for (int z = 0; z < model.length; ++z) {
                            BlockPos position = new BlockPos(pos.func_177958_n() + model.length - z - 1, pos.func_177956_o() + y, pos.func_177952_p() + x);
                            if (!boundsIn.func_175898_b((Vector3i)position)) continue;
                            if (model.model[x][y][z] == null) {
                                this.setBlockState(field_202556_l, world, boundsIn, treasureType, position, this.theme, lootLevel, PlacementBehaviour.NON_SOLID);
                                continue;
                            }
                            Tuple<BlockState, Boolean> result = DungeonModelBlock.getBlockState(model.model[x][y][z], Rotation.CLOCKWISE_90, world, position, theme, subTheme, WeightedRandomBlock.RANDOM, this.variation, lootLevel);
                            if (result == null) continue;
                            this.setBlockState((BlockState)result.func_76341_a(), world, boundsIn, treasureType, position, this.theme, lootLevel, fillAir ? DungeonModelBlockType.SOLID : model.model[x][y][z].type);
                            if (((Boolean)result.func_76340_b()).booleanValue()) {
                                world.func_217349_x(position).func_201594_d(position);
                            }
                            if (y != 0 || model.height <= 1 || !world.func_175623_d(position.func_177977_b()) || model.model[x][1][z] == null || model.model[x][0][z].type != DungeonModelBlockType.SOLID || model.model[x][1][z].type != DungeonModelBlockType.SOLID) continue;
                            this.buildPillar(world, theme, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), boundsIn);
                        }
                    }
                }
                break;
            }
            case COUNTERCLOCKWISE_90: {
                for (int x = 0; x < model.width; ++x) {
                    for (int y = model.height - 1; y >= 0; --y) {
                        for (int z = 0; z < model.length; ++z) {
                            BlockPos position = new BlockPos(pos.func_177958_n() + z, pos.func_177956_o() + y, pos.func_177952_p() + model.width - x - 1);
                            if (!boundsIn.func_175898_b((Vector3i)position)) continue;
                            if (model.model[x][y][z] == null) {
                                this.setBlockState(field_202556_l, world, boundsIn, treasureType, position, this.theme, lootLevel, PlacementBehaviour.NON_SOLID);
                                continue;
                            }
                            Tuple<BlockState, Boolean> result = DungeonModelBlock.getBlockState(model.model[x][y][z], Rotation.COUNTERCLOCKWISE_90, world, position, theme, subTheme, WeightedRandomBlock.RANDOM, this.variation, lootLevel);
                            if (result == null) continue;
                            this.setBlockState((BlockState)result.func_76341_a(), world, boundsIn, treasureType, position, this.theme, lootLevel, fillAir ? DungeonModelBlockType.SOLID : model.model[x][y][z].type);
                            if (((Boolean)result.func_76340_b()).booleanValue()) {
                                world.func_217349_x(position).func_201594_d(position);
                            }
                            if (y != 0 || model.height <= 1 || !world.func_175623_d(position.func_177977_b()) || model.model[x][1][z] == null || model.model[x][0][z].type != DungeonModelBlockType.SOLID || model.model[x][1][z].type != DungeonModelBlockType.SOLID) continue;
                            this.buildPillar(world, theme, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), boundsIn);
                        }
                    }
                }
                break;
            }
            case CLOCKWISE_180: {
                for (int x = 0; x < model.width; ++x) {
                    for (int y = model.height - 1; y >= 0; --y) {
                        for (int z = 0; z < model.length; ++z) {
                            BlockPos position = new BlockPos(pos.func_177958_n() + model.width - x - 1, pos.func_177956_o() + y, pos.func_177952_p() + model.length - z - 1);
                            if (!boundsIn.func_175898_b((Vector3i)position)) continue;
                            if (model.model[x][y][z] == null) {
                                this.setBlockState(field_202556_l, world, boundsIn, treasureType, position, this.theme, lootLevel, PlacementBehaviour.NON_SOLID);
                                continue;
                            }
                            Tuple<BlockState, Boolean> result = DungeonModelBlock.getBlockState(model.model[x][y][z], Rotation.CLOCKWISE_180, world, position, theme, subTheme, WeightedRandomBlock.RANDOM, this.variation, lootLevel);
                            if (result == null) continue;
                            this.setBlockState((BlockState)result.func_76341_a(), world, boundsIn, treasureType, position, this.theme, lootLevel, fillAir ? DungeonModelBlockType.SOLID : model.model[x][y][z].type);
                            if (((Boolean)result.func_76340_b()).booleanValue()) {
                                world.func_217349_x(position).func_201594_d(position);
                            }
                            if (y != 0 || model.height <= 1 || !world.func_175623_d(position.func_177977_b()) || model.model[x][1][z] == null || model.model[x][0][z].type != DungeonModelBlockType.SOLID || model.model[x][1][z].type != DungeonModelBlockType.SOLID) continue;
                            this.buildPillar(world, theme, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), boundsIn);
                        }
                    }
                }
                break;
            }
            case NONE: {
                this.buildFull(model, world, boundsIn, pos, theme, subTheme, treasureType, lootLevel, fillAir);
                break;
            }
            default: {
                DungeonCrawl.LOGGER.warn("Failed to build a rotated dungeon segment: Unsupported rotation " + rotation);
            }
        }
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Finished building {} with model id {} and rotation {} at ({} | {} | {})", (Object)model.location, (Object)model.id, (Object)rotation, (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
    }

    public void buildPillar(IWorld world, Theme theme, int x, int y, int z, MutableBoundingBox bounds) {
        int height = DungeonPiece.getGroundHeightFrom(world, x, z, y - 1);
        for (int y0 = y - 1; y0 > height; --y0) {
            DungeonPiece.setBlockState(world, theme.solid.get(), x, y0, z, bounds, true);
        }
    }

    public void entrances(ISeedReader world, MutableBoundingBox bounds, DungeonModel model) {
        int z0;
        int y0;
        int x0;
        int pathStartX = (model.width - 3) / 2;
        int pathStartZ = (model.length - 3) / 2;
        if (this.sides[0]) {
            for (x0 = pathStartX; x0 < pathStartX + 3; ++x0) {
                for (y0 = 1; y0 < 4; ++y0) {
                    this.func_175811_a(world, field_202556_l, this.x + x0, this.y + y0, this.z, bounds);
                }
            }
        }
        if (this.sides[1]) {
            for (z0 = pathStartZ; z0 < pathStartZ + 3; ++z0) {
                for (y0 = 1; y0 < 4; ++y0) {
                    this.func_175811_a(world, field_202556_l, this.x + model.width - 1, this.y + y0, this.z + z0, bounds);
                }
            }
        }
        if (this.sides[2]) {
            for (x0 = pathStartX; x0 < pathStartX + 3; ++x0) {
                for (y0 = 1; y0 < 4; ++y0) {
                    this.func_175811_a(world, field_202556_l, this.x + x0, this.y + y0, this.z + model.length - 1, bounds);
                }
            }
        }
        if (this.sides[3]) {
            for (z0 = pathStartZ; z0 < pathStartZ + 3; ++z0) {
                for (y0 = 1; y0 < 4; ++y0) {
                    this.func_175811_a(world, field_202556_l, this.x, this.y + y0, this.z + z0, bounds);
                }
            }
        }
    }

    public void decorate(IWorld world, BlockPos pos, int width, int height, int length, Theme theme, MutableBoundingBox worldGenBounds, MutableBoundingBox structureBounds, DungeonModel model) {
        if (theme.decorations != null) {
            for (IDungeonDecoration decoration : theme.decorations) {
                if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
                    DungeonCrawl.LOGGER.debug("Running decoration {} of {} ({}) at ({} | {} | {})", (Object)decoration.toString(), (Object)model.location, (Object)model.id, (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
                }
                decoration.decorate(model, world, pos, width, height, length, worldGenBounds, structureBounds, this, this.stage);
                if (!((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) continue;
                DungeonCrawl.LOGGER.debug("Finished decoration {} of {} ({}) at ({} | {} | {})", (Object)decoration.toString(), (Object)model.location, (Object)model.id, (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
            }
        }
    }

    public static void buildBoundingBox(IWorld world, MutableBoundingBox box, Block block) {
        BlockState state = block.func_176223_P();
        for (int x0 = box.field_78897_a; x0 < box.field_78893_d; ++x0) {
            world.func_180501_a(new BlockPos(x0, box.field_78895_b, box.field_78896_c), state, 2);
            world.func_180501_a(new BlockPos(x0, box.field_78895_b, box.field_78892_f), state, 2);
            world.func_180501_a(new BlockPos(x0, box.field_78894_e, box.field_78896_c), state, 2);
            world.func_180501_a(new BlockPos(x0, box.field_78894_e, box.field_78892_f), state, 2);
        }
        for (int y0 = box.field_78895_b; y0 < box.field_78894_e; ++y0) {
            world.func_180501_a(new BlockPos(box.field_78897_a, y0, box.field_78896_c), state, 2);
            world.func_180501_a(new BlockPos(box.field_78897_a, y0, box.field_78892_f), state, 2);
            world.func_180501_a(new BlockPos(box.field_78893_d, y0, box.field_78896_c), state, 2);
            world.func_180501_a(new BlockPos(box.field_78893_d, y0, box.field_78892_f), state, 2);
        }
        for (int z0 = box.field_78896_c; z0 < box.field_78892_f; ++z0) {
            world.func_180501_a(new BlockPos(box.field_78897_a, box.field_78895_b, z0), state, 2);
            world.func_180501_a(new BlockPos(box.field_78897_a, box.field_78894_e, z0), state, 2);
            world.func_180501_a(new BlockPos(box.field_78893_d, box.field_78895_b, z0), state, 2);
            world.func_180501_a(new BlockPos(box.field_78893_d, box.field_78894_e, z0), state, 2);
        }
        world.func_180501_a(new BlockPos(box.field_78893_d, box.field_78894_e, box.field_78892_f), state, 2);
    }

    public static Direction getOneWayDirection(DungeonPiece piece) {
        if (piece.sides[0]) {
            return Direction.NORTH;
        }
        if (piece.sides[1]) {
            return Direction.EAST;
        }
        if (piece.sides[2]) {
            return Direction.SOUTH;
        }
        if (piece.sides[3]) {
            return Direction.WEST;
        }
        return Direction.NORTH;
    }

    public int getAirBlocks(IWorld worldIn, int x, int y, int z, int width, int length) {
        int airBlocks = 0;
        for (int i = x; i < x + width; ++i) {
            for (int j = z; j < z + length; ++j) {
                Block block = worldIn.func_180495_p(new BlockPos(i, y, j)).func_177230_c();
                if (block != Blocks.field_150350_a && block != Blocks.field_201941_jj) continue;
                ++airBlocks;
            }
        }
        return airBlocks;
    }

    public int getBlocks(IWorld worldIn, Block type, int x, int y, int z, int width, int length) {
        int blocks = 0;
        for (int i = x; i < x + width; ++i) {
            for (int j = z; j < z + length; ++j) {
                Block block = worldIn.func_180495_p(new BlockPos(i, y, j)).func_177230_c();
                if (block != type) continue;
                ++blocks;
            }
        }
        return blocks;
    }

    public void openAdditionalSides(@Nullable DungeonPiece piece) {
        if (piece != null) {
            for (int i = 0; i < piece.sides.length; ++i) {
                if (this.sides[i] || !piece.sides[i]) continue;
                this.sides[i] = true;
            }
        }
    }

    public boolean canConnect(Direction side) {
        return true;
    }

    public Direction getSideForConnection(Direction base) {
        switch (base) {
            case NORTH: {
                if (this.canConnect(Direction.EAST)) {
                    return Direction.EAST;
                }
                if (this.canConnect(Direction.WEST)) {
                    return Direction.WEST;
                }
                if (this.canConnect(Direction.SOUTH)) {
                    return Direction.SOUTH;
                }
                return null;
            }
            case EAST: {
                if (this.canConnect(Direction.NORTH)) {
                    return Direction.NORTH;
                }
                if (this.canConnect(Direction.SOUTH)) {
                    return Direction.SOUTH;
                }
                if (this.canConnect(Direction.WEST)) {
                    return Direction.WEST;
                }
                return null;
            }
            case SOUTH: {
                if (this.canConnect(Direction.EAST)) {
                    return Direction.EAST;
                }
                if (this.canConnect(Direction.WEST)) {
                    return Direction.WEST;
                }
                if (this.canConnect(Direction.NORTH)) {
                    return Direction.NORTH;
                }
                return null;
            }
            case WEST: {
                if (this.canConnect(Direction.NORTH)) {
                    return Direction.NORTH;
                }
                if (this.canConnect(Direction.SOUTH)) {
                    return Direction.SOUTH;
                }
                if (this.canConnect(Direction.EAST)) {
                    return Direction.EAST;
                }
                return null;
            }
        }
        return null;
    }

    public boolean hasAlternativePath() {
        return false;
    }

    public Tuple<Position2D, Position2D> getAlternativePath(Position2D current, Position2D end) {
        return null;
    }

    public static void spawnMobs(ISeedReader world, DungeonPiece piece, int width, int length, int[] floors) {
        for (int floor : floors) {
            for (int x = 1; x < width; ++x) {
                for (int z = 1; z < length; ++z) {
                    EntityType<?> mob;
                    Entity entity;
                    BlockPos pos = new BlockPos(piece.x + x, piece.y + floor + 1, piece.z + z);
                    if (!piece.field_74887_e.func_175898_b((Vector3i)pos) || !world.func_180495_p(pos).isAir((IBlockReader)world, pos) || !(world.func_201674_k().nextDouble() < (Double)Config.MOB_SPAWN_RATE.get()) || !((entity = (mob = Spawner.getRandomEntityType(world.func_201674_k())).func_200721_a((World)world.func_201672_e())) instanceof MonsterEntity)) continue;
                    MonsterEntity mobEntity = (MonsterEntity)entity;
                    mobEntity.func_70691_i(mobEntity.func_110138_aP());
                    mobEntity.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, 0.0f);
                    Spawner.equipMonster(mobEntity, world.func_201674_k(), piece.stage);
                    mobEntity.func_213386_a((IServerWorld)world, world.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                    world.func_217376_c((Entity)mobEntity);
                }
            }
        }
    }

    public static Direction getOpenSide(DungeonPiece piece, int n) {
        int c = 0;
        for (int i = 0; i < 4; ++i) {
            if (!piece.sides[i] || c++ != n) continue;
            return DungeonPiece.getDirectionFromInt(i);
        }
        DungeonCrawl.LOGGER.error("getOpenSide(" + (Object)((Object)piece) + ", " + n + ") malfunctioned. This error did most likely occur due to an error in the mod and might result in wrongly formed dungeons. (" + piece.connectedSides + " open sides)");
        return Direction.NORTH;
    }

    public static Direction getDirectionFromInt(int dir) {
        switch (dir) {
            case 1: {
                return Direction.EAST;
            }
            case 2: {
                return Direction.SOUTH;
            }
            case 3: {
                return Direction.WEST;
            }
        }
        return Direction.NORTH;
    }

    public static void addWalls(DungeonPiece piece, IWorld world, MutableBoundingBox boundsIn, int theme) {
        int z;
        int y;
        int x;
        Theme buildTheme = Theme.get(theme);
        if (!piece.sides[0]) {
            for (x = 2; x < 6; ++x) {
                for (y = 2; y < 6; ++y) {
                    piece.setBlockState(buildTheme.solid.get(), world, boundsIn, null, piece.x + x, piece.y + y, piece.z, theme, 0, true);
                }
            }
        }
        if (!piece.sides[1]) {
            for (z = 2; z < 6; ++z) {
                for (y = 2; y < 6; ++y) {
                    piece.setBlockState(buildTheme.solid.get(), world, boundsIn, null, piece.x + 7, piece.y + y, piece.z + z, theme, 0, true);
                }
            }
        }
        if (!piece.sides[2]) {
            for (x = 2; x < 6; ++x) {
                for (y = 2; y < 6; ++y) {
                    piece.setBlockState(buildTheme.solid.get(), world, boundsIn, null, piece.x + x, piece.y + y, piece.z + 7, theme, 0, true);
                }
            }
        }
        if (!piece.sides[3]) {
            for (z = 2; z < 6; ++z) {
                for (y = 2; y < 6; ++y) {
                    piece.setBlockState(buildTheme.solid.get(), world, boundsIn, null, piece.x, piece.y + y, piece.z + z, theme, 0, true);
                }
            }
        }
    }

    public static void addColumns(DungeonPiece piece, IWorld world, MutableBoundingBox boundsIn, int ySub, int theme) {
        Theme buildTheme = Theme.get(theme);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.solidStairs.get().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.SOUTH)).func_206870_a((Property)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, boundsIn, null, piece.x + 2, piece.y - ySub, piece.z + 2, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.solidStairs.get().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.SOUTH)).func_206870_a((Property)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, boundsIn, null, piece.x + 3, piece.y - ySub, piece.z + 2, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.solidStairs.get().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.SOUTH)).func_206870_a((Property)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, boundsIn, null, piece.x + 4, piece.y - ySub, piece.z + 2, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.solidStairs.get().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.SOUTH)).func_206870_a((Property)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, boundsIn, null, piece.x + 5, piece.y - ySub, piece.z + 2, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.solidStairs.get().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((Property)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, boundsIn, null, piece.x + 2, piece.y - ySub, piece.z + 5, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.solidStairs.get().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((Property)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, boundsIn, null, piece.x + 3, piece.y - ySub, piece.z + 5, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.solidStairs.get().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((Property)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, boundsIn, null, piece.x + 4, piece.y - ySub, piece.z + 5, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.solidStairs.get().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((Property)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, boundsIn, null, piece.x + 5, piece.y - ySub, piece.z + 5, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.solidStairs.get().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.EAST)).func_206870_a((Property)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, boundsIn, null, piece.x + 2, piece.y - ySub, piece.z + 3, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.solidStairs.get().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.EAST)).func_206870_a((Property)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, boundsIn, null, piece.x + 2, piece.y - ySub, piece.z + 4, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.solidStairs.get().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.WEST)).func_206870_a((Property)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, boundsIn, null, piece.x + 5, piece.y - ySub, piece.z + 3, theme, 0, true);
        piece.setBlockState((BlockState)((BlockState)((BlockState)buildTheme.solidStairs.get().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.WEST)).func_206870_a((Property)BlockStateProperties.field_208164_Q, (Comparable)Half.TOP)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), world, boundsIn, null, piece.x + 5, piece.y - ySub, piece.z + 4, theme, 0, true);
        for (int x = 3; x < 5; ++x) {
            for (int z = 3; z < 5; ++z) {
                int groundHeight = DungeonPiece.getGroundHeightFrom(world, piece.x + x, piece.z + z, piece.y - ySub);
                for (int y = piece.y - ySub; y > groundHeight; --y) {
                    piece.setBlockState(buildTheme.column.get(), world, boundsIn, null, piece.x + x, y, piece.z + z, theme, 0, true);
                }
            }
        }
    }

    public static DirectionalBlockPos[] readAllPositions(ListNBT nbt) {
        DirectionalBlockPos[] positions = new DirectionalBlockPos[nbt.size()];
        for (int i = 0; i < positions.length; ++i) {
            positions[i] = DirectionalBlockPos.fromNBT(nbt.func_150305_b(i));
        }
        return positions;
    }

    public static void writeAllPositions(DirectionalBlockPos[] positions, ListNBT nbt) {
        for (DirectionalBlockPos directionalBlockPos : positions) {
            CompoundNBT position = new CompoundNBT();
            directionalBlockPos.writeToNBT(position);
            nbt.add((Object)position);
        }
    }

    public static int getGroundHeightFrom(IWorld world, int x, int z, int yStart) {
        for (int y = yStart; y > 0; --y) {
            if (!world.func_180495_p(new BlockPos(x, y, z)).func_200132_m()) continue;
            return y;
        }
        return 0;
    }

    public static boolean isBlockProtected(IWorld world, BlockState state, BlockPos pos) {
        return state.func_185887_b((IBlockReader)world, pos) < 0.0f || BlockTags.field_226154_ad_.func_230235_a_((Object)state.func_177230_c());
    }

    static {
        BLOCKS_NEEDING_POSTPROCESSING = ImmutableSet.builder().add((Object)Blocks.field_150411_aY).build();
        DEFAULT_NBT = new CompoundNBT();
        DEFAULT_NBT.func_74757_a("north", false);
        DEFAULT_NBT.func_74757_a("east", false);
        DEFAULT_NBT.func_74757_a("south", false);
        DEFAULT_NBT.func_74757_a("west", false);
        DEFAULT_NBT.func_74768_a("connectedSides", 0);
        DEFAULT_NBT.func_74768_a("posX", -1);
        DEFAULT_NBT.func_74768_a("posZ", -1);
        DEFAULT_NBT.func_74768_a("theme", 0);
        DEFAULT_NBT.func_74768_a("stage", -1);
        DEFAULT_NBT.func_74768_a("rotation", 0);
    }
}

