/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.theme.Theme;

public class DungeonStairs
extends DungeonPiece {
    private static final BlockState IRON_BARS = Blocks.field_150411_aY.func_176223_P();
    public int stairType;

    public DungeonStairs(TemplateManager manager, CompoundNBT p_i51343_2_) {
        super(StructurePieceTypes.STAIRS, p_i51343_2_);
        this.stairType = p_i51343_2_.func_74762_e("stairType");
    }

    @Override
    public void setupModel(DungeonBuilder builder, DungeonModels.ModelCategory layerCategory, List<DungeonPiece> pieces, Random rand) {
        switch (this.stairType) {
            case 0: {
                this.modelID = this.stage > 0 ? DungeonModels.STAIRS_BOTTOM_2.id : DungeonModels.STAIRS_BOTTOM.id;
                return;
            }
            case 1: {
                this.modelID = DungeonModels.STAIRS_TOP.id;
            }
        }
    }

    public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        BlockPos pos = new BlockPos(this.x, this.y, this.z);
        switch (this.stairType) {
            case 0: {
                DungeonModel model = DungeonModels.MODELS.get(this.modelID);
                this.build(model, (IWorld)worldIn, structureBoundingBoxIn, pos, Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, false);
                this.ironBars((IWorld)worldIn, structureBoundingBoxIn, model);
                if (model.metadata != null && model.metadata.feature != null && this.featurePositions != null) {
                    model.metadata.feature.build((IWorld)worldIn, randomIn, pos, this.featurePositions, structureBoundingBoxIn, this.theme, this.subTheme, this.stage);
                }
                this.decorate((IWorld)worldIn, pos, model.width, model.height, model.length, Theme.get(this.theme), structureBoundingBoxIn, this.field_74887_e, model);
                return true;
            }
            case 1: {
                DungeonModel model = DungeonModels.MODELS.get(this.modelID);
                this.build(model, (IWorld)worldIn, structureBoundingBoxIn, pos, Theme.get(this.theme), Theme.getSub(this.subTheme), Treasure.Type.DEFAULT, this.stage, false);
                this.entrances(worldIn, structureBoundingBoxIn, model);
                if (model.metadata != null && model.metadata.feature != null && this.featurePositions != null) {
                    model.metadata.feature.build((IWorld)worldIn, randomIn, pos, this.featurePositions, structureBoundingBoxIn, this.theme, this.subTheme, this.stage);
                }
                this.decorate((IWorld)worldIn, pos, model.width, model.height, model.length, Theme.get(this.theme), structureBoundingBoxIn, this.field_74887_e, model);
                return true;
            }
        }
        return true;
    }

    public void ironBars(IWorld world, MutableBoundingBox bounds, DungeonModel model) {
        int z0;
        int y0;
        int x0;
        int pathStartX = (model.width - 3) / 2;
        int pathStartZ = (model.length - 3) / 2;
        if (this.sides[0]) {
            for (x0 = pathStartX; x0 < pathStartX + 3; ++x0) {
                for (y0 = 1; y0 < 4; ++y0) {
                    this.replaceBlockState(world, IRON_BARS, this.x + x0, this.y + y0, this.z, bounds);
                }
            }
        }
        if (this.sides[1]) {
            for (z0 = pathStartZ; z0 < pathStartZ + 3; ++z0) {
                for (y0 = 1; y0 < 4; ++y0) {
                    this.replaceBlockState(world, IRON_BARS, this.x + model.width - 1, this.y + y0, this.z + z0, bounds);
                }
            }
        }
        if (this.sides[2]) {
            for (x0 = pathStartX; x0 < pathStartX + 3; ++x0) {
                for (y0 = 1; y0 < 4; ++y0) {
                    this.replaceBlockState(world, IRON_BARS, this.x + x0, this.y + y0, this.z + model.length - 1, bounds);
                }
            }
        }
        if (this.sides[3]) {
            for (z0 = pathStartZ; z0 < pathStartZ + 3; ++z0) {
                for (y0 = 1; y0 < 4; ++y0) {
                    this.replaceBlockState(world, IRON_BARS, this.x, this.y + y0, this.z + z0, bounds);
                }
            }
        }
    }

    @Override
    public void setupBoundingBox() {
        this.field_74887_e = new MutableBoundingBox(this.x, this.y, this.z, this.x + 8, this.y + 8, this.z + 8);
    }

    @Override
    public boolean canConnect(Direction side) {
        return true;
    }

    public DungeonStairs bottom() {
        this.stairType = 0;
        return this;
    }

    public DungeonStairs top() {
        this.stairType = 1;
        return this;
    }

    @Override
    public void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74768_a("stairType", this.stairType);
    }

    @Override
    public int getType() {
        return 1;
    }
}

